/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include "saol_sched.h"

void myheader(), mytrstart(), mytrend(), mynon(), mynoff(),
mypressure(), myparameter(), mypitchbend(), myprogram(),
mychanpressure(), mysisex(), mymmisc(), mymspecial(), mymtext(),
mymseq(), mymeot(), mykeysig(), mytempo(), mytimesig(), mysmpte(),
myarb();


void myheader(int format, int ntrks, int division) {
  if (division & 0x8000) { /* SMPTE */
    times = 0;		 /* Can't do beats */
  } else
    if (format > 2) {
    fprintf(stderr, "Can't deal with format %d MIDIfiles\n", format);
    exit (1);
  }
  Clicks = division;
}

void mytrstart() {
}

void mytrend() {
}

void mynon(int chan, int pitch, int vol) {
  event *ev;
  char s[10];

  PROT_MAL(ev, event, mynon);
  sprintf(s,"Chan %d",chan);
  ev->name = midichan_inst(cur_sa,chan);
  ev->label = strdup(s);
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = MIDI_ON_EVENT;
  ev->dur = -1;
  ev->val = (double *)malloc(sizeof(double)*2);
  ev->val[0] = pitch;
  ev->val[1] = vol;
  ev->numval = 1;
  schedule_event(cur_sa,ev);
}

void mynoff(int chan, int pitch, int vol) {
  event *ev;
  char s[10];

  PROT_MAL(ev, event, mynoff);
  ev->name = midichan_inst(cur_sa,chan);
  ev->label = NULL;
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = MIDI_OFF_EVENT;
  ev->dur = 0;
  ev->val = (double *)malloc(sizeof(double));
  ev->val[0] = pitch;
  ev->numval = 1;
  schedule_event(cur_sa,ev);
}

void mypressure(int chan, int pitch, int vol) {
  printf("Can't handle note aftertouch.\n");
}

void myparameter(int chan, int control, int value) {
  event *ev;
  char s[10];
  
  PROT_MAL(ev, event,mynon);
  sprintf(s,"MIDIctrl");
  ev->name = strdup(s);
  sprintf(s,"Chan %d",chan);
  ev->label = strdup(s);
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = MIDI_CONTROL_EVENT;
  ev->dur = 0;
  ev->val = (double *)malloc(sizeof(double) * 2);
  ev->val[0] = control;
  ev->val[1] = value;
  ev->numval = 2;
  schedule_event(cur_sa,ev);
}

void mypitchbend(int chan,int msb,int lsb) {
  event *ev;
  char s[10];
  PROT_MAL(ev,event,mynon);
  sprintf(s,"MIDIbend");
  ev->name = strdup(s);
  sprintf(s,"Chan %d",chan);
  ev->label = strdup(s);
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = MIDI_CONTROL_EVENT;
  ev->dur = 0;
  ev->val = (double *)malloc(sizeof(double));
  ev->val[0] = msb * 128 + lsb;
}

void myprogram(int chan, int program) {
  event *ev;

  PROT_MAL(ev,event,mypitchbend);
  ev->name = NULL;
  ev->label = NULL;
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = PROGRAM_CHANGE_EVENT;
  ev->dur = 0;
  ev->val = (double *)malloc(sizeof(double) *2);
  ev->val[0] = chan;
  ev->val[1] = program;
}

void mychanpressure(int chan,int press) {
  event *ev;
  char s[10];
  
  PROT_MAL(ev,event,mynon);
  sprintf(s,"MIDItouch");
  ev->name = strdup(s);
  sprintf(s,"Chan %d",chan);
  ev->label = strdup(s);
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = MIDI_CONTROL_EVENT;
  ev->dur = 0;
  ev->val = (double *)malloc(sizeof(double));
  ev->val[0] = press;
}

void mysysex(int len, char *mess) {
}

void mymmisc(int type, int len, char *mess) {
}

void mymspecial(int type, int len, char *mess) {
}

void mymtext(int type, int len, char *mess) {
}

void mymseq(int num) {
}

void mymeot() {
}

void mykeysig(int sf, int mi) {
}

void mytempo(int tempo) {
  event *ev;

  PROT_MAL(ev,event,mytempo);
  ev->name = NULL;
  ev->label = NULL;
  ev->h = NULL;
  ev->time = Mf_currtime;
  ev->type = MIDI_TEMPO_EVENT;
  ev->dur = 0;
  ev->val = (double *)malloc(sizeof(double));
  ev->val[0] = tempo;
}
 
void mytimesig(int nn, int dd, int cc, int bb) {
}

void mysmpte(int hr, int mn, int se, int fr, int ff) {
}

void myarb(int leng, char *mess) {
}

void initfuncs()
{
	Mf_error = error;
	Mf_header =  myheader;
	Mf_starttrack =  mytrstart;
	Mf_endtrack =  mytrend;
	Mf_on =  mynon;
	Mf_off =  mynoff;
	Mf_pressure =  mypressure;
	Mf_parameter =  myparameter;
	Mf_pitchbend =  mypitchbend;
	Mf_program =  myprogram;
	Mf_chanpressure =  mychanpressure;
	Mf_sysex =  mysysex;
	Mf_metamisc =  mymmisc;
	Mf_seqnum =  mymseq;
	Mf_eot =  mymeot;
	Mf_timesig =  mytimesig;
	Mf_smpte =  mysmpte;
	Mf_tempo =  mytempo;
	Mf_keysig =  mykeysig;
	Mf_sqspecific =  mymspecial;
	Mf_text =  mymtext;
	Mf_arbitrary =  myarbitrary;
}


     
