/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#ifdef _WIN32
#include <string.h>
void srand48(long x) {
  srand((int)x);
}
#else
#include <strings.h>
#endif

int yywrap(void) {
  return 1;
}
#include <time.h>
#include "saol.h"
#include "y.tab.h"
#include "saol_interp.h"
#include "saol_sched.h"
#include "aifif.h"
#include "saol_bitstream.h"

extern int yydebug;
extern FILE *yyin;

void help(void);
extern int yyparse(void);
void saol_startup(sa_decoder *,struct cmdinfo *);
void help(void);
struct cmdinfo cmd;
extern void open_inputs(sa_decoder *sa);

main(int argc, char *argv[]) {
  sa_decoder *sa;
  int text = 0;

#ifdef _WIN32
  _fmode = O_BINARY;
#endif 

  cmd.sco = cmd.orc = cmd.out = cmd.bit = NULL;
  cmd.temp = ".";
  cmd.text = 0;
  cmd.inct = 0;

  yydebug = 0; 
  sa = (sa_decoder *)malloc(sizeof(sa_decoder));
  if (!sa) {
    printf("Fatal: couldn't create SA decoder.\n");
    exit(1);
  }


  srand48((long)time(NULL));
  while (++argv,--argc) {
    if (!strncmp(*argv,"-bit",4)) {cmd.bit = *(++argv); argc--;}
    else if (!strcmp(*argv,"-temp")) {cmd.temp = *(++argv); argc--;}
    else if (!strncmp(*argv,"-sc",3)) {cmd.sco = *(++argv); argc--;}
    else if (!strncmp(*argv,"-or",3)) {cmd.orc = *(++argv); argc--;}
    else if (!strncmp(*argv,"-out",4)) {cmd.out = *(++argv); argc--; }
    else if (!strcmp(*argv,"-midi")) {cmd.midi = *(++argv); argc--; }
    else if (!strncmp(*argv,"-in",3)) {
      cmd.in[cmd.inct] = *(++argv); argc--;
      cmd.delay[cmd.inct++] = atof(*(++argv)); argc--;
    }
    else if (!strncmp(*argv,"-help",5)) help();
    else if (!strncmp(*argv,"-text",5)) { cmd.text = 1;}
    else { printf("Unknown option '%s'.\n",*argv); exit(1); }
  }

  if (cmd.midi) {
    printf("MIDI support not done yet.\n");
    exit(1);
  }
  
  if ((!cmd.orc && (!cmd.midi || !cmd.sco)) && !cmd.bit)
    help();

  saol_startup(sa,&cmd);

  while (sa->sched->running) {
    sched_run_kcycle(sa);
  }

  finish_output(sa);
  printf("\n");
  return(0);
}

sa_decoder *cur_sa; /* only needed at startup for yyparse() and MIDIfiles */

void saol_startup(sa_decoder *sa,struct cmdinfo *cmd) {
  FILE *fp;
  char s[800];
  int i;

  sa->audioout = 0;

  sa->textout = cmd->text; 
  sa->audioout = 0;
  sa->synerror = 0;
  sa->verbose = 1;
  sa->audioout = 0;
  sa->global_cx = NULL;
  sa->ksmps = 0;
  sa->outfile = cmd->out;
  sa->all_ptrs = NULL;
  sa->bufsize = 0;
  sa->replace_count = 0;
  sa->sched = NULL;
  sa->aifout = NULL;
  sa->outbuf = NULL;
  sa->outbuf_ct = 0;
  sa->ended = 0;
  sa->all = NULL;
  sa->inct = cmd->inct;
  sa->in = (inputfile *)calloc(cmd->inct,sizeof(inputfile));
  for (i=0;i!=sa->inct;i++) {
    sa->in[i].fn = strdup(cmd->in[i]);
    sa->in[i].delay = cmd->delay[i];
    sa->in[i].aif_in = NULL;
  }
  sa->inbuf = NULL;
  sa->inbus = NULL;
  
  if (cmd->bit) {
    /* write temp files */
    sprintf(s,"%s%ctemp.sao",cmd->temp,DIRSEP);
    cmd->orc = strdup(s);
    sprintf(s,"%s%ctemp.sas",cmd->temp,DIRSEP);
    cmd->sco = strdup(s);
    process_bitstream(cmd);
  }

  if (!(fp = fopen(cmd->orc,"r"))) {
    printf("Fatal: couldn't open orchestra file '%s'.\n",cmd->orc);
    exit(1);
  }
	
  yyin = fp;

  sa->all = new_orc();
  cur_sa = sa;
  open_inputs(sa); /* do first so get #input channels */
  yyparse();
  if (!sa->all->g)
    sa->all->g = new_orc_global();
  build_sym_table(sa);
  rate_checking(sa);

  if (sa->synerror) exit(1);
  make_global_context(sa);
  start_scheduler(sa);
  if (cmd->sco) parse_score(sa,cmd->sco);
}

void runtime(char *s) {
  printf("Runtime error: %s\n",s);
  *(int *)0 = 1;		/* dump core */
  exit(1);
}


void help() {
  printf("Usage: saolc -orc [orcfile] [options]\n");
  printf("          -or-\n");
  printf("       saolc -bitstream [bitfile] [options]\n");
  printf("\n");
  printf("Options:\n");
  printf("   -sco         : score file in SASL format\n");
  printf("   -midi        : format 0/1 MIDI file\n");
  printf("   -text        : dump text sample values to stdout.                    \n");
  printf("   -temp        : directory for temp files for bitstream processing [.] \n");
  printf("   -in [fn] [t] : input sound file beginning at time t.\n");
  printf("   -out [file]  : write output as AIFF file.\n\n");
  printf("At least one of -sco, -midi, -bitstream must be specified.\n");
  printf("\n");
  exit(1);
}
