/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include "saol_bitstream.h"

#ifdef _WIN32
#define strdup _strdup
#endif

void **all_hc;
void **all_sev;
short num_hc=0;
int num_sev=0;

void get_header_chunks();
void get_stream_events();
void *read_orch(char *fn);
int write_bitstream(char *bitfn);
void *read_score(char *fn);
void *read_MIDI(char *fn);
void *read_sample(char *fn);
void two_char_from_short(unsigned char *buf,unsigned short x);
void four_char_from_int(unsigned char *buf,unsigned int x);
unsigned short short_from_two_char(unsigned char *buf);
unsigned int int_from_four_char(unsigned char *buf);
unsigned char hc_type(void *);

void main() {
  char bitfn[80];
  int outct;

#ifdef _WIN32
  _fmode = O_BINARY;
#endif 

  printf("Welcome to the simple, difficult-to-use Structured Audio encoder.\n");
  printf("\n");
  printf("Please enter filename for bitstream [.mp4]: ");
  scanf("%s",bitfn);

  get_header_chunks();
  get_stream_events();
  outct = write_bitstream(bitfn);

  printf("Wrote %d bits to bitstream successfully.\n",outct);
  exit(0);
}

void get_header_chunks() {
  char fn[80];
  void *hc[1000];
  int type=1,ct=0,i;
  ct = 0;

  printf("Please enter the type of header chunk, followed by the filename.\n");
  printf("Types: 1 Orch  2 Score  3 MIDI  4 Sample\n");
  printf("Example: 2 short.sasl\n");
  printf("Enter '0 0' to exit\n");
  printf("\n");

  while (type) {
    printf("Enter chunk: ");
    scanf("%d %s",&type,fn);
    switch (type) {
    case 0 : break;
    case 1 : hc[ct] = read_orch(fn); break;
    case 2 : hc[ct] = read_score(fn); break;
    case 3 : hc[ct] = read_MIDI(fn); break;
    case 4 : hc[ct] = read_sample(fn); break;
    }
    if (hc[ct]) ct++;
  }
  printf("Got %d chunks.\n",ct);
  num_hc = ct;
  all_hc = (void **)malloc(sizeof(void *) * num_hc);
  for (i=0;i!=num_hc;i++)
    all_hc[i] = hc[i];
}

void get_stream_events() {
}

int write_bitstream(char *bitfn) {
  FILE *fp = NULL;
  char fn[80];
  unsigned char buf[2];
  unsigned int ct,i,j;
  unsigned short len;

  strcpy(fn,bitfn);
  while (!(fp = fopen(fn,"w"))) {
    if (!fp) {
      printf("Couldn't open '%s' for write; enter new filename:");
      scanf("%s",fn);
    }
  }

  /* write magic number here? */
  fputc(0,fp);			/* header chunk */
  two_char_from_short(buf,num_hc);
  fputc(buf[0],fp); fputc(buf[1],fp);

  ct = 3;
  for (i=0;i!=num_hc;i++)
    switch (hc_type(all_hc[i])) {
    case HEADER_TYPE_ORCH:
      ct += fwrite((char *)all_hc[i],1,3,fp);
      len = short_from_two_char(((SA_orch_chunk *)all_hc[i])->length);
      ct += fwrite(((SA_orch_chunk *)all_hc[i])->data,1,len,fp);
      break;
    case HEADER_TYPE_SCORE:
      ct += fwrite((char *)all_hc[i],1,3,fp);
      for (j=0;j!=short_from_two_char(((SA_score_chunk *)all_hc[i])->length);j++) {
	ct += fwrite(((SA_score_chunk *)all_hc[i])->score_data[j],1,2,fp);
	ct += fwrite(((SA_score_chunk *)all_hc[i])->score_data[j]->data,1,
		     short_from_two_char(((SA_score_chunk *)all_hc[i])->score_data[j]->length),fp);
      }
      break;
    case HEADER_TYPE_SAMPLE:
      ct += fwrite((SA_sample_chunk *)all_hc[i],1,21,fp);
      ct += fwrite(((SA_sample_chunk *)all_hc[i])->data,1,
		   int_from_four_char(((SA_sample_chunk *)all_hc[i])->length),fp);
      break;
    default:
      printf("Unknown or unsupported header chunk format (%d)\n",
	     hc_type(all_hc[i]));
      break;
    }

  /* write event stream */
  if (num_sev) {
  }
  else {
    fputc(0xC0,fp);		/* 1100000 */
    fputc(0,fp);
    fputc(0,fp);
    ct += 3;
  }
	
  fclose(fp);

  return(ct);
}



void *read_orch(char *fn) {
  short ct,i;
  FILE *fp;
  char *buf;
  SA_orch_chunk *chunk;

  if (!(fp = fopen(fn,"r"))) {
    printf("Couldn't open '%s' for read.\n",fn);
    return NULL;
  }

  fseek(fp,0,SEEK_END);
  ct = (short)ftell(fp);
  fseek(fp,0,SEEK_SET);

  buf = (char *)malloc(sizeof(char) * ct);
  fread(buf,1,ct,fp);
  printf("Read %d bytes from file.\n",ct);
  fclose(fp);

  chunk = (SA_orch_chunk *)malloc(sizeof(SA_orch_chunk));
  chunk->type_arch_res = 0;
  chunk->type_arch_res |= HEADER_TYPE_ORCH;
  two_char_from_short(chunk->length,ct);
  chunk->data = buf;
	
  return (void *)chunk;
}

void *read_score(char *fn) {
  short ct,linect;
  FILE *fp;
  char buf[1000];		/* violation */
  SA_score_chunk *chunk;
  SA_score_data **lines;

  if (!(fp = fopen(fn,"r"))) {
    printf("Couldn't open '%s' for read.\n",fn);
    return NULL;
  }

  ct = 0; while (!feof(fp)) if (fgetc(fp) == '\n') ct++;

  lines = (SA_score_data **)malloc(sizeof(SA_score_data *) * ct);
  fseek(fp,0,SEEK_SET); ct = 0; linect = 0;
  while (!feof(fp)) {
    buf[ct] = fgetc(fp);
    if (buf[ct] == '\n') {
      lines[linect] = (SA_score_data *)malloc(sizeof(SA_score_data));
      buf[ct] = '\0';
      lines[linect]->data  = strdup(buf);
      two_char_from_short(lines[linect]->length,ct);
      linect++;
      ct = 0;
    }
    else ct++;
  }
  if (ct) {
    lines[linect] = (SA_score_data *)malloc(sizeof(SA_score_data));
    lines[linect]->data = strdup(buf);
    two_char_from_short(lines[linect]->length,ct);
    linect++;
    ct = 0;
  }
		
  linect--;
  printf("Read %d lines from file.\n",linect);
  fclose(fp);

  chunk = (SA_score_chunk *)malloc(sizeof(SA_score_chunk));
  chunk->type_arch_res = 0;
  chunk->type_arch_res |= HEADER_TYPE_SCORE;
  two_char_from_short(chunk->length,linect);
  chunk->score_data = lines;
	
  return (void *)chunk;
}

void *read_MIDI(char *fn) {
  printf("Can't yet add MIDI chunks.\n");
  return NULL;
}

void *read_sample(char *fn) {
  int ct,i;
  FILE *fp;
  char *buf;
  SA_sample_chunk *chunk;

  if (!(fp = fopen(fn,"r"))) {
    printf("Couldn't open '%s' for read.\n",fn);
    return NULL;
  }

  fseek(fp,0,SEEK_END);
  ct = (int)ftell(fp);
  buf = (char *)malloc(sizeof(char) * ct);
  fseek(fp,0,SEEK_SET);
  fread(buf,1,ct,fp);
  printf("Read %d bytes from file.\n",ct);
  fclose(fp);

  chunk = (SA_sample_chunk *)malloc(sizeof(SA_sample_chunk));
  chunk->type_arch_samp = 0;
  chunk->type_arch_samp |= HEADER_TYPE_SAMPLE;
  /* sample type unused right now */
  printf("Enter name for sample: ");
  scanf("%s",chunk->name);
  four_char_from_int(chunk->length,ct);
  chunk->data = buf;
	
  return (void *)chunk;
}

void two_char_from_short(unsigned char *buf,unsigned short x) {
  buf[0] = (x / 256);
  buf[1] = x-buf[0] * 256;
}

void four_char_from_int(unsigned char *buf,unsigned int x) {
  buf[0] = x / 256 / 256 / 256;
  buf[1] = (x-buf[0] * 256 * 256 * 256) / 256 / 256; 
  buf[2] = (x-buf[0] * 256*256*256 - buf[1]*256*256)/256;
  buf[3] = (x-buf[0]*256*256*256 - buf[1]*256*256 +buf[2]*256);
}

unsigned short short_from_two_char(unsigned char *buf) {
  return buf[0] * 256 + buf[1];
}

unsigned int int_from_four_char(unsigned char *buf) {
  return buf[0]*256*256*256 + buf[1]*256*256 + buf[2]*256 + buf[3];
}

unsigned char hc_type(void *hc) {
  return (*((char *)hc)) & 0xE0;
}
