/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/


#define HEADER_TYPE_INFO 0x00
#define HEADER_TYPE_ORCH 0x20
#define HEADER_TYPE_SCORE 0x60
#define HEADER_TYPE_MIDI 0x80
#define HEADER_TYPE_SAMPLE 0xA0
#define HEADER_TYPE_SINFO 0xC0

void process_bitstream(struct cmdinfo *cmd);

#ifdef _WIN32
#define DIRSEP '\\'
#else
#define DIRSEP '/'
#endif

typedef struct SA_hic_struct {
	unsigned char type_res;
	unsigned char num_chunks[2];
	} SA_header_info_chunk;

typedef struct SA_occ_struct {
	unsigned char type_arch_res;
	unsigned char length[2];
	unsigned char *data;
	} SA_orch_chunk;

typedef struct SA_sc_struct {
	unsigned char type_arch_res;
	unsigned char length[2];
	struct SA_sd_struct **score_data;
	} SA_score_chunk;

typedef struct SA_sd_struct {
	unsigned char length[2];
	unsigned char *data;
	} SA_score_data;

typedef struct SA_Mc_struct {
	unsigned char type_arch_res;
	unsigned char length[4];
	unsigned char *MIDI_data;
	} SA_MIDI_chunk;

typedef struct SA_sampc_struct {
	unsigned char type_arch_samp;
	unsigned char length[4];
	unsigned char name[16];
	unsigned char *data;
	} SA_sample_chunk;

typedef struct SA_sic_struct {
	unsigned char first5; /* type; has_score; has_MIDI; has_samples; res */
	} SA_stream_info_chunk;

typedef struct SA_seo_struct {
	unsigned char type_res;
	unsigned char length[2];
	unsigned char *score_event;
	} SA_score_event_object;

typedef struct SA_Meo_struct {
	unsigned char type_res;
	unsigned char length[2];
	unsigned char *MIDI_event;
	} SA_MIDI_event_object;

typedef struct SA_so_struct {
	unsigned char type_samp_res;
	unsigned char length[2];
	unsigned char name[16];
	unsigned char *sample_data;
	} SA_sample_object;



