/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

/* bitstream for standalone SA decoder */
#include <stdio.h>
#include "saol.h"
#include "saol_bitstream.h"

unsigned short short_from_two_char(char *buf);
unsigned int int_from_four_char(char *buf);
unsigned char hc_type(void *);


void process_bitstream(struct cmdinfo *cmd) {
	/* just make files in the temp directory */
  unsigned char buf[4],fn[80],sampfn[160];
	FILE *fp,*orc,*sco,*samp;
	char c;
	int h,i,j,type;
	unsigned short num_hc,len,len2;
	unsigned int llen;

	/* magic number? */

	if (!(fp = fopen(cmd->bit,"r"))) {
		printf("Fatal : couldn't open bitstream file '%s'.\n",cmd->bit);
		exit(1);
		}
	if (!(orc = fopen(cmd->orc,"w"))) {
		printf("Fatal : couldn't open temp SAOL file '%s'.\n",cmd->orc);
		exit(1);
		}
	sprintf(fn,"%s%ctemp.sas",cmd->temp,DIRSEP);
	if (!(sco = fopen(cmd->sco,"w"))) {
		printf("Fatal : couldn't open temp SASL file '%s'.\n",cmd->sco);
		exit(1);
		}

	if (c = fgetc(fp)) {
		printf("Error: bitstream doesn't start with \\0\n");
		exit(1);
		}
  buf[0] = fgetc(fp);
	buf[1] = fgetc(fp);

	num_hc = short_from_two_char(buf);
	printf("Reading %d chunk(s) of header data...\n",num_hc);
	
	for (h=0;h!=num_hc;h++) {
		buf[0] = fgetc(fp);
    type = hc_type(buf);
		switch (type) {
			case HEADER_TYPE_ORCH :
				buf[0] = fgetc(fp);
				buf[1] = fgetc(fp);
				len = short_from_two_char(buf);
				for (i=0;i!=len;i++)
					fputc(fgetc(fp),orc);
				printf("    Read %d bytes of orchestra data.\n",len);
				break;
			case HEADER_TYPE_SCORE :
				buf[0] = fgetc(fp);
				buf[1] = fgetc(fp);
				len = short_from_two_char(buf);
				for (i=0;i!=len;i++) {
					buf[0] = fgetc(fp);
				  buf[1] = fgetc(fp);
					len2 = short_from_two_char(buf);
					for (j=0;j!=len2;j++) 
						fputc(fgetc(fp),sco);
					fputc('\n',sco);
					}
				printf("    Read %d lines of score data.\n",len);
				break;
			case HEADER_TYPE_MIDI :
				printf("can't yet handle MIDI data.\n");
				break;
			case HEADER_TYPE_SAMPLE :
				buf[0] = fgetc(fp);
				buf[1] = fgetc(fp);
				buf[2] = fgetc(fp);
				buf[3] = fgetc(fp);
				llen = int_from_four_char(buf);
				fread(fn,1,16,fp);
				sprintf(sampfn,"%s%c%s",cmd->temp,DIRSEP,fn);
				if (!(samp = fopen(sampfn,"w"))) {
					printf("Couldn't open '%s' for sample write\n",sampfn);
					exit(1);
					}
				for (i=0;i!=llen;i++)
					fputc(fgetc(fp),samp);
				fclose(samp);
				printf("    Read %d bytes for sample '%s'.\n",llen,fn);
				break;
			case HEADER_TYPE_SINFO :
				/* soon */
				break;
			default:
				printf("Bad bitstream: unknown header chunk type (%d)!\n",type);
				break;
			}
		}
	
	printf("Bitstream read okay.\n");
	fclose(orc); fclose(sco); fclose(fp);
	}

unsigned short short_from_two_char(char *buf) {
	return (((unsigned short)buf[0]) * 256) + buf[1];
	}

unsigned int int_from_four_char(char *buf) {
  return (((unsigned int)buf[0])*256*256*256) + (((unsigned int)buf[1])*256*256) + (((unsigned int)buf[2]*256)) +
		buf[3];
	}

unsigned char hc_type(void *hc) {
	return (*((unsigned char *)hc)) & 0xE0;
	}
