/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

/***************************************************************\
*	byteswap.h		  				*
*   swap bytes e.g. for files between different machines 	*
*   dpwe 11nov91 after sndcvt 20feb91				*
\***************************************************************/

#ifndef _BYTESWAP_H
#define _BYTESWAP_H
/* byte order types - machmode values */
#define INORDER 0
#define BYTEREV 1
#define WORDREV 2
#define BYWDREV 3

/* nice (untested) macros */
/* swap bytes in a word */
#define WSWAPB(w)  (((0xFF&w)<<8)|((0xFF00&w)>>8))
/* reverse the bytes in a long (BYWDREV) */
#define LSWAPB(l)  ((((0xFF000000&l)>>24)&0xFF)|((0xFF0000&l)>>8)\
                                 |((0xFF00&l)<<8)|((0xFF&l)<<24))
/* just swap the words in a long (WORDREV) */
#define LSWAPW(l)  ((((0xFFFF0000&l)>>16)&0xFFFF)|((0xFFFF&l)<<16))

#ifndef INT32_DEFINED
#ifdef THINK_C
typedef long INT32;
#else /* !THINK_C */
typedef int INT32;
#endif /* THINK_C */
#define INT32_DEFINED
#endif /* INT32_DEFINED */

/* static function prototype */
int MatchByteMode PARG((INT32 red, INT32 target));
    /* return the bytemode to apply to 'red' to make 'target', or -1 */
int   HostByteMode PARG((void)); /* relative to 68000-style (MSB byte first) */
char *BytemodeName PARG((int bytemode));
short wshuffle PARG((int w, int mode));
INT32  lshuffle PARG((INT32 l, int mode));
INT32  FloatAsLong PARG((FLOATARG f, int mode));
float FloatFromLong PARG((INT32 l, int mode, INT32 fixup));
void  ConvertBufferBytes PARG((char *buf, long bytes, int wordsz, int mode));

#endif /* _BYTESWAP_H */

