/*
   audio.h -- Definitions for generic real time audio I/O
   language: C
   author  : Paris Smaragdis
   copyright: (c) 1996 MIT Media Lab, All Rights Reserved
*/

#include <stdio.h>

#ifdef __alpha
#include <signal.h>
#include <mme/mme_api.h>

/* Interrupt function */
void soundInterrupt( int);

/* Buffer structure */
typedef struct {
  void *lpData;
  BOOL available;
} buffer_t;

#endif

#ifdef __sgi
#include <audio.h>
typedef int BOOL;
#endif

/* Sound output functions */
int soundOutOpen( int, int, int);
int soundOutClose( int);
int soundOutQueue( short *);

/* Sound input functions */
int soundInOpen( int, int, int);
int soundInClose( int);
