#include <stdio.h>
#include <stdlib.h>
#include "sfheader.h"
#include "crack.h"
#include "pv.h"

complex zero = {0., 0.};
complex one = {1., 0.};
float PI;
float TWOPI;
float synt = 0.;
float ithres = .001;
int invert = 0;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R = 44100,
		N = 1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		in,
		on,
		same = 0,
		eof = 0,
		aflag = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input1,
                *input2,
		*buffer1,
                *buffer2,
		*channel1,
                *channel2,
		*output;
    double	mult = 1.;
    char	ch,
		file1[128],
                file2[128],
		*dbuf;
    FILE	*fp1,
                *fp2;

    if (argc < 3)
	usage(1);

    

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|F|m|t|iah", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(file1, arg_option);
			break;
	    case 'F':	strcpy(file2, arg_option);
			break;
	    case 'm':   mult = atof(arg_option);
	                break;
	    case 't':	ithres = atof(arg_option);
			break;
	    case 'a':	aflag = 1;
			break;
	    case 'i':	invert = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (D == 0)
      D = N / 8;

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    input1 = (float *) space( Nw, sizeof(float) );
    input2 = (float *) space( Nw, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

    if ( strcmp(file1, file2) == 0 ) {
      same = 1;
      input1 = (float *) space( Nw, sizeof(float) );
      input2 = (float *) space( Nw, sizeof(float) );
      buffer1 = (float *) space( N, sizeof(float) );
      buffer2 = (float *) space( N, sizeof(float) );
      channel1 = (float *) space( N+2, sizeof(float) );
      channel2 = (float *) space( N+2, sizeof(float) );
    }
    else {
      input1 = (float *) space( Nw, sizeof(float) );
      input2 = input1;
      buffer1 = (float *) space( N, sizeof(float) );
      buffer2 = buffer1;
      channel1 = (float *) space( N+2, sizeof(float) );
      channel2 = channel1;
    }

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;



/* open input files */
    if ( (fp1 = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if (same) {
      if ( (fp2 = fopen( file2, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file2);
	exit(-1);
      }
    }

    (void) stripheader(fp1);
    if (same)
      (void) stripheader(fp2);

    while ( !eof ) {

	in += D;
	on += I;


	if (same) {
	  eof = turnin( input1, Nw, D, fp1 );
	  fold( input1, Wanal, Nw, buffer1, N, in );
	  rfft( buffer1, N2, FORWARD );
	  selftaint( buffer1, channel1, N2, mult );
	}

	else {
	  eof = turnin( input1, Nw, D, fp1 );
	  if (eof)
	    (void) turnin( input2, Nw, D, fp2 );
	  else
	    eof = turnin( input2, Nw, D, fp2 );
	  
	  fold( input1, Wanal, Nw, buffer1, N, in );
	  fold( input2, Wanal, Nw, buffer2, N, in );
	  rfft( buffer1, N2, FORWARD );
	  rfft( buffer2, N2, FORWARD );

	  tainter( buffer1, buffer2, channel1, channel2, N2, mult );
        }

	if ( I == 0 ) {
	    fwrite( channel1, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	rfft( buffer1, N2, INVERSE );
	overlapadd( buffer1, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    exit(0);
}

void stripheader(fp)
FILE *fp;
{
  register int i;

  for ( i=0; i < SIZEOF_HEADER; i++ )
    fgetc(fp);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"taint:  FFT based spectral interpolation\n",
	"taint   [flags] > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	f:	source soundfile\n",
	"	F:	filter soundfile\n",
	"	m:	filtering multiplier\n",
	"	i:	inverse filtering option\n",
	"	t:	inverse filtering threshold\n",
	"	a:	analysis data output\n");
    exit(woof);
}

