#include <stdio.h>
#include "pv.h"
#include "crack.h"

#define Max_frms 16

complex zero = { 0., 0. } ;
complex one = { 1., 0. } ;
float PI ;
float TWOPI ;
float synt = 0.;

main(argc, argv)
    int argc ; char *argv[] ;
{
    int 	R,
		N,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		i,
    		t1,
    		t2,
    		iframes,
    		frmcnt = 0,
    		frames,
    		count = 0,
		hoop,			/* looping variable */
		in,
		on,
    		cop,
		eof = 0,
		Np = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*lpcoef,
		*buffer,
		*channel,
		*output,
		**fltbuf,
    		*flt,
    		*p,
    		len,
		lpa(),
		maxamp();
    char	ch,
		filename[128],
		*dbuf;
    FILE	*fp;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|l|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(filename, arg_option);
			break;
	    case 'l':	sscanf(arg_option, "%f", &len);
	      		break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.) ;
    TWOPI = 8.*atan(1.) ;
    N2 = N>>1 ;
    Nw2 = Nw>>1 ;
/*
 * allocate memory
 */

    flt = (float *) space( (N2 + 1), sizeof(float) );
    lpcoef = (float *) space( Np+1, sizeof(float) );	/* lp coefficients */
    Wanal = (float *) space( Nw, sizeof(float) );	/* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis window */
    input = (float *) space( Nw, sizeof(float) );	/* input buffer */
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    winput = (float *) space( Nw, sizeof(float) );	/* windowed input buffer */
    buffer = (float *) space( N, sizeof(float) );	/* FFT buffer */
    channel = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */

    if ( (fltbuf = (float **) malloc( Max_frms * sizeof(float *) )) == NULL ) {
      fprintf(stderr,"Memory hoax!\n");
      exit(-1);
    }

    for ( i=0; i < Max_frms; i++ ) {
      if ( (*(fltbuf+i) = (float *) malloc( (N2+1) * sizeof(float) )) == NULL ) {
        fprintf(stderr,"Memory hoax!\n");
        exit(-1);
      }
    }
/*
 * create windows
 */
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 ) ;
/*
 * initialize input and output time values (in samples)
 */
    in = -Nw ;
    if ( D )
	on = (in*I)/D ;
    else
	on = in ;

/* input filter function data from file */
    if ( (fp = fopen( filename, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",filename);
	exit(-1);
    }
    i = 0;
    while ( (cop = fread( *(fltbuf+i), sizeof(float), N2, fp )) == N2 )
      ++i;
    if (i < 1) {
	fprintf(stderr,"Your filter function is lacking\n");
 	exit(-1);
    }
    iframes = i;
    frames = (int) (len * R / ( (float) D * (iframes - 1) ));

/*
 * main loop--perform phase vocoder analysis-resynthesis
 */
    while ( !eof ) {
/*
 * increment times
 */
	in += D ;
	on += I ;
/*
 * analysis: input D samples; window, fold and rotate input
 * samples into FFT buffer; take FFT; and convert to
 * amplitude-frequency (phase vocoder) form
 */
	t1 = frmcnt;
	t2 = ((frmcnt + 1) % iframes);
	if ( count == 0 )
	  p = *(fltbuf+frmcnt);
	else {
	  for ( i=0; i < N2; i++ ) 
	    *(flt+i) = *(*(fltbuf+t1)+i) + ( (*(*(fltbuf+t2)+i) 
		     - *(*(fltbuf+t1)+i)) * ((float) count / frames) );
	  p = flt;
	}

	++count;
	if (count >= frames) {
	  count = 0;
	  ++frmcnt;
	  if (frmcnt >= iframes)
	    frmcnt = 0;
	}
	
	if ( D == 0 ) {
		if ( fread( channel, sizeof(float), N+2, stdin ) == 0 )
		    eof = 1;
	}
	else {
	    eof = shiftin( input, Nw, D ) ;
	    fold( input, Wanal, Nw, buffer, N, in ) ;
	    rfft( buffer, N2, FORWARD ) ;
	    fconvert( buffer, channel, p, N2 );
	}

	if ( I == 0 ) {
	    fwrite( channel, sizeof(float), N+2, stdout ) ;
	    fflush( stdout ) ;
	    continue ;
	}
/*
 * overlap-add resynthesis
 */
	rfft( buffer, N2, INVERSE ) ;
	overlapadd( buffer, N, Wsyn, output, Nw, on ) ;
	shiftout( output, Nw, I, on ) ;
    }
for(i=0; i<N2; i++)
fprintf(stderr,"%g\n",*(flt+i));
    exit( 0 ) ;
}

vvmult( out, a, b, n ) float *out, *a, *b ; int n ; {
 register float *lim = out + n ;
    while ( out < lim )
	*out++ = *a++ * *b++ ;
}

float maxamp( in, n, per, ix, sz ) float *in ; int n, per, ix, sz ; {
/* char *malloc(), *calloc() ; */
 float maxof(), *lim = in + n ;
 int i, found ;
 static float **buf, *mx ;
 static int *ptr ;
 static int first = 1 ;
 register int *p ;
 register float *b, *m ;
    if ( first ) {
	first = 0 ;
	buf = (float **) malloc( sz*sizeof(float *) ) ;
	for ( i = 0 ; i < sz ; i++ )
	    buf[i] = (float *) calloc( per, sizeof(float) ) ;
	ptr = (int *) calloc( sz, sizeof(int) ) ;
	mx = (float *) calloc( sz, sizeof(float) ) ;
    }
    --ix ;
    for (
	b = buf[ix] , p = &ptr[ix] , m = &mx[ix], found = 0 ;
	in < lim ;
	in++
    ) {
	if ( ( *(b+*p) = *in >= 0. ? *in : -*in ) >= *m )
	    found = *m = *(b+*p) ;
	if ( ++(*p) > per )
	    *p = 0 ;
    }
    if ( found )
	return( *m ) ;
    else
	return( *m = maxof( b, per ) ) ;
}

float maxof( a, n ) float *a ; int n ; {
 register float *lim = a + n, m ;
    for ( m = *a++ ; a < lim ; a++ )
	if ( *a > m )
	    m = *a ;
    return( m ) ;
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s",
	"further:  FFT based window filter processor\n",
	"further   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	f:	filter function filename\n",
	"	l:	length of input (seconds)\n");
    exit(woof);
}

