#include "pv.h"
#include <stdio.h>

/*	This routine is a hack of the phase-vocoder convert subroutine.
	It gets the real part of the FFT amplitude for each 'bin' and
	multiplies these by a filter function. */ 
	
void archaic( S, C, fltbuf, N2 )
float *S, *C, *fltbuf; int N2;
{
 int real, imag, amp, phase;
 float 	a, b,
 	rrand(),
	prand();
 register int i;

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	a = ( i == N2 ? S[1] : S[real] );
	b = ( i == 0 || i == N2 ? 0. : S[imag] );
	C[amp] = hypot( a, b );
	C[amp] *=  *(fltbuf + (int) (prand() * N2));
	C[phase] = -atan2( b, a );
    }


    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	S[real] = *(C+amp) * cos( *(C+phase) );
	if ( i != N2 )
	    S[imag] = -*(C+amp) * sin( *(C+phase) );
    }
}
