#include <stdio.h>
#include "../PVLIB/pv.h"
/* 9-19-94
fixed getthresh() bug
*/
complex zero = { 0., 0. } ;
complex one = { 1., 0. } ;
float PI ;
float TWOPI ;
float synt ;
extern char *arg_option;

main( argc, argv )
    int argc ; char *argv[] ;
{
// double atof();
int i;
float cfac = 2.00;
float basefreq;
int cnt;
float nyquist;
  int R=44100, N=1024, N2, Nw = 2048, Nw2, D = 256, I = 256, in, on;
  int   eof = 0, obank = 0, aflag = 0, sflag = 0, Np;
 float P = 1.0, len, tincr, tpos;
 float tadv, realtime, tlength;
 float duration;
 int flen, ipos;
 char fname[128];
 float *warpfunc;
  FILE *fopen(), *fp;
char ch;
float *Hwin, *Wanal, *Wsyn, *input, *winput, *lpcoef, *buffer, *channel, *ratios, *output ;
float omin,omax,imin,imax;
 float maxampval;
 float threshfac = .001;
 float maxigain;
float getthresh();
    if (isatty(0))
	usage(1);
    while( (ch= crack( argc, argv, "R|N|M|P|D|t|I|F|f|l|o|s|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	P = atof(arg_option);
			break;
	    case 'l':   duration = atof(arg_option);
			break;
	    case 'f':	cfac = atof(arg_option);
			break;
	    case 't':	threshfac = atof(arg_option);
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    Np = 0;

    PI = 4.*atan(1.) ;
    TWOPI = 8.*atan(1.) ;
    nyquist = R/2.0;
    obank = P != 0. ;
    if( P == 0.0 ) {P = 1.0;
   /*  fprintf(stderr,"new P %f\n",P); */
    }
    N2 = N>>1 ;
    Nw2 = Nw>>1 ;

    fvec( Wanal, Nw ) ;		/* analysis window */
    fvec( Wsyn, Nw ) ;		/* synthesis window */
    fvec( input, Nw ) ;		/* input buffer */
    fvec( Hwin, Nw ) ;		/* plain Hamming window */
    fvec( winput, Nw ) ;	/* windowed input buffer */
    fvec( buffer, N ) ;		/* FFT buffer */
    fvec( channel, N+2 ) ;	/* analysis channels */
    fvec( ratios, N+2 ) ;	/* ratios between successive frequencies */
    fvec( output, Nw ) ;	/* output buffer */
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank ) ;
    in = -Nw ;
    if ( D )
	on = (in*I)/D ;
    else
	on = in ;
    while ( !eof ) {
	in += D ;
	on += I ;
	/* analysis */
		if( sflag ){
			if( fread(channel, sizeof(float) , N+2, stdin) == NULL )
				eof = 1;
		}
		else {
	 	  eof = shiftin( input, Nw, D ) ;
	  	  fold( input, Wanal, Nw, buffer, N, in ) ;
	  	  rfft( buffer, N2, FORWARD ) ;
	  	  convert( buffer, channel, N2, D, R ) ;
		}
	 realtime += tadv;
         imin = channel[3];
         imax = channel[N-1];
         omin = imin;
         omax = imax * cfac;
        for(i=1;i<N;i+=2){
              channel[i] = omin+((omax-omin)*((channel[i]-imin)/(imax-imin)));
              if(channel[i] * P >= nyquist) channel[i-1] = 0.0; 
	}
	// RESYNTHESIS
	if ( obank ) {
            synt = getthresh( channel, N, threshfac );
	    noscbank(channel, N2, R, Nw, I, P, output);
	    shiftout( output, Nw, I, on+Nw-I );
	} 
	else {
	    unconvert( channel, buffer, N2, I, R );
	    rfft( buffer, N2, INVERSE );
	    overlapadd( buffer, N, Wsyn, output, Nw, on );
	    shiftout( output, Nw, I, on );
	}

    }
    fprintf(stderr,"TEMPER: RESYNTHESIS COMPLETED\n");
    exit( 0 ) ;
}
usage(woof)
{
    fprintf(stderr, "%s",
	"temper:  static spectral compander\n"
	"temper   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [2048]\n"
	"	D:	decimation factor in samples [256]\n"
	"	I:	interpolation factor in samples [256]\n"
        "	P:	pitch factor [0 for overlap add] [1.0]\n"
	"	f:	spectral companding factor [2.0]\n"
	"	t:	oscillator resynthesis threshold [.001]\n"
	"	s:	synthesize analysis input\n");
    exit(woof);
}

