#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"
/* tv switch between two filter functions */
/* pvhole can build filter functions */
complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;
void fconvert();
void offconvert();
extern char *arg_option ;
main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 512, 
		I = 512,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		Np = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output,
		*fltbuf, *fltbuf1, *fltbuf2, *func ;
    char	ch,
		*dbuf;
FILE	*fp1,*fp2,*openfile();
float *ofunc;
char flt1name[128]="flt1", flt2name[128]="flt2";
char lookfuncname[128] = "func";
char offsetfuncname[128] = "ofunc";

float totdur = 0.0;
float tadv;
int flen, oflen ;
int renormflag = 0;
float turf ;
float now;
int swapflag = 0;
int invertflag = 0;
int offsetflag = 0;
int offset ;

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|F|h|d|l|s|i|o|O|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(flt1name, arg_option);
			break;
	    case 'F':	strcpy(flt2name, arg_option);
			break;
	    case 'l':	strcpy(lookfuncname, arg_option);
			break;
	    case 'd':	totdur = atof(arg_option);
			break;
	    case 's':	swapflag = 1;
			break;
	    case 'i':	invertflag = 1;
			break;
	    case 'o':	offsetflag = 1;
			break;
	    case 'O':	strcpy(offsetfuncname, arg_option);
			break;

	    case 'h':	usage(1);
	}
    }
if( totdur == 0. )
  usage(1);
    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

/* allocate memory */

    Wanal = (float *) calloc( Nw, sizeof(float) );
	 Wsyn = (float *) calloc( Nw, sizeof(float) );	input = (float *) calloc( Nw, sizeof(float) );	Hwin = (float *) calloc( Nw, sizeof(float) );	winput = (float *) calloc( Nw, sizeof(float) );	buffer = (float *) calloc( N, sizeof(float) );	channel = (float *) calloc( N+2, sizeof(float) );	fltbuf = (float *) calloc( (N / 2) + 1, sizeof(float) );  
    output = (float *) calloc( Nw, sizeof(float) );	

/* create windows */

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

/* initialize input and output time values (in samples) */

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* input filter function data from file */
    fp1 = openfile( lookfuncname, "r" );
    flen = readin( fp1, &func );
    for(i = 0; i < flen; i++ )
        if( (func[i] < 0.0) || (func[i] > 1.0) ){
	 	 renormflag = 1;
        }
    if( renormflag ){
	   fprintf(stderr,"normalizing lookupfunc to 0-1\n");
  	   norman(func,0.,1.,flen);
	   }
    if( invertflag ){
      fprintf(stderr,"inverting lookup function\n");
      for(i=0;i<flen;i++)
         func[i] = 1.0 - func[i];
    }
    fp1 = openfile( flt1name, "r" );
    if( ( readin(fp1, &fltbuf1) ) != N2 ){
      fprintf(stderr, "%s must be of size %d\n",flt1name,N2);
      exit(-1);
    }
    fp2 = openfile( flt2name, "r" );
    if( ( readin(fp2, &fltbuf2) ) != N2 ){
      fprintf(stderr, "%s must be of size %d\n",flt2name,N2);
      exit(-1);
    }
    
        if( offsetflag ){
        fp1 = openfile( offsetfuncname, "r" );
        oflen = readin( fp1, &ofunc );
        for(i = 0; i < oflen; i++ )
          if( (ofunc[i] < 0.0) || (ofunc[i] > 1.0) ){
            fprintf(stderr,"normalizing offsetfunc to 0-1\n"); 
	    renormflag = 1;
            }
    if( renormflag )
      norman(ofunc,0.,1.,oflen);
    }

    tadv = (float)D/(float)R ;
    now = 0.;
    while ( !eof ) {

      turf = func[(int)((now/totdur)*(float)flen)];
      if( swapflag )
         buildflt2( fltbuf, fltbuf1, fltbuf2, turf, N2 );
      else
         buildflt( fltbuf, fltbuf1, fltbuf2, turf, N2 );

      now += tadv;
      in += D;
      on += I;

	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    if( offsetflag ){
	      offset = ofunc[(int)((now/totdur)*(float)oflen)] * (float) N2;
	    /*  fprintf(stderr,"offset = %d\n",offset); */
	      offconvert( buffer, channel, fltbuf, N2, offset );
	    } else {
	    fconvert( buffer, channel, fltbuf, N2 );
		}

/* overlap-add resynthesis */

	rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    fprintf(stderr,"REEFER: SYNTHESIS COMPLETED\n");
    exit(0);
}
void fconvert( float *S, float *C, float *fltbuf, int N2 )
{
 int real, imag, amp, phase;
 float a, b;
 int i;

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	a = ( i == N2 ? S[1] : S[real] );
	b = ( i == 0 || i == N2 ? 0. : S[imag] );
	C[amp] = hypot( a, b );
        C[amp] *= *(fltbuf+i);
	C[phase] = -atan2( b, a );
    }

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	S[real] = *(C+amp) * cos( *(C+phase) );
	if ( i != N2 )
	    S[imag] = -*(C+amp) * sin( *(C+phase) );
    }
}

buildflt( arr, a, b, fac, len) float *arr, *a, *b, fac; int len;
{
int i;
float ifac;
  ifac = 1.0 - fac;
  for(i =0; i < len; i++ )
    arr[i] = (a[i]*ifac)+(b[i]*fac);
}
/* THIS ROUTINE SWAPS BINS */
buildflt2( arr, a, b, fac, len) float *arr, *a, *b, fac; int len;
{
int i;
float ifac;
static int *sieve;
static int first = 1;
int bins2swap;
  if( first == 1 ){
      fprintf(stderr,"initializing random grid\n");
      sieve = (int *) calloc( len, sizeof(int) );
      RandSet( sieve, len );
      first = 0;
  }
  bins2swap = fac * (float) len ;
  for( i = 0; i < len; i++ )
    arr[i] = a[i];
  for(i = 0; i < bins2swap; i++ )
    arr[sieve[i]] = b[sieve[i]];
}

RandSet( arr, N ) int *arr, N ;
{
int i, j;
int NSwitch = 100000 ;
int temp ;
int pos1, pos2;
srandom( time( 0 ) );
for( i = 0; i < N; i++ )
   arr[i] = i;
for( i = 0; i < NSwitch; i++ ){
   pos1 = random()%N;
   pos2 = random()%N;
   temp = arr[pos2];
   arr[pos2] = arr[pos1];
   arr[pos1] = temp ;
   }
}
void offconvert( float *S, float *C, float *fltbuf, int N2, int offset )
{
 int real, imag, amp, phase;
 float a, b;
 int i;
 int newindex ;
    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	a = ( i == N2 ? S[1] : S[real] );
	b = ( i == 0 || i == N2 ? 0. : S[imag] );
	C[amp] = hypot( a, b );
	newindex = i + offset ;
	if( newindex > N2 )
	  newindex -= N2;
        C[amp] *= *(fltbuf+newindex) ;
	C[phase] = -atan2( b, a );
    }

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	S[real] = *(C+amp) * cos( *(C+phase) );
	if ( i != N2 )
	    S[imag] = -*(C+amp) * sin( *(C+phase) );
    }
}

usage(woof)
{
    fprintf(stderr, "%s",
	"reefer:  FFT based window filter processor\n"
	"reefer   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate[44100]\n"
	"	M:	window size in samples[4096]\n"
	"	D:	decimation factor in samples[512]\n"
	"	I:	interpolation factor in samples[512]\n"
	"	f:	filter function filename1[flt1]\n"
	"	F:	filter function filename2[flt2]\n"
	"	d:	duration of input [0.0]\n"
	"	l:	interpolation function name[func]\n"
	"	i:	invert interpolation function\n"
	"	o:	deploy offset option\n"
	"	O:	name of optional offset function [ofunc]\n"
	"	s:	use bin swap instead of filter average\n"
	);
    exit(woof);
}

