#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"
extern char *arg_option;
complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = .001;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=2048,
		N2,
		Nw = 16384,
		Nw2, 
		D = 2048, 
		I = 2048,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0;
    float 	P = 0.,
		len,
		tincr,
		tpos,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*frame1,*frame2,*channel,
		*output;
    char	ch,
		*dbuf;
int first = 1;
int grabflag = 1;
float stretchfac=2.0, frameadv, framepos=0.0 ;
    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|S|p|t|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'S':	stretchfac = atof(arg_option);
			break;
	    case 't':	synt = atof(arg_option);
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }
if( stretchfac == 0.0 ){
  fprintf(stderr,"0.0 not a legal stretch factor\n");
  exit(-1);
}
frameadv = 1.0/stretchfac ;
    if (Nw == 0)
	Nw = N;

    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    if (sflag)
      D = 0;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;

    Wanal = (float *) space( Nw, sizeof(float) );	/* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis window */
    input = (float *) space( Nw, sizeof(float) );	/* input buffer */
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    winput = (float *) space( Nw, sizeof(float) );	/* windowed input buffer */
    buffer = (float *) space( N, sizeof(float) );	/* FFT buffer */
    frame1 = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    frame2 = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    channel = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );
    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {

if( first ){
     eof = shiftin( input, Nw, D );
     fold( input, Wanal, Nw, buffer, N, in );
     rfft( buffer, N2, FORWARD );
     convert( buffer, frame1, N2, D, R );
     eof = shiftin( input, Nw, D );
     fold( input, Wanal, Nw, buffer, N, in );
     rfft( buffer, N2, FORWARD );
     convert( buffer, frame2, N2, D, R );
     first = 0;
     	in += D;
	on += I;
     }  
if( framepos >= 1.0 ){ // NEED NEW FRAME READIN
    while( framepos >= 1.0 )
       framepos -= 1.0;
    copyframe( frame1, frame2, N+2 ) ;   
    eof = shiftin( input, Nw, D );
    fold( input, Wanal, Nw, buffer, N, in );
    rfft( buffer, N2, FORWARD );
    convert( buffer, frame2, N2, D, R );
    	in += D;
	on += I;
    // ACTUAL FRAME MANIPULATION FOR THIS CASE OCCURS
    // BELOW
}
if( framepos == 0.0 ){ // RIGHT ON FRAME1
   copyframe( channel, frame1, N+2 ) ;
   framepos += frameadv;
}
else { // SOMEWHERE IN MIDDLE - INTERPOLATE
   InterpFrame( channel, frame1, frame2, N+2, framepos );
   framepos += frameadv;
}
	    unconvert( channel, buffer, N2, I, R );
	    rfft( buffer, N2, INVERSE );
	    overlapadd( buffer, N, Wsyn, output, Nw, on );
	    shiftout( output, Nw, I, on );
    }
    fprintf(stderr,"STRETCH DONE\n");
    exit(0);
}


InterpFrame(dest, a, b, len, pos) float *dest, *a, *b, pos; int len;
{
  int i;
  for(i = 0; i < len; i++)
     dest[i] = (a[i]*(1.-pos))+(b[i]*pos); // INTERP ONLY AMP
 }
copyframe( dest, src, len ) float *dest, *src; int len;
{
int i;
   for(i = 0; i < len; i++ )
      dest[i] = src[i];
}
usage()
{
    fprintf(stderr, "%s",
	"stretch:  frequency interpolated time expansion\n"
	"stretch   [flags] < floatsams > floatsams\n"
	"	R:	sampling rate [44100]\n"
	"	N:	fft length [2048]\n"
	"	M:	window size in samples [8192]\n"
	"	D:	decimation factor in samples [2048]\n"
	"	I:	interpolation factor in samples [2048]\n"
	"	S:	stretch factor [2.0]\n"
);
    exit(-1);
}
