;; writetoss -- writes the "toss prepended samples" routine

(defun write-toss (alg stream)
  (let ((alg-name (get alg 'name))
	(sound-names (get alg 'sound-names)))
    ;;----------------
    ;; void ALG_toss_fetch(susp, snd_list)
    ;;   register ALG_susp_type susp;
    ;;   snd_list_type snd_list;
    ;; {
    ;;    long final_count = min(susp->susp.current + max_sample_block_len,
    ;;			   susp->susp.toss_cnt);
    ;;    time_type final_time = susp->susp.t0 + final_count / susp->susp.sr;
    ;;    long n;
    ;;----------------
    (format stream "~%~%void ~A_toss_fetch(susp, snd_list)~%" alg-name)
    (format stream "  register ~A_susp_type susp;~%" alg-name)
    (format stream "  snd_list_type snd_list;~%{~%")
    (format stream
     "    long final_count = min(susp->susp.current + max_sample_block_len,~%")
    (format stream "\t\t\t   susp->susp.toss_cnt);~%");
    (format stream
"    time_type final_time = susp->susp.t0 + final_count / susp->susp.sr;~%")
    (format stream "    long n;~%~%")

    (cond (*watch*
           (format stream
            "    printf(\"~A_toss_fetch: final count %d final time %d\\n\", "
            alg-name)
           (format stream "final_count, final_time);~%")))

    ;;------------------------------
    ;; for each sound argument:
    ;;
    ;;    /* fetch samples from NAME up to final_time for this block of zeros */
    ;;    while (((long) ((final_time - susp->NAME->t0) * susp->NAME->sr + 0.5)) >=
    ;;	   susp->NAME->current)
    ;;	susp_get_samples(NAME, NAME_ptr, NAME_cnt);
    ;;------------------------------
    (dolist (name sound-names)
      (format stream
  "    /* fetch samples from ~A up to final_time for this block of zeros */~%"
       name)
      (format stream
  "    while (((long) ((final_time - susp->~A->t0) * susp->~A->sr + 0.5)) >=~%" 
       name name)
      (format stream "\t   susp->~A->current)~%" name)
      (format stream "\tsusp_get_samples(~A, ~A_ptr, ~A_cnt);~%" 
              name name name))

    ;;----------------
    ;;    /* convert to normal processing when we hit final_count */
    ;;    /* we want each signal positioned at final_time */
    ;;    if (final_count == susp->susp.toss_cnt) {
    ;;----------------
      (format stream
       "    /* convert to normal processing when we hit final_count */~%")
      (format stream "    /* we want each signal positioned at final_time */~%")
      (format stream "    if (final_count == susp->susp.toss_cnt) {~%")

    ;;----------------
    ;; for each sound argument:
    ;;
    ;;	n = (final_time - susp->NAME->t0) * susp->NAME->sr -
    ;;	     (susp->NAME->current - susp->NAME_cnt) + 0.5;
    ;;	susp->NAME_ptr += n;
    ;;	susp_took(NAME_cnt, n);
    ;;----------------
    (dolist (name sound-names)
      (format stream "\tn = (final_time - susp->~A->t0) * susp->~A->sr -~%"
              name name)
      (format stream "\t     (susp->~A->current - susp->~A_cnt) + 0.5;~%"
              name name)
      (format stream "\tsusp->~A_ptr += n;~%" name)
      (format stream "\tsusp_took(~A_cnt, n);~%" name))

    ;;----------------
    ;;	susp->susp.fetch = susp->susp.keep_fetch;
    ;;    }
    ;;    snd_list->block_len = final_count - susp->susp.current;
    ;;    susp->susp.current = final_count;
    ;;    snd_list->u.next = snd_list_create((snd_susp_type) susp);
    ;;    snd_list->block = internal_zero_block;
    ;; }
    ;;----------------
    (format stream "\tsusp->susp.fetch = susp->susp.keep_fetch;~%")
    (format stream "    }~%")
    (format stream
     "    snd_list->block_len = final_count - susp->susp.current;~%")
    (format stream "    susp->susp.current = final_count;~%")
    (format stream
     "    snd_list->u.next = snd_list_create((snd_susp_type) susp);~%")
    (format stream "    snd_list->block = internal_zero_block;~%")
    (format stream "}~%")))


	

