/*********************************************************************

	Buggy MiniEdit.c
	
	The sample application from Inside Macintosh (RoadMap p.15-17)
	beefed up a bit by Stephen Z. Stein, Think Technologies Inc.
	
	
*********************************************************************/
#include <MacHeaders>
#ifdef OLDEDIT
#include "QuickDraw.h"
#include "MacTypes.h"
#include "FontMgr.h"
#include "WindowMgr.h"
#include "MenuMgr.h"
#include "TextEdit.h"
#include "DialogMgr.h"
#include "EventMgr.h"
#include "DeskMgr.h"
#include "FileMgr.h"
#include "ToolboxUtil.h"
#include "ControlMgr.h"
#endif

#include "macstuff.h"

#include "string.h"
#include "time.h"

extern WindowPtr infoWindow;

WindowRecord	wRecord;
WindowPtr		myWindow; 
TEHandle		TEH;
int				linesInFolder;
Rect			dragRect = { 0, 0, 1024, 1024 };
extern MenuHandle		myMenus[];
ControlHandle 	vScroll;
Cursor			editCursor;
Cursor			waitCursor;
char			dirty;
Rect r = {200 , 0, 350, 520};

extern Str255 	theFileName;

oldmain() 
{
	int		myRsrc;
	
	InitGraf(&thePort);
	InitFonts();
	FlushEvents( everyEvent, 0 );
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(0L);
	InitCursor();
	MaxApplZone();

/*
/*  The following statement is included as a check to see if we can
/*	access our program's resources.  When the project is run from
/*	LightspeedC, the resource file <project name>.rsrc is automatically
/*  opened.  When an application is built, these resources are 
/* 	automatically merged with the application.
/*
/*	If you have followed the manual correctly, you haved named this
/*	project "new project" and placed it on the same disk as the sources
/*	for MiniEdit.  If this is so, the test is not necessary.
/*
/*	Please see the Addenda for more information on how LightspeedC
/*	coordinates .rsrc files with projects and application builds.
*/
/*	OpenResFile("\pnew project.Rsrc"); 
	if (GetResource('MENU', fileID)==0) {
		SysBeep(20);
		CantOpen();
		return;
	}
	*/
/*	SetUpFiles();
	SetUpCursors();
	SetUpMenus();
	SetUpWindows();
	SetUpInfoWindow(r);
	while (MainEditor()) ;
*/}

EditorSetUp()
{
	SetUpFiles();
	SetUpCursors();
	SetUpWindows();
/*	SetUpInfoWindow(r);   */
}

int MainEditor() 
{
	EventRecord		myEvent;
	WindowPtr		whichWindow;
	Rect			r;
	
	MaintainCursor();
/*	MaintainMenus();   */
	SystemTask();
	TEIdle(TEH);
	if (GetNextEvent(everyEvent, &myEvent)) {
		switch (myEvent.what) {
		case mouseDown:
			switch (FindWindow( myEvent.where, &whichWindow )) {
			case inDesk: 
				SysBeep(10);
				break;
			case inGoAway:
				if (ours(whichWindow))
					if (TrackGoAway( myWindow, myEvent.where) ) {
						DoFile(fmClose);
						return(false);
						}
				break;
			case inMenuBar:
				return( DoCommand( MenuSelect(myEvent.where) ) );
			case inSysWindow:
				SystemClick( &myEvent, whichWindow );
				break;
			case inDrag:
				if (ours(whichWindow))
					DragWindow( whichWindow, myEvent.where, &dragRect );
				break;
			case inGrow:
				if (ours(whichWindow))
					MyGrowWindow( whichWindow, myEvent.where );
				break;
			case inContent:
				if (whichWindow != FrontWindow()) {
					SelectWindow(whichWindow);
					return(false);
					}
				else 
					if (ours(whichWindow))
						DoContent(whichWindow, &myEvent);
				break;
			default: ;
			} /* end switch FindWindow */
			break;
		case keyDown:
		case autoKey: 
			{
			register char	theChar;
			
			theChar = myEvent.message & charCodeMask;
			if ((myEvent.modifiers & cmdKey) != 0) 
				return( DoCommand( MenuKey( theChar ) ));
			else {
				TEKey( theChar, TEH );
				ShowSelect();
				switch (theChar) {
						case ')':
							ParenMatch(TEH);
							break;
						default: ;
					}
				dirty = 1;
				}
			}
			break;
		case activateEvt:
			if (ours((WindowPtr)myEvent.message)) {
				r=(*myWindow).portRect;
				r.top = r.bottom - (SBarWidth+1);
				r.left = r.left - (SBarWidth+1);
				InvalRect(&r);
				if ( myEvent.modifiers & activeFlag ) {
					TEActivate( TEH );
					ShowControl( vScroll );
					DisableItem( myMenus[editmenu], undoCommand );
					TEFromScrap();
				}
				else {
					TEDeactivate(TEH);
					HideControl( vScroll );
					ZeroScrap();
					TEToScrap();
				}
			}
			break;
		case updateEvt: 
			if (ours((WindowPtr)myEvent.message)) UpdateWindow(myWindow);
			break;
		default: ;
		} /* end of case myEvent.what */
	} /* if */
	return(true);
}

ParenMatch(localTEH)
TEHandle localTEH;
{
	char buf[100];
	long int loc, i, x;
	clock_t select_time;
	char ch;
		
	loc = (**localTEH).selStart;
/*	PrintInfo("I am here\n");
	sprintf(buf,"location %ld\n",loc);
	TextH = TEGetText(localTEH);
*/	i = loc - 1;
	x = 1;
	while ((i-- > 0) && (x > 0)) {
		ch = (*((**localTEH).hText))[i];
		if (ch == '(') 
			x--;
		else if (ch == ')')
			x++;
/*		sprintf(buf,"%c%c", ch);
		PrintInfo(buf);
*/		}
	if (x == 0) {
/*		sprintf(buf, "macth location is %ld", i);
		PrintInfo(buf);
*/		TESetSelect(i + 1, i + 2, localTEH);
		TEActivate(localTEH);
		select_time = clock();
		select_time += (CLOCKS_PER_SEC >> 2);	/* 1/4 second */
		while(select_time > clock());
		TEDeactivate(localTEH);
		TESetSelect(loc, loc, localTEH);
		TEActivate(localTEH);
		}
	else
		SysBeep(10);	
}
	
/*
SetUpMenus()
{
	int		i;
	
	myMenus[applemenu] = NewMenu( appleID, "\p\024" );
	AddResMenu( myMenus[applemenu], 'DRVR' );
	myMenus[editormenu] = GetMenu(fileID);
	myMenus[editmenu] = GetMenu(editID);
	for ( (i=applemenu); (i<=editmenu); i++ ) InsertMenu(myMenus[i], 0) ;
	DrawMenuBar();
}
*/
int DoCommand( mResult )
long mResult;
{
	short		theItem;
	Str255	name;
	WindowPeek wPtr;
	
	theItem = LoWord( mResult );
	switch (HiWord(mResult)) {
	case appleid:
		GetItem(myMenus[applemenu], theItem, name);
		OpenDeskAcc( name );
		SetPort( myWindow );
		break;
	case editorid:
		if (DoFile(theItem)) 
		   return(false);
		break;
	case editid: 
		if (SystemEdit(theItem-1)==0) {
			wPtr = (WindowPeek) FrontWindow();
			switch (theItem) {
			case cutCommand:
				TECut( TEH );
				dirty = 1;
				break;
			case copyCommand:
				TECopy( TEH );
				break;
			case pasteCommand:
				TEPaste( TEH );
				dirty = 1;
				break;
			case clearCommand:
				TEDelete( TEH );
				dirty = 1;
				break;
			default: ;
			}
			ShowSelect();
		}
		break;
	}
	HiliteMenu(0);
	return(1);
}

MaintainCursor()
{
	Point		pt;
	WindowPeek	wPtr;
	GrafPtr		savePort;
	
	if (ours((WindowPtr)(wPtr=(WindowPeek)FrontWindow()))) {
		GetPort( &savePort );
		SetPort( (GrafPtr)wPtr );
		GetMouse(&pt);
		if ( PtInRect(pt, &(**TEH).viewRect )  )
			SetCursor( &editCursor);
		/* else SetCursor( &arrow ); OLDMINIEDIT */
		SetPort( savePort );
	}
}

MaintainMenus()
{
	if ( !(*(WindowPeek)myWindow).visible || 
			!ours(FrontWindow()) ) {
		EnableItem( myMenus[editormenu], fmNew );
		EnableItem( myMenus[editormenu], fmOpen );
		DisableItem( myMenus[editormenu], fmClose );
		DisableItem( myMenus[editormenu], fmSave );
		DisableItem( myMenus[editormenu], fmSaveAs );
		DisableItem( myMenus[editormenu], fmRevert );
		DisableItem( myMenus[editormenu], fmPrint );
		EnableItem( myMenus[editmenu], undoCommand );
		EnableItem( myMenus[editmenu], cutCommand );
		EnableItem( myMenus[editmenu], copyCommand );
		EnableItem( myMenus[editmenu], clearCommand );
	}
	else {
		DisableItem( myMenus[editormenu], fmNew );
		DisableItem( myMenus[editormenu], fmOpen );
		EnableItem( myMenus[editormenu], fmClose );
		EnableItem( myMenus[editormenu], fmSaveAs );
		EnableItem( myMenus[editormenu], fmPrint );
		if (dirty) {
			EnableItem( myMenus[editormenu], fmRevert );
			if (theFileName[0]!=0) EnableItem( myMenus[editormenu], fmSave );
			else  DisableItem( myMenus[editormenu], fmSave );
		}
		else {
			DisableItem( myMenus[editormenu], fmRevert );
			DisableItem( myMenus[editormenu], fmSave );
		}
		DisableItem( myMenus[editmenu], undoCommand );
		if ((**TEH).selStart==(**TEH).selEnd) {
			DisableItem( myMenus[editmenu], cutCommand );
			DisableItem( myMenus[editmenu], copyCommand );
			DisableItem( myMenus[editmenu], clearCommand );
		}
		else {
			EnableItem( myMenus[editmenu], cutCommand );
			EnableItem( myMenus[editmenu], copyCommand );
			EnableItem( myMenus[editmenu], clearCommand );
		}
	}
}

SetUpCursors()
{
	CursHandle	hCurs;
	
	hCurs = GetCursor(1);
	editCursor = **hCurs;
	hCurs = GetCursor(watchCursor);
	waitCursor = **hCurs;
}

ours(w)
WindowPtr w;
{
	return( (myWindow!=NULL) && (w==myWindow) );
}

CantOpen()
{
	Rect r;

	SetRect(&r, 152, 60, 356, 132);
	SetPort((myWindow = NewWindow( 0L, &r, "\p", 1, 1, (WindowPtr) -1L, 0, 0L)));
	TextFont(0);
	MoveTo( 4, 20 );
	DrawString("\pCan't open resource file.");
	MoveTo( 4, 40 );
	DrawString("\pClick mouse to exit.");
	do {
	} while ( !Button() );
}
