// queue.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FIFO queue implementation used for QueuedOutputFunction class.

#ifndef QUEUE_H
#ifdef __GNUG__
#pragma interface
#endif
#define QUEUE_H

#include "buffer.h"

class Queue : public Buffer {
	typedef Buffer Super;
public:
	Queue(int size);
	redefined void reset();
	void setQueueSize(int len);
	Queue& addTo(double value);
	double takeFrom();
	boolean full();
	boolean empty();
protected:
	int currentQueue;
};

inline boolean
Queue::full() { return currentQueue == maxQueue; }

inline boolean
Queue::empty() { return currentQueue == 0; }

inline Queue&
Queue::addTo(double value) {
	*inputPointer = value;
	incrementInput();
	currentQueue++;
	return *this;
}

inline double
Queue::takeFrom() {
	incrementOutput();
	currentQueue--;
	return *outputPointer;
}

#endif
