// edit_menus.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#include "localdefs.h"
#include <X11/keysym.h>
#include "data.h"
#include "editor.h"
#include "menus.h"
#include "pvoceditor.h"
#include "soundeditor.h"
#include "sndconfig.h"

static const int Inactive = true;

// The structs containing the various menuitem templates for the menus

static MenuInfo viewModeSubmenu[] = {
	{ "view as channels",			" ",	XK_copyright },
	{ "view as frames",				" ",	XK_ordfeminine },
	{ nil }
};

static MenuInfo channelSubmenu[] = {
	{ "set channel view...",		"=",	XK_equal },
	{ "add channel",				"+",	XK_plus },
	{ "remove channel",				"-",	XK_minus },
	{ "shift up",					">",	XK_greater },
	{ "shift down",					"<",	XK_less },
	{ nil }
};

static MenuInfo viewMenu[] = {
	{ "new view of selection",		"N",	XK_N },
	{ "zoom to selection", 			"z",	XK_z },
	{ "zoom to full", 				"Z",	XK_Z },
	{ "set frame view...",			"f",	XK_f },
	{ "reset vertical scale",		"V",	XK_V },
	{ "View Mode",				"",		0L,		false, viewModeSubmenu },
	{ "Channel Display",			"",		0L,		false, channelSubmenu },
	{ "display copy buffer",	"I",	XK_I },
	{ "close current view",			"W",	XK_W },
	{ "show program version",		" ",	XK_yen },
	{ "quit program",				"Q",	XK_Q },
	{ nil }
};

static MenuInfo fileTypeSubmenu[] = {
	{ "LPC datafile...", 			" ",	XK_nobreakspace },
	{ "Sound file...", 				" ",	XK_exclamdown },
	{ "Envelope...", 				" ",	XK_cent },
	{ "Pvoc datafile...",			" ",	XK_currency },
	{ nil }
};

static MenuInfo fileMenu[] = {
	{ "set default dir...",			".",	XK_period },
	{ "new",						"n",	XK_n },
	{ "New Type",					"",		0L,		false, fileTypeSubmenu },
	{ "open...",					"o",	XK_o },
	{ "save",						"s",	XK_s },
	{ "save as...",					"S",	XK_S },
	{ "revert",						"U",	XK_U },
	{ "change name...",				"'",	XK_quoteright },
	{ "change file comment...",		"\"",	XK_quotedbl },
	{ "file information...",		"?",	XK_question },
	{ "data dump of selection...",	"}",	XK_braceright },
	{ nil }
};

// the unusual keycodes are just for internal communication--no one is 
// expect to type those characters!

static MenuInfo editMenu[] = {
	{ "set insert point...",	"j",	XK_j },
	{ "set edit region...",		"J",	XK_J },
	{ "copy",				"c",	XK_c },
	{ "copy to new",		"C",	XK_C },
	{ "remove",				"r",	XK_r },
	{ "remove to new",		"y",	XK_y },
	{ "erase",				"e",	XK_e },
	{ "splice out",			"x",	XK_x },
	{ "splice out to new",	"X",	XK_X },
	{ "delete",				"d",	XK_d },
	{ "mix",				"m",	XK_m },
	{ "replace",			"R",	XK_R },
	{ "crossfade...",		"g",	XK_g },
	{ "splice in",			"v",	XK_v },
	{ nil }
};

static MenuInfo modifyMenu[] = {
	{ "normalize values",		"[",	XK_bracketleft },
	{ "smooth curve",			"L",	XK_L },
	{ "scale values...",		"P",	XK_P },
	{ "rescale to fit...", 		"]",	XK_bracketright },
	{ "add offset...",			"O",	XK_O },
	{ "apply envelope...",		"E",	XK_E },
	{ "reverse",				"b",	XK_b },
	{ "insert space...",		"i",	XK_i },
	{ "add delay...",			"D",	XK_D },
	{ "stretch/shrink",			"t",	XK_t },
	{ nil }
};

static MenuInfo styleSubmenu[] = {
	{ "line",	"%",	XK_percent },
	{ "bar",	"^",	XK_asciicircum },
	{ nil }
};

static MenuInfo channelUnitSubmenu[] = {
	{ "frames",	"#",	XK_numbersign },
	{ "time",	"@",	XK_at },
	{ "SMPTE",	"!",	XK_exclam },
	{ nil }
};

static MenuInfo channelDisplayMenu[] = {
	{ "Graph Style",		"",	0L, false, styleSubmenu },
	{ "Horiz Scale Units",	"",	0L, false, channelUnitSubmenu },
	{ nil }
};

static MenuInfo soundFilterSubmenu[] = {
	{ "low pass",					"L",	XK_L },
	{ "resonant",					"q",	XK_q },
	{ "comb",						"K",	XK_K },
	{ "elliptical",					"H",	XK_H },
	{ "LPC formant",				"F",	XK_F },
	{ nil }
};

static MenuInfo soundModifyMenu[] = {
	{ "phrase...",				"P",	XK_P },
	{ "apply envelope...",		"E",	XK_E },
	{ "reverse",				"b",	XK_b },
	{ "transpose...",			"t",	XK_t },
	{ "time shift...",			"T",	XK_T, Inactive },
	{ "Filter",					"", 	0L, false, soundFilterSubmenu },
	{ "insert space...",		"i",	XK_i },
	{ "normalize values",		"[",	XK_bracketleft },
	{ "add delay...",			"D",	XK_D },
	{ "add DC offset...",		"O", 	XK_O },
	{ "remove DC offset",		"~", 	XK_asciitilde },
	{ nil }
};

static MenuInfo synthesisSubmenu[] = {
	{ "LPC resynthesis...", 			"K1",	XK_KP_1 },
	{ "Phase Vocoder resynthesis...", 	"K2",	XK_KP_2 },
	{ nil }
};

static MenuInfo converterSubmenu[] = {
#ifdef SPARC_DACS
	{ "SPARC",		"",	XK_section },
#elif defined SGI_DACS
	{ "SGI",		"",	XK_section },
#elif defined SOUNDBLASTER
	{ "SoundBlaster",	"",	XK_section },
#elif defined VOXWARE_DACS
	{ "VoxWare",	"",	XK_section },
#elif defined NeXT
	{ "NeXT",		"",	XK_section },
#endif
#ifdef ADC_DACS
	{ "ADR",		"",	XK_diaeresis },
#elif defined PROPORT_DACS
	{ "S56x",		"",	XK_diaeresis },
#endif
	{ "converter settings...",		")",	XK_parenright },
	{ "reset converter",			"",	XK_threesuperior },
	{ nil }
};

static MenuInfo soundSpecialMenu[] = {
	{ "play",						"p",	XK_p },
	{ "record",						":",	XK_colon },
	{ "stop",						"<backspace>",	XK_BackSpace },
	{ "rescan for peak", 			"$",	XK_dollar },
	{ "rescale", 					"]",	XK_bracketright },
	{ "change sample format...",	"&",	XK_ampersand },
	{ "change sample rate...",		"k",	XK_k },
	{ "change file length...",		"l",	XK_l },
	{ "Synthesis",					" ",	0L, false, synthesisSubmenu },
	{ "D/A Converter",				" ",	0L, false, converterSubmenu },
	{ "sound options...", 			" ", 	XK_degree },
	{ nil }
};

static MenuInfo soundAnalysisMenu[] = {
	{ "locate next zero crossing",	"0",	XK_0 },
	{ "find slope change",		"1",	XK_1 },
	{ "show maxamp sample location","2",	XK_2 },
	{ "extract amplitude envelope",	"3",	XK_3 },
	{ "FFT analysis",				"4",	XK_4 },
	{ "LPC analysis",				"5",	XK_5 },
	{ "extract pitch envelope",		"6",	XK_6 },
	{ "LPC and pitch envelope",		"7",	XK_7 },
	{ "Phase Vocoder analysis",		"8",	XK_8 },
	{ nil }
};

static MenuInfo peakRescanSubmenu[] = {
	{ "on",		"/",	XK_slash },
	{ "off",	"\\",	XK_backslash },
	{ nil }
};

static MenuInfo optionsMenu[] = {
	{ "Peak Rescan",			"",		0L, false, peakRescanSubmenu },
	{ "Global Options...",		" ",	XK_macron },
	{ "Scale Options...",		" ",	XK_twosuperior },
	{ "File Options...",		" ",	XK_acute },
	{ "Memory Options...",		" ",	XK_mu },
	{ nil }
};

// And now the structs containing the various menu templates

static MenuBarInfo defaultChannelMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Edit  ", editMenu },
	{ "  Display  ", channelDisplayMenu },
	{ nil }
};

static MenuBarInfo soundMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Edit  ", editMenu },
	{ "  Modify  ", soundModifyMenu },
	{ "  Sound  ", soundSpecialMenu },
	{ "  Analysis  ", soundAnalysisMenu },
	{ "  Display  ", channelDisplayMenu },
	{ "  Options  ", optionsMenu },
	{ nil }
};

static MenuInfo lpcSpecialMenu[] = {
	{ "stabilize frames", 				"*",	XK_asterisk },
	{ "display filter amplitudes", 		"A",	XK_A },
	{ "display filter formants", 		"F",	XK_F },
	{ "merge pitch data",				"M",	XK_M },
	{ "adjust pitch deviation...", 		"p",	XK_p },
	{ "change sample rate...",			"k",	XK_k },
	{ "change file length...",			"l",	XK_l },
	{ "lpc options...", 				" ", 	XK_degree },
	{ nil }
};

static MenuBarInfo lpcMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Edit  ", editMenu },
	{ "  Modify  ", modifyMenu },
	{ "  LPC  ", lpcSpecialMenu },
	{ "  Display  ", channelDisplayMenu },
	{ "  Options  ", optionsMenu },
	{ nil }
};

static MenuInfo envelopeSpecialMenu[] = {
	{ "create linear curve...", 		"_",	XK_underscore },
	{ "create exponential curve...", 	"*",	XK_asterisk },
	{ "invert existing curve",	 		" ",	0L, Inactive },
	{ "change file length...",			"l",	XK_l },
	{ "envelope options...", 			" ", 	XK_degree, Inactive },
	{ nil }
};

static MenuBarInfo envelopeMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Edit  ", editMenu },
	{ "  Modify  ", modifyMenu },
	{ "  Envelope  ", envelopeSpecialMenu },
	{ "  Display  ", channelDisplayMenu },
	{ "  Options  ", optionsMenu },
	{ nil }
};

static MenuInfo pitchSpecialMenu[] = {
	{ "change file length...",		"l",	XK_l },
	{ "shift by pitch interval...",	" ", 	0L, Inactive },
	{ nil }
};

static MenuBarInfo pitchMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Edit  ", editMenu },
	{ "  Modify  ", modifyMenu },
	{ "  Pitch ", pitchSpecialMenu },
	{ "  Display  ", channelDisplayMenu },
	{ "  Options  ", optionsMenu },
	{ nil }
};

static MenuInfo frameHorizUnitSubmenu[] = {
	{ "band numbers",	"#",	XK_numbersign },
	{ "frequency",		"@",	XK_at },
	{ nil }
};

static MenuInfo frameVertUnitSubmenu[] = {
	{ "amplitude",		"a",	XK_a },
	{ "decibels",		"d",	XK_d },
	{ nil }
};

static MenuInfo frameDisplayMenu[] = {
	{ "Horiz. Scale Units",	"",	0L, false, frameHorizUnitSubmenu },
	{ "Vert. Scale Units",	"",	0L, false, frameVertUnitSubmenu },
	{ nil }
};

static MenuBarInfo defaultFrameMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Display  ", frameDisplayMenu },
	{ nil }
};

static MenuInfo pvocSpecialMenu[] = {
	{ "harmonically shift spectrum", 		"0",	XK_0 },
	{ "stretch/shrink shift spectrum", 		"1",	XK_1 },
	{ "expand/compress spectrum", 			"2",	XK_2, Inactive },
	{ "change file length...",				"l",	XK_l },
	{ "pvoc options...", 					" ", 	XK_degree, Inactive },
	{ nil }
};

static MenuBarInfo pvocMenuBar[] = {
	{ "  View  ", viewMenu },
	{ "  File  ", fileMenu },
	{ "  Edit  ", editMenu },
	{ "  Modify  ", modifyMenu },
	{ "  PVoc  ", pvocSpecialMenu },
	{ "  Display  ", channelDisplayMenu },
	{ "  Options  ", optionsMenu },
	{ nil }
};

////////

const MenuBarInfo *
DataEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : defaultChannelMenuBar;
}

const MenuBarInfo *
SoundEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : soundMenuBar;
}

const MenuBarInfo *
LPCEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : lpcMenuBar;
}

const MenuBarInfo *
PvocEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : pvocMenuBar;
}

const MenuBarInfo *
PCHEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : pitchMenuBar;
}

const MenuBarInfo *
EnvelopeEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : envelopeMenuBar;
}

const MenuBarInfo *
FFTEditor::menuBarInfo() const {
	return model()->displayAsFrames() ?
		defaultFrameMenuBar : defaultChannelMenuBar;
}

