// sndconfig.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// defines for determining soundfile and converter formats based upon the
// architecture and some user-set defines.

#ifndef SNDCONFIG_H
#define SNDCONFIG_H

#ifdef sparc 
#define USE_NeXT_HEADERS		/* for NeXT header compatibility */
#undef USE_SPARC_HEADERS		/* for SPARC .au headers only */
#endif	/* sparc */

#if defined(USE_NeXT_HEADERS) || defined(NeXT)
#define SOUND_SUFFIX ".snd"
#define SOUND_FLOAT_SUFFIX ".fp"
#define SOUND_DEFAULT_RATE 44100
#define SOUND_DEFAULT_TYPE ShortData
#define HEADER_DEFAULT_TYPE Hybrid
#elif defined(USE_SPARC_HEADERS)
#define SOUND_SUFFIX ".au"
#define SOUND_FLOAT_SUFFIX ".fp"
#define SOUND_DEFAULT_RATE 8000
#define SOUND_DEFAULT_TYPE MuLawData
#define HEADER_DEFAULT_TYPE Snd
#elif defined(AIFF_AUDIO)
#define SOUND_SUFFIX ".aiff"
#define SOUND_FLOAT_SUFFIX ".fp"
#define SOUND_DEFAULT_RATE 44100
#define SOUND_DEFAULT_TYPE ShortData
#define HEADER_DEFAULT_TYPE Aifc
#elif defined(VOXWARE_DACS)
#define SOUND_SUFFIX ".wav"
#define SOUND_FLOAT_SUFFIX ".fp"
#define SOUND_DEFAULT_RATE 11025
#define SOUND_DEFAULT_TYPE CharData
#define HEADER_DEFAULT_TYPE Wav
#else
#define SOUND_SUFFIX ".short"
#define SOUND_FLOAT_SUFFIX ".fp"
#define SOUND_DEFAULT_RATE 44100
#define SOUND_DEFAULT_TYPE ShortData
#define HEADER_DEFAULT_TYPE Ircam
#endif

#if defined(NeXT) || defined(USE_NeXT_HEADERS)

#include "next_sound.h"
#define SOUNDSTRUCT_H
#define FLOAT_FORMAT SND_FORMAT_FLOAT
#define SHORT_FORMAT SND_FORMAT_LINEAR_16
#define MULAW_FORMAT SND_FORMAT_MULAW_8
#define ALAW_FORMAT (27) /* SND_FORMAT_ALAW_8 */
#define CHAR_FORMAT	SND_FORMAT_LINEAR_8

#elif defined(sparc) && defined(USE_SPARC_HEADERS)

#include <multimedia/audio_filehdr.h>
#define AUDIO_FILEHDR_H
#define FLOAT_FORMAT AUDIO_FILE_ENCODING_FLOAT
#define SHORT_FORMAT AUDIO_FILE_ENCODING_LINEAR_16
#define MULAW_FORMAT AUDIO_FILE_ENCODING_MULAW_8
#define ALAW_FORMAT (27)
#define CHAR_FORMAT	AUDIO_FILE_ENCODING_LINEAR_8

#else

// these macros taken from NeXT header files -- hope they don't change.

#define FLOAT_FORMAT (6)
#define SHORT_FORMAT (3)
#define CHAR_FORMAT (2)
#define MULAW_FORMAT (1)
#define ALAW_FORMAT (27)

#endif

#endif /* SNDCONFIG_H */
