// reqdelegate.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// A RequestDelegate functions as a go-between between a Request object and
// a Requester object, allowing an additional degree of abstraction.  It allows
// a Request object to call methods upon the Requester without having to
// contain or know the structure of the Requester.

#ifndef REQDELEGATE_H
#ifdef __GNUG__
#pragma interface
#endif
#define REQDELEGATE_H

#include "localdefs.h"
#include "requester.h"

class RequestDelegate {
	friend class Request;
	friend class Requester;
public:
	virtual ~RequestDelegate() {}
protected:
	RequestDelegate(Requester *r) : myRequester(r) {}
	virtual boolean checkValues(Request &request) {
		return myRequester->setValues(request);
	}
private:
	Requester *myRequester;
};

#endif

