// optionsetter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef OPTIONSETTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define OPTIONSETTER_H

#include "modifier.h"

class GlobalOptionSetter : public Modifier {
public:
	GlobalOptionSetter() {}
	redefined int apply() { return true; }
protected:
	redefined void configureRequest(Request &);
 	redefined boolean setValues(Request &);
private:
 	redefined const QueryInfo *requestInfo();
};

class FileOptionSetter : public Modifier {
public:
	FileOptionSetter() {}
	redefined int apply() { return true; }
protected:
	redefined void configureRequest(Request &);
 	redefined boolean setValues(Request &);
private:
 	redefined const QueryInfo *requestInfo();
};

class LPCOptionSetter : public Modifier {
public:
	LPCOptionSetter() {}
	redefined int apply() { return true; }
protected:
	redefined void configureRequest(Request &);
 	redefined boolean setValues(Request &);
private:
 	redefined const QueryInfo *requestInfo();
};

class SoundOptionSetter : public Modifier {
public:
	SoundOptionSetter() {}
	redefined int apply() { return true; }
protected:
	redefined void configureRequest(Request &);
 	redefined boolean setValues(Request &);
private:
 	redefined const QueryInfo *requestInfo();
};

class MemoryOptionSetter : public Modifier {
public:
	MemoryOptionSetter() {}
	redefined int apply() { return true; }
protected:
	redefined void configureRequest(Request &);
 	redefined boolean setValues(Request &);
private:
 	redefined const QueryInfo *requestInfo();
};

#endif
