// textwindow.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <InterViews/action.h>
#include <InterViews/button.h>
#include <X11/keysym.h>

#include "localdefs.h"
#include "commenteditor.h"
#include "textwindow.h"
#include "menus.h"

TextWindow::TextWindow(const char* title, CommentEditor* editor)
		: FramedWindow(title, nil), myEditor(editor) {
	Insert((Interactor *) editor);
	init();
}

TextWindow::~TextWindow() {
}

void
TextWindow::init() {
	SetClassName("TextWindow");
}

Interactor *
TextWindow::makeMenuBar() {
	static MenuInfo viewmenu[] = {
		{ "close window",                    "c",    XK_c },
		{ nil }
	};
	static MenuInfo editmenu[] = {
		{ "save comment",                    "s",    XK_s },
		{ nil }
	};
	static MenuBarInfo menuinfo[] = {
		{ "  View  ", viewmenu },
		{ "  Edit  ", editmenu },
		{ nil }
	};
	MenuBar *bar = new MenuBar;
	for(MenuBarInfo* i = menuinfo; i->title != nil; i++) {
		bar->Include(makeMenu(new PulldownMenu(i->title), i->info));
	}
	return bar;
}

class TextWindowKeyCommandAction : public Action {
public:
	TextWindowKeyCommandAction(TextWindow* w, unsigned long key)
		: window(w), keysym(key) {}
	redefined void execute() { window->keyCommand(keysym); }
private:
	TextWindow* window;
	unsigned long keysym;
};

Action*
TextWindow::makeMenuItemAction(const struct MenuInfo* info) {
	return new TextWindowKeyCommandAction(this, info->code);
}

int
TextWindow::keyCommand(unsigned long key) {
	switch(key) {
	case XK_c:
		closeAndDestroy();
		break;
	case XK_s:
		myEditor->save();
		break;
	default:
		break;
	}
	return false;
}
