// requester.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Requester is the generic base class for all routines that query the user
// for parameters needed to configure an operation of some sort.  Its virtual
// methods are redefined in a large variety of ways in the large subclass
// heirarchy.  See request.h and query.h for more information.

#ifndef REQUESTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define REQUESTER_H

#include "localdefs.h"

class Controller;
class Request;
class RequestDelegate;
struct QueryInfo;

class Requester {
	friend class RequestDelegate;
public:
	Requester() : status(true), configured(false) {}
	virtual boolean configure(Controller *);
	virtual boolean reconfigure(Controller *);
	boolean ok();
protected:
	virtual RequestDelegate* createDelegate();
	virtual Request* createRequest();
	virtual boolean queryForValues(Controller *);
	virtual void configureRequest(Request &) {}
	virtual boolean setValues(Request &) { return true; }
	virtual boolean confirmValues(Controller *) { return true; }
	virtual void ok(boolean is) { status = is; }
	virtual boolean isConfigured() { return configured; }
	virtual void initialize() { configured = true; }
private:
	virtual const QueryInfo *requestInfo() = 0;
	boolean status;
	boolean configured;
};

inline boolean
Requester::ok() { return status && isConfigured(); }

#endif
