// processfun.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "controller.h"
#include "data.h"
#include "processfun.h"
#include "request.h"
#include "query.h"
#include "range.h"

int
SimpleFunction::doApply(Data *data) {
	return data->apply(*this);
}

boolean
SingleFactorFunction::setValues(Request& request) {
	QueryValue v;
	request.retrieveValues(v);
	setFactor(v);
	return true;
}

//**********

const QueryInfo *
Scaler::requestInfo() {
	static QueryLabelInfo scalerLabelInfo[] = {
		{ "Scale Values in Selected Region:" },
		{ nil }
	};	
	static QueryValueInfo scalerValueInfo[] = {
		{ "Amplitude Factor:", "1.00", CharCheck::numsOnly },
		{ nil }
	};	
	static QueryInfo scalerInfo[] = {
		{ scalerLabelInfo, "", scalerValueInfo },
		{ nil }
	};
	
	return scalerInfo;
}

Modifier *
Scaler::create(DataEditor* de) {
	return nil;
}

Modifier *
Scaler::createUnDo() {
	return (factor != 0.0) ? new Offset(target(), 1.0/factor) : nil;
}

//**********

const QueryInfo *
Offset::requestInfo() {
	static QueryLabelInfo offsetLabelInfo[] = {
		{ "Offset Selected Region:" },
		{ nil }
	};	
	static QueryValueInfo offsetValueInfo[] = {
		{ "Offset By:", "0.000", CharCheck::numsOnly },
		{ nil }
	};	
	static QueryInfo offsetInfo[] = {
		{ offsetLabelInfo, "", offsetValueInfo },
		{ nil }
	};

	return offsetInfo;
}

Modifier *
Offset::create(DataEditor* de) {
	return nil;
}

Modifier *
Offset::createUnDo() {
	return new Offset(target(), -factor);
}

//**********

Modifier *
Eraser::create(DataEditor* de) {
	return nil;
}

Modifier *
Eraser::createUnDo() {
	return nil;
}

