// iofunction.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "iofunction.h"
#include <InterViews/resource.h>
#include "data.h"

InputOutputFunction::InputOutputFunction(
	Data* input, Data* output, int inQueueSize, int outQueueSize)
		: QueuedOutputFunction(output, outQueueSize),
		  myInput(nil), inputQueue(inQueueSize),
		  queueStatus(Q_MORE_INPUT | Q_MORE_OUTPUT) {
	setInput(input);
}

InputOutputFunction::~InputOutputFunction() {
	Resource::unref(myInput);
}

void
InputOutputFunction::setInput(Data* newinput) {
	if(newinput != myInput) {
		Resource::unref(myInput);
		myInput = newinput;
		if(myInput != nil)
			myInput->ref();
	}
}

void
InputOutputFunction::initialize() {
	int new_length = newLength(myInput->length());
	int status = true;
	// make sure that output is set to the correct length
	if(!areCompatibleLengths(target()->length(), new_length)) {
		ok(status = target()->changeLength(new_length));
	}	
	if(status)
		Super::initialize();
}

void
InputOutputFunction::restoreState() {
	Super::restoreState();
	inputQueue.reset();
	myIndex.reset();
	queueStatus = Q_MORE_INPUT | Q_MORE_OUTPUT;
}

// this routine returns Stop when all input data has been processed

RunStatus
InputOutputFunction::runProcess() {
	BUG("InputOutputFunction::runProcess()");
	if(inQueueEmpty()) {
		if(moreInput())
			readFromInput();
		else
			needToFlushIf(moreOutput());  // no more input; flush if more outpt
	}
	int status = doProcessing();
	boolean more = (moreInput() || moreOutput());
	return (status == -1) ? Error : more ? Run : Stop;
}

// this routine loops while input is available or while 
// processor still has output to write to the queue

int
InputOutputFunction::doProcessing() {
	BUG("InputOutputFunction::doProcessing()");
	int status = true;
	int flushing = needToFlush();
	while((!inQueueEmpty() || flushing) && status == true) {
		status = processInput(flushing);	// true if outqueue not full
		// if no more pending and we were flushing, turn off flushing
		flushing = (flushing && (status != true));
	}
	needToFlushIf(flushing);	// update based on last loop
	moreOutputIf(status == false);
	// false if output queue full or if we just need to fill the input queue
	return status;
}

// giveSamplesTo() returns false when myInput has no more samples to give

void
InputOutputFunction::readFromInput() {
	BUG("InputOutputFunction::readFromInput()");
	moreInputIf(myInput->giveSamplesTo(*this) == true);
}

//********

int
SimpleInputOutputFunction::processInput(boolean flushing) {
	return addToOutQueue(doSimpleProcess(flushing ? 0.0 : takeFromInQueue()));
}
