// formantfilter.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "formantfilter.h"
#include "application.h"
#include "controller.h"
#include "lpcdata.h"
#include "query.h"
#include "request.h"

FormantFilter::FormantFilter(Data* input, Data* output,
	LPCData* data, double amp) : LPC_Filter(data, input->length()),
		  SimpleInputOutputFunction(input, output, lpcQueueSize, lpcQueueSize),
		  gain(amp) {
	if(LPC_Filter::good())
		initialize();
}

FormantFilter::FormantFilter(Data* input, Data* output, LPCData* data)
		: LPC_Filter(data, input->length()),
		  SimpleInputOutputFunction(input, output, lpcQueueSize, lpcQueueSize)
{
	ok(LPC_Filter::good());
}

void
FormantFilter::initialize() {
	LPC_Filter::initialize();
	restoreState();
	Super::initialize();
}

void
FormantFilter::restoreState() {
	LPC_Filter::reset();
    Super::restoreState();
}

int
FormantFilter::doProcessing() {
	BUG("FormantFilter::doProcessing()");
	int status = true;
	while(!inQueueEmpty() && status == true) {
		status = processInput(false);
	}
	return status;
}

double
FormantFilter::doSimpleProcess(double sig) {
	BUG("FormantFilter::doSimpleProcess()");
	float amp = 0.0;
	float dummy1 = 0.0, dummy2 = 0.0;
	float* coeffs = getFrame(&amp, &dummy1, &dummy2);
	return filter(coeffs, sig * amp * gain);
}

const QueryInfo *
FormantFilter::requestInfo() {
	static QueryLabelInfo labelInfo[] = {
		{ "LPC (Formant) Filter Selected Region:" },
		{ nil }
	};	
	static QueryValueInfo valueInfo[] = {
		{ "Gain Factor:", "1.00", CharCheck::numsOnly },
		{ nil }
	};	
	static QueryInfo info[] = {
		{ labelInfo, "", valueInfo },
		{ nil }
	};
	return info;
}

boolean
FormantFilter::configure(Controller *c) {
	return Super::configure(c);
}

boolean
FormantFilter::setValues(Request &request) {
	QueryValue v;
	request.retrieveValues(v);
	gain = v;
	return true;
}

boolean
FormantFilter::confirmValues(Controller *) {
	int status = true;
	char msg[120];
	if(sampRate() != lpcSamplingRate()) {
		sprintf(msg,
			"Warning: LPC data samprate (%d) != selection samprate (%d).",
				lpcSamplingRate(), sampRate());
		status = Application::confirm(msg, "The formant peaks will be skewed.",
			"Continue anyway?", Cancel);
	}
	return status;
}

