// diskstruct.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author 	
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "diskstruct.h"
#include "valuesetter.h"

int
DiskStruct::doRead(DataFile* file, ValueSetterBase** setters) {
	ValueSetterBase* setter = nil;
	int status = true;
	while((setter = *setters++) != nil)
		if(!(status = setter->readAndSet(file)))
			break;
	return status;
}

int
DiskStruct::doWrite(DataFile* file, ValueSetterBase** setters) {
	ValueSetterBase* setter = nil;
	int status = true;
	while((setter = *setters++) != nil)
		if(!(status = setter->writeTo(file)))
			break;
	return status;
}

//********

StandardChunk::StandardChunk(const char* idString, long len)
	: magic(idString), chunkSize(len) {
}

ValueSetterBase**
StandardChunk::valueSetters() {
	static ValueSetterBase* setterList[NumElements + 1];	// one null element
	delete setterList[0];
	setterList[0] = newValueSetter(&magic);
	delete setterList[1];
	setterList[1] = newValueSetter(&chunkSize);
	return setterList;
}
