// curvegen.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// CurveGenerator and its associated subclasses are used to create continuous
// interpolated value curves for use in Envelopes.

#ifndef CURVEGEN_H
#ifdef __GNUG__
#pragma interface
#endif
#define CURVEGEN_H

#include "outputfunction.h"

class CurveGenerator : public OutputFunction {
	typedef OutputFunction Super;
public:
	CurveGenerator(Data* data, double base, double ending);
	CurveGenerator(Data* data);
	redefined double operator () (RunStatus *status);
	redefined void restoreState() { counter = 0; }
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request& r);
	virtual double curvePoint(double fraction) = 0;
private:
	redefined const QueryInfo *requestInfo();
	virtual const char* requestLabel() = 0;
private:
	int counter;
	int totalLength;
	double baseValue;
	double height;
};

class DataEditor;

class LinearCurveGenerator : public CurveGenerator {
public:
	LinearCurveGenerator(Data* data, double base, double ending)
			: CurveGenerator(data, base, ending) {
		initialize();
	}
	LinearCurveGenerator(Data* data) : CurveGenerator(data) {}
	static Modifier* create(DataEditor *);
protected:
	redefined double curvePoint(double fraction) { return fraction; }
private:
	redefined const char* requestLabel() {
		return "Create Linear Segment over Selected Region:";
	}
};

class ExponentialCurveGenerator : public CurveGenerator {
public:
	ExponentialCurveGenerator(Data* data, double base, double ending,
		double expon) : CurveGenerator(data, base, ending), exponent(expon) {
		initialize();
	}
	ExponentialCurveGenerator(Data* data) : CurveGenerator(data) {}
	static Modifier* create(DataEditor *);
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request& r);
	redefined double curvePoint(double fraction);
private:
	redefined const char* requestLabel() {
		return "Create Exponential Curve over Selected Region:";
	}
private:
	double exponent;
};

#endif

