/*

This software module was originally developed by 

Mike Guzewicz (E-mu Systems)


in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3) standard. 
This software module is an implementation of a part of one or more 
MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio 
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) 
free license to this software module or modifications thereof for use 
in hardware or software products claiming conformance to the MPEG-4 Audio 
(ISO/IEC 14496-3). Those intending to use this software module in hardware 
or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, the 
subsequent editors and their companies, and ISO/IEC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming 
products. E-mu Systems retains full right to use the code for his/her own 
purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) 
conforming products. This copyright notice must be included in all copies 
or derivative works. 

Copyright (C) 1997 E-mu Systems, Inc.

*/     /*********************************************************************
     
     sfe_emuerrs.h
     
      
     *********************************************************************/


/*****************************************************************************
*  @(#)emuerrs.h	1.1 12:06:28 3/15/95 12:06:35
*
* Filename: emuerrs.h
*
* Description: Header file for Enabler Error Codes                 
*
*******************************************************************************
*/

#ifndef __EMUERRS_H
#define __EMUERRS_H

/*************
** Includes
*************/

#include "sfe_datatype.h"

/************
** Defines
************/

#define SUCCESS  0

/***********************
** Enumeration Tables
***********************/

/* last value 0 0x0 */

enum RIFFERRORTAG
{
  RIFF_IDERROR = SUCCESS + 1,
  RIFF_ERROR,
  RIFF_FINDERROR,
  RIFF_OPENFILEERROR,
  RIFF_READFILEERROR,
  RIFF_WRITEFILEERROR
};

/* last value 6 0x6 */

enum SFERRORTAG
{
  SF_ERROR = RIFF_WRITEFILEERROR + 1,
  SF_BUFFERERROR,
  SF_MEMORYERROR,
  SF_INVALIDBANK,
  SF_BANKLINKERROR,
  SF_BANKLOADERROR,
  SF_WRONGWAVETABLE,
  SF_PRESETNOTFOUND
};


/**************************
** External Declarations
***************************/

/*
Create your own custom error messages to be indexed by the above
enumeration table.

I.E.

 char sfEr1[80];
 strcpy(sfEr1, "This file could not be opened\n");
 emuErrors[RIFF_OPENFILEERROR] = sfEr1;
 ...
 stat = EmuFunction();
 if (stat != SUCCESS) {
   printf("%s\n", emuErrors[stat]);
   return(-1);
   }

*/

extern CHAR* emuErrors[];

#endif /* __EMUERRS_H */

