/**********************************************************************
MPEG-4 Audio VM



This software module was originally developed by

Fraunhofer Gesellschaft IIS / University of Erlangen (UER

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1996.



Source file: 

$Id: psych.c,v 1.5 1997/11/10 21:04:33 purnhage Exp $

**********************************************************************/

/* CREATED BY :  Bernhard Grill -- August-96  */

#include "tf_main.h"
#include "psych.h"
#include "common.h"

/* dummy psychoacoustic module */
/*
  static int sfb_width_long[36+1] = { 
        4,  4,  4,  4,  4,  4,  4,  4,  4,  6,  6,  6, 
        6,  8,  8,  8, 10, 10, 12, 12, 14, 16, 18, 20, 
       22, 24, 26, 28, 32, 36, 40, 44, 48, 54, 62, 70, 342
    };
    static int sfb_width_short[12+1] = {
        4,  4,  4,  4,  4,  6,  6,  8,  8, 10, 12, 16, 42
    };
    static double fixed_ratio_long[36+1] = { 
        0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05,
        0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15,
        0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40, 
        1.00
    };
*/

 

static SR_INFO sr_info_aac[MAX_SAMPLING_RATES+1] =
{
  { 8000  },
  { 11025 },
  { 12000 },
  { 16000 },
  { 22050 },
  { 24000 },
  { 32000 },
  { 44100 },
  { 48000, 49, 14,
     { /*  cb_width_long[NSFB_LONG] */
      4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  8,  8,  8,  8,  8,  8,  8, 
      12, 12, 12, 12, 16, 16, 20, 20, 24, 24, 28, 28, 32, 32, 32, 32, 32, 32,
      32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 96 
     }, 
     { /* cb_width_short[NSFB_SHORT] */
      4,  4,  4,  4,  4,  8,  8,  8, 12, 12, 12, 16, 16, 16 
     },
     { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
     },
     { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
     }
  },
  { 96000 },
  { -1 }
};
static SR_INFO sr_info_960[MAX_SAMPLING_RATES+1] =
{
  { 8000  },
  { 11025 },
  { 12000 },
  { 16000 },
  { 22050 },
  { 24000 },
  { 32000 },
  { 44100 },
  { 48000, 49, 14,
     { /*  cb_width_long[NSFB_LONG] */
       4,4,4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 12, 12, 12, 12, 16, 16, 20, 20, 24, 24, 28, 28, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
       
     }, 
     { /* cb_width_short[NSFB_SHORT] */
       4,4,4, 4, 4, 8, 8, 8, 12,12,12,16,16, 8
     },
     { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
     },
     { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
     }
  },
  { 96000 },
  { -1 }
};


static SR_INFO sr_info_NOT_aac[MAX_SAMPLING_RATES+1] =
{
  { 8000  },
  { 11025 },
  { 12000 },
  { 16000 },
  { 22050 },
  { 24000 },
  { 32000 },
  { 44100 },
  { 48000, 37, 13,
    { /*  cb_width_long[NSFB_LONG] */
      4,  4,  4,  4,  4,  4,  4,  4,  4,  6,  6,  6, 
      6,  8,  8,  8, 10, 10, 12, 12, 14, 16, 18, 20, 
      22, 24, 26, 28, 32, 36, 40, 44, 48, 54, 62, 70, 342
    },
    { /* cb_width_short[NSFB_SHORT] */
      4,  4,  4,  4,  4,  6,  6,  8,  8, 10, 12, 16, 42
    },
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05,
      0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40, 
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 
      0.40, 1.00
    }
  },
  { 96000 },
  { -1 }
};



void EncTf_psycho_acoustic_init( void )
{
}

void EncTf_psycho_acoustic( 
			   /* input */
			   double sampling_rate,
			   int    no_of_chan,         /* no of audio channels */
			   double *p_time_signal[],
			   WINDOW_TYPE block_type[],
			   QC_MOD_SELECT qcSelect,
			   int frameLength,
			   /* output */
			   CH_PSYCH_OUTPUT p_chpo_long[],
			   CH_PSYCH_OUTPUT p_chpo_short[][MAX_SHORT_WINDOWS]
			   )
{ 
  int             ch;
  SR_INFO         *p_sri;



  /* YB : 971106 */
  if ((qcSelect==AAC_QC) || (qcSelect==AAC_SCALEABLE) || (qcSelect==AAC_BSAC) ){ /* AAC */
    switch (frameLength) 
      {
      case 960:
	p_sri = &sr_info_960[0];
	break;
      case 1024:
	p_sri = &sr_info_aac[0];
	break;
      default:
	CommonExit(-1,"\n illegal frameLength in EncTf_psycho_acoustic %d,frameLength");
      }
  }   
   
  else{
    p_sri = &sr_info_NOT_aac[0];
  }


  /* find correct sampling rate depending parameters */
  while( p_sri->sampling_rate != (long)sampling_rate ) {
    if( p_sri->sampling_rate == -1 ) {
      CommonExit( 1, "Encode: unknown sampling rate in psychoacoustic module %f", sampling_rate );
    }
    p_sri++;
  }

  for( ch=0; ch<no_of_chan; ch++ ) {
    int i;

    p_chpo_long[ch].p_ratio   = p_sri->fixed_ratio_long;
    p_chpo_long[ch].cb_width  = p_sri->cb_width_long;
    p_chpo_long[ch].no_of_cb  = p_sri->num_cb_long;
    for( i=0; i<MAX_SHORT_WINDOWS; i++ ) {
      p_chpo_short[ch][i].p_ratio  = p_sri->fixed_ratio_short;
      p_chpo_short[ch][i].cb_width = p_sri->cb_width_short;
      p_chpo_short[ch][i].no_of_cb = p_sri->num_cb_short;
    }
  }
}


