
/**********************************************************************


This software module was originally developed by

Gerald Schuller (University of Hannover / ACTS-MoMuSys)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. ACTS-MoMuSys partners retain
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.


**********************************************************************/


#define Float double   /*mache alles in double precision*/ 

typedef struct{
   int n;
   int *b_len;
   int *event;
}EVENT_MAP;

typedef struct{
   long  gain[4][32];
}GAIN_INFO;

typedef struct{
   double  *p_time_signal;
   long  window_type;
   double  *p_spectrum;
   EVENT_MAP  **pp_event_map;
   GAIN_INFO  *gain_info;
}T2M_CHANNEL_INFO;


/** dct.h **/
#define LDCTMAX 4096
void dct(Float x[],int n);
void idct(Float x[],int n);
void odct(Float x[],int n);
void bitrev1(Float x[],int n);
void init_dctmat();
/**********/


void multC(double y[],double x[],double c[], int N);

void multF(double y[],double x[],double d[],int N);

void multG(double y[],double x[],double g[],double z[],int N);

void multE(double y[],double x[],double g[],double z[],int N);

void multE0(double y[],double x[],double g[],double z[],int N);

void multH(double y[],double x[],double g[],double z[],int N);

void multH2(double y[],double x[],double g[],double z[],int N);

void multH0(double y[],double x[],double g[],double z[],int N);

void multFDi(double y[],double x[],double g[],double z[],int N);

void multH20(double y[],double x[],double g[],double z[],int N);

void multD(double y[],double x[],double z[],int N);

void multDinv(double y[],double x[],double z[],int N);

void affbmid(double out[],double fb[],int N,int n,double x[],int L,int blocks,int c,double z[]);

void affbmidv(double out[],double fb[],int N1,int N2,int n,double x[],int L,int blocks,int c,double z[]);

void sffbmid(double out[],double fb[],int N,int n,double x[],int L,int blocks,int c,double z[]);

void sffbmidv(double out[],double fb[],int N1,int N2,int n,double x[],int L,int blocks,int c,double z[]);


void time2freqaac(long channel_enable_mask, T2M_CHANNEL_INFO ch_info[MAX_CHANNELS]);

void freq2timeaac(long channel_enable_mask, T2M_CHANNEL_INFO ch_info[MAX_CHANNELS]);


void buffer2freqLDAAC(double *timeInPtr, /*input: 1/2 block of new time values*/
        	    double *freqOutPtr, /* output: interleaved spectrum */
                    double p_overlap[],
		    WINDOW_TYPE blockType, /* input: block type 0-3 */
                    Window_shape  wfun_select,      /* offers the possibility to select different window functions */
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Mdct_in          overlap_select,
  int              num_short_win,    /* number of short windows to      */
                                     /* transform: not used!            */
  int              save_window       /* save window information: not used! */ 
                     );


void freq2bufferLDAAC(double *freqInPtr, /* input: interleaved spectrum */
		double *ftimeOutPtr, /* output: 1/2 block of new time values */
                double p_overlap[],
               WINDOW_TYPE blockType,	       /* input: block type 0-3 */
               int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Window_shape       wfun_select,      /* offers the possibility to select different window functions */
  Window_shape     wfun_select_prev, /* not used   HP 971113 */
  Imdct_out    	   overlap_select,    /* select imdct output *TK*	*/
 int              num_short_win  /* number of short windows to      */
                                     /* transform: not used!            */
        ); 



void freq2timetv(long channel_enable_mask, T2M_CHANNEL_INFO ch_info[MAX_CHANNELS]);

void freq2bufferLDTV(double *freqInPtr, /* input: interleaved spectrum */
		double *ftimeOutPtr, /* output: 1/2 block of new time values */
                double p_overlap[],
               WINDOW_TYPE blockType,	       /* input: block type 0-3 */
               int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Window_shape       wfun_select,      /* offers the possibility to select different window functions */
  Window_shape     wfun_select_prev, /* not used   HP 971113 */
  Imdct_out    	   overlap_select,    /* select imdct output *TK*	*/
 int              num_short_win  /* number of short windows to      */
                                     /* transform: not used!            */
        );

void time2freqtv(long channel_enable_mask, T2M_CHANNEL_INFO ch_info[MAX_CHANNELS]);


void buffer2freqLDTV(double *timeInPtr, /*input: 1/2 block of new time values*/
        	    double *freqOutPtr, /* output: interleaved spectrum */
                    double p_overlap[],
		    WINDOW_TYPE blockType, /* input: block type 0-3 */
                    Window_shape  wfun_select,      /* offers the possibility to select different window functions */
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Mdct_in          overlap_select,  /*not used! */
  int              num_short_win,    /* number of short windows to      */
                                     /* transform: not used!            */
  int              save_window       /* save window information: not used! */

                     ); 





void freq2bufferMDCT(
  double           p_in_data[], 
  double           p_out_data[],
  double           p_overlap[],
  WINDOW_TYPE block_type,
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Window_shape     wfun_select,      /* offers the possibility to select different window functions */
  Window_shape wfun_select_prev,     /* YB : 971113 */
  Imdct_out	   overlap_select,   /* select imdct output *TK*	*/
				     /* switch (overlap_select) {	*/
				     /* case OVERLAPPED:		*/
				     /*   p_out_data[]			*/
				     /*   = overlapped and added signal */
				     /*		(bufferlength: nlong)	*/
				     /* case NON_OVERLAPPED:		*/
				     /*   p_out_data[]			*/
				     /*   = non overlapped signal	*/
				     /*		(bufferlength: 2*nlong)	*/
  int              num_short_win     /* number of short windows to      */
                                     /* transform                       */
  );





void buffer2freqMDCT(
  double           p_in_data[], 
  double           p_out_mdct[],
  double           p_overlap[],
  WINDOW_TYPE block_type,
  Window_shape     wfun_select,      /* offers the possibility to select different window functions */
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Mdct_in          overlap_select,   /* select mdct input *TK*          */
                                     /* switch (overlap_select) {       */
                                     /* case OVERLAPPED:                */
                                     /*   p_in_data[]                   */
                                     /*   = overlapped signal           */
                                     /*         (bufferlength: nlong)   */
                                     /* case NON_OVERLAPPED:            */
                                     /*   p_in_data[]                   */
                                     /*   = non overlapped signal       */
                                     /*         (bufferlength: 2*nlong) */
  int              num_short_win,    /* number of short windows to      */
                                     /* transform                       */
  int              save_window       /* save window information         */
);
