/**********************************************************************
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: lingual.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: lingual.c,v $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
 **********************************************************************/

#define VERY_FAST_FILTER  1	/* JMZ */

#define LOWPASS 20

#include "common.h"
#include "encoder.h"

/************************************************************************/
/*
/* read_samples()
/*
/* PURPOSE:  reads the PCM samples from a file to the buffer
/*
/*  SEMANTICS:
/* Reads #samples_read# number of shorts from #musicin# filepointer
/* into #sample_buffer[]#.  Returns the number of samples read.
/*
/************************************************************************/

unsigned long read_samples_ml(FILE *musicin, long int *sample_buffer, long unsigned int num_samples, long unsigned int frame_size, int *byte_per_sample, int *aiff)
{
unsigned long samples_read;
static unsigned long samples_to_read;
static char init = TRUE;
short pcm_sample_buffer[8064];        /*for correct reading of pcm-data*/
int i;

if (init) 
{
	samples_to_read = num_samples;
	init = FALSE;
}
if (samples_to_read >= frame_size)
	samples_read = frame_size;
else
	samples_read = samples_to_read;
if((*aiff==1) &&(*byte_per_sample !=2))
{
if ((samples_read = fread(sample_buffer, *byte_per_sample, (int)samples_read, musicin)) == 0)
	printf("Hit end of audio data\n");
}
else
{
if ((samples_read = fread(pcm_sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0)
	printf("Hit end of audio data\n");
for(i = 0; i < 5760; ++i) 
	sample_buffer[i] = pcm_sample_buffer[i];
}

samples_to_read -= samples_read;
if (samples_read < frame_size && samples_read > 0) 
{
	printf("Insufficient PCM input for one frame - fillout with zeros\n");
	for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);
	samples_to_read = 0;
}
return(samples_read);
}

 
/************************************************************************/
/*
/* get_audio_ml()
/*
/* PURPOSE:  reads a frame of audio data from a file to the buffer,
/*   aligns the data for future processing, and separates the
/*   left and right channels
/*
/*  SEMANTICS:
/* Calls read_samples() to read a frame of audio data from filepointer
/* #musicin# to #insampl[]#.  The data is shifted to make sure the data
/* is centered for the 1024pt window to be used by the psychoacoustic model,
/* and to compensate for the 256 sample delay from the filter bank. For
/* stereo, the channels are also demultiplexed into #buffer[0][]# and
/* #buffer[1][]#
/*
/************************************************************************/
unsigned long
get_audio_ml(
	FILE *musicin_ml,
	double (*buffer)[1152],
	long unsigned int num_samples,
	IFF_AIFF *aiff_ptr,
	frame_params *fr_ps,
	int *aiff,
	int *byte_per_sample,
	double (*buffer_matr)[1152]
) {
int j, i;
long insamp[8064];
unsigned long samples_read;
int lay;
layer *info = fr_ps->header;
int n_ml_ch = info->multiling_ch;
	
	lay = info->lay;
/* JMZ 16/03/1995 MODIFICATIONS */
	/*samples_read = read_samples_ml(musicin_ml, insamp, 1152*n_ml_ch, (unsigned long) 1152*n_ml_ch, byte_per_sample, aiff);*/
	samples_read = read_samples_ml(musicin_ml, insamp, num_samples, (unsigned long) 1152*n_ml_ch, byte_per_sample, aiff);
	for(j=0; j<1152; j++) 
	{
			buffer[7+0][j] 		= insamp[n_ml_ch*j];
			buffer_matr[7+0][j]	= insamp[n_ml_ch*j+0];

		if (n_ml_ch >1)
			{
			buffer[7+1][j] 		= insamp[n_ml_ch*j+1];
			buffer_matr[7+1][j]	= insamp[n_ml_ch*j+1];

			}
		if (n_ml_ch >2)
			{
			buffer[7+2][j] 		= insamp[n_ml_ch*j+2];
			buffer_matr[7+2][j] 	= insamp[n_ml_ch*j+2];

			}
		if (n_ml_ch >3)
			{
			buffer[7+3][j] 		= insamp[n_ml_ch*j+3];
			buffer_matr[7+3][j] 	= insamp[n_ml_ch*j+3];

			}
		if (n_ml_ch >4)
			{
			buffer[7+4][j] 		= insamp[n_ml_ch*j+4];
			buffer_matr[7+4][j] 	= insamp[n_ml_ch*j+4];

			}
		if (n_ml_ch >5)
			{
			buffer[7+5][j] 		= insamp[n_ml_ch*j+5];
			buffer_matr[7+5][j] 	= insamp[n_ml_ch*j+5];

			}
		if (n_ml_ch >6)
			{
			buffer[7+6][j] 		= insamp[n_ml_ch*j+6];
			buffer_matr[7+6][j] 	= insamp[n_ml_ch*j+6];

			}

	/* Remplacer les "if" par un for (i=0;i<n_ml_ch...) */
	}
return(samples_read);
}

/************************************************************************
/*
/* I_encode_scale  (Layer I)
/* II_encode_scale (Layer II)
/*
/* PURPOSE:The encoded scalar factor information is arranged and
/* queued into the output fifo to be transmitted.
/*
/* For Layer II, the three scale factors associated with
/* a given subband and channel are transmitted in accordance
/* with the scfsi, which is transmitted first.
/*
/************************************************************************/
 
 
void II_sample_encoding_ml(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
             	                           	/*24/02/1995 JMZ Multilingual */
             	                       		/*24/02/1995 JMZ Multilingual */
             	       
                     
{
   unsigned int temp;
   unsigned int i,j,k,s,x,y, l, m;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsboundmc = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
   int n_ml_ch = fr_ps->header->multiling_ch;
   
for (s=0;s<3;s++)
for (j=0;j<12;j+=3)
for (i=0;i<sblimit;i++)
for (m = 7; m < 7+n_ml_ch; m++)
{
	k=m;
	if (bit_alloc[k][i]) 
	{
		if ((*alloc)[i][bit_alloc[k][i]].group == 3) 
		{
			for (x = 0; x < 3; x++)
			putbits(bs,sbband[k][s][j+x][i],
                                    (*alloc)[i][bit_alloc[k][i]].bits);
		}
		else 
		{
			y =(*alloc)[i][bit_alloc[k][i]].steps;
			temp = 	sbband[k][s][j][i] +
				sbband[k][s][j+1][i] * y +
				sbband[k][s][j+2][i] * y * y;
			putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);

		}
	}
}
}

void II_encode_bit_alloc_ml(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
             	                       		/*24/02/1995 JMZ Multilingual */
             	       
                     
{
   int i,k, l, m;
   int stereo	   = fr_ps->stereomc;
   int sblimit     = fr_ps->sblimit;
   int jsboundmc   = fr_ps->jsboundmc;
   int n_ml_ch     = fr_ps->header->multiling_ch;
   al_table *alloc = fr_ps->alloc;
   int ll;
 
for (i=0;i<sblimit;i++)
{
	for(k = 7; k < 7+n_ml_ch; ++k)
	{        
		putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);

	}
}	
}


