/* this file is a part of amp software, (C) tomislav uzelac 1996,1997
*/
 
/* huffman.c  huffman decoding/tree creation
 *
 * tomislav uzelac  Mar,Apr 1996
 */
#include <stdlib.h>
          
#include "audio.h"
#include "getbits.h"

#define HUFFMAN
#include "huffman.h"

int huffman_create(table_file,target)
FILE *table_file;
struct LINK *target;
{
struct LINK *append,*active,*link;
struct LINK temp;
char length,i;

	target->p0 = target->p1 =0;
	append=target+1;

	for (;;) {
        	if (!get_value(table_file,&temp.x)) break;
	        if (!get_value(table_file,&temp.y)) break;
	        if (!get_value(table_file,&length)) break;
		active=target;	

		for (i=0;i<length-1;i++) {
			get_symbol(table_file);
			link=follow_link(active,symbol);

			if (link) active=link;
			else 	{
				create_link(0,0,append,active,symbol);
				active=append++;
			}
		}
		get_symbol(table_file);
		create_link(temp.x,temp.y,append++,active,symbol);
		while (symbol != 0xa) symbol=fgetc(table_file);
	} 
	return ((unsigned int)append-(unsigned int)target)/sizeof(struct LINK);
}

/* huffman_decode() decode 1 huffcode according to tbl and return the number 
 * bits used.
 */
int huffman_decode(tbl,x,y)
int tbl;
int *x,*y;
{
struct LINK *active,*link,*tree;
int i=0,off,pos;
char bit;

	*x=0;*y=0; /* mrzim! Fri Sep 20 10:51:49 MET DST 1996 */
	if (tbl==0) return 0;
	tree=t_huf[tbl];
	active = link = tree;
	pos=data>>3;
	off=data&7;

	while (link) {
	 	bit=(buffer[pos]>>(7-off))&1;
		link=follow_link(active,bit);
                if (active-tree > 511) {
			printf(" sorry, joe\n");
			exit(-1);
		}
		if (link) {
			active=link;
			if (SHOW_HUFFBITS) printf("%d",bit);
			if (off==7) {
				off=0;
				pos++;
			}
			else off++;
			i++;
		}
		else {
	   		/*if (SHOW_HUFFBITS) 
	   			printf(" (%d,%d)\n",active->x,active->y);*/
		   	*x=active->x;
		   	*y=active->y;
	   	}
	}
	data+=i;
	data&=8*BUFFER_SIZE-1;
	return i;
}  

static int get_value(stream,out)
FILE *stream;
char *out;
{
char symbol,number[10],*nptr;

	nptr=number;
	do {
		symbol=fgetc(stream);
		if (symbol == EOF) return 0;
		*nptr++=symbol;
	} while (symbol != 0x20);

	*--nptr=0;	/* null TERMINATOR */
	*out=atoi(number);
	return 1;		
}
			
static inline struct LINK *follow_link(active,symbol)
struct LINK *active;
char symbol;
{
	if (symbol) return active->p1;
	else return active->p0;
}

static inline void create_link(x,y,append,active,symbol)
int x,y;
struct LINK *append,*active;
char symbol;
{
	if (symbol) active->p1=append;
	else active->p0=append;

	append->x=(char) x;
	append->y=(char) y;
	append->p0 = append->p1 = 0; 
	return;
}

static inline int get_symbol(stream)
FILE *stream;
{
char s;

	s=fgetc(stream);
	if ((s!=EOF)&&(s==48||s==49)) symbol=s-48;
	else	{
		printf(" bad huffman table... exiting\n");
		exit(-1);
	}
	return 1;
}

void huffman_init()
{
int i;
FILE *ftab;
	for (i=0;i<34;i++) {
	/* change the tables path HERE (it's temporary aniway, no separate tables in 0.8)
	*/
		char path[128]="/usr/local/amp/";
		if (t_tab[i]) {
			sprintf(path+strlen(path),"%s",t_tab[i]);
			ftab=fopen(path,"r");
			if (ftab==NULL) {
				printf(" could not open huffman tables. sorry. \n");
				exit(-1);
			}
			t_huf[i]=(struct LINK *)malloc(t_hufsize[i]*sizeof(struct LINK));
			if (t_huf[i]==NULL) {
				printf(" not enough memory\n");
				exit(-1);
			}
			huffman_create(ftab,t_huf[i]);
			fclose(ftab);
		}
		if (i>16 && i<=23) t_huf[i]=t_huf[16];
		if (i>24 && i<=31) t_huf[i]=t_huf[24];
	}
}
