/*
 *  totex.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TOTEX_DOT_H
#define TOTEX_DOT_H
#include "entabl.h"
#include "texrep.h"

void ListTextLine(const char *);
void BeginListItem();
void BeginLetteredList();
void BeginNumberedList();
void NewParagraph();
void TableOptions(TableOptionSelect opt, const char *Options=0) ;
void TableFormat(const char * Format);
void TableEntry(const char * Item) ;
void TableNewLine();
void TableEnd();
void FoundTextLine(const char * line);
void FoundTab();

void FlushTextLine(const char *) ;
void TextLine(const char *) ;
void VerbatimLine(const char *) ;
void EmptyVerbatim();

void ListTextLine(const char *);
void EndList();
void Section(int Depth, const char * SectionHeading);

void Verbatim(int Start);

void Caption(const char *Caption, const char * Lab=0);

void IndexColumn(int index) ;

// Lex routines

TableOptionSelect ExpandOption(const char * String);
void ClearCaptionIndexTable();
extern int CaptionOn ;

extern int yydebug ; // yacc debugging flag

#define Dbg if (yydebug)

#endif /* #ifdef TOTEX_DOT_H */
