/*
 *  mknodey.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  mknodey.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef MKNODEY_DOT_H
#define MKNODEY_DOT_H
#include <stream.h>
#include <fstream.h>
#include "stdyac.h"
#include "stdyacp.h"
#include "yacoper.h"
#include "portable.h"
#include "mkstr.h"

struct Compound ;
class TextFragmentList ;
class MofStream ;

Compound * MakeNegIntItem(int32);
Compound * MakeNegDoubleItem(struct Double *) ;

Compound * MakeZeroIntItem(int32);
Compound * MakeIntItem(int32);
Compound * MakeDoubleItem(struct Double *) ;

Compound * MakeStringItem(const char *) ;
Compound * MakeTermItem(int) ;
Compound * ShortLongDesc(Compound *,TextFragmentList *,
	const char * HelpFileName);

void FoundDeclaration();
void FoundOtherCtor(int Type, const char * Name, Compound * Exp );
void FoundDfNodeCtor();
void FoundNodeName(const char * Node);
void FoundTypedName(int ChangeFlag, int type, const char * name);
void FoundPtrTypedName(int ChangeFlag, int type, const char * name);
void FoundDeclarationCode(TextFragmentList * code = 0);
void NodeComplete();

void FoundNodeDescription(Compound * Describe);
void FoundBaseDescription(TextFragmentList * Text);
Compound * FoundMenuLine(const char * MenuName, TextFragmentList * Text);
Compound * Exp(Compound *, char, Compound *);
Compound * Exp(Compound *, const char *, Compound *);
Compound * Unary(char , Compound *);
Compound * Unary(const char *, Compound *);
Compound * Paren(Compound *);
Compound * Func(Compound *, Compound *);
Compound * Array(Compound *, Compound *);
Compound * Cast(int, const char * Extra, Compound *);
Compound * Cast(Compound *, const char * Extra, const char * name);
Compound * Cast(Compound *, const char * Extra, Compound *);

Compound * MakeTree(const char *) ;
Compound * Null() ;
void FoundCtorParam(const char *, Compound *);
Compound * MakeQuoteString(const char * );
Compound * MakeStringNumber(Compound *);

Compound * CkStr(Compound * C) ;

Compound * NullDescription();
			
void FoundNodeInstance(const char *, Compound *, Compound *);

Compound * FoundConstant(Compound *, Compound *);
Compound * FoundConstant(Compound *);

extern TextFragmentList * StaticInitCode ;
inline void FoundStaticInit(TextFragmentList * text){StaticInitCode = text;}
inline void NoStaticInit() {StaticInitCode = 0 ;}
void EmitStaticInitCtors(MofStream& CppOut) ;
void EmitStaticInitVariables(MofStream& hd) ;
void EmitStaticEmitFuncBody(MofStream& CppOut) ;
void EmitStaticInitCtorParams(MofStream& Out) ;
void EmitStaticEmitCtorFuncBody(MofStream& CppOut) ;
void EmitStaticEmitCtorFunc(int DecFlag, MofStream& hd) ;

void FoundStaticArray(int type, const char * name, Compound * exp);
void FoundStaticScalar(int type, const char * name);

void CodeComplete();

void FoundTiming(TextFragmentList *);
void FoundTiming(const char *, const char *, TextFragmentList *);
void NoTiming();

void FoundCtor(TextFragmentList *);
void FoundKernel(TextFragmentList *);
void FoundStateEmit(TextFragmentList *);

void FoundDtor(TextFragmentList * code);
void FoundCheckSafeDelete(TextFragmentList * code);
void FoundBaseFunctionName(const char *);
void FoundInclude(const char *, int Token);

extern const char * ClassName ;
inline void FoundClassName(const char * cls) {ClassName = cls;}

void FoundInteractiveList(const char *) ;

void FoundMemberName(const char * ClassName, const char * Name,
	Compound * Descript, int wait);

Compound * FoundParameterSubDef(const char * ClassName, const char * ParamName,
	const char * DefaultName, Compound * Descript);

Compound * FoundParameter(const char * ClassName, const char * ParamName,
	const char * DefaultName, Compound * Descript);
Compound * FoundParameter(Compound * Type, const char * Name, Compound * Lower,
	Compound * Default, Compound * Upper, Compound * Descript,
	struct ArraySize * s = 0) ;
Compound * FoundPtrParameter(Compound *, const char * Name, Compound * Lower,
	Compound * Default, Compound * Upper, Compound * Descript,
	Compound *Size) ;
Compound * FoundParameter(Compound * Type, const char * Name);

Compound * ScaleDeclaration(int ChangeFlag, int Type, Double * Dbl = 0);


Compound * MakeSize(int32 MinSize=0, int32 MaxSize = 0);

Compound * MakeParamFunc(Compound * list, TextFragmentList * code);
Compound * MakeParamFunc(TextFragmentList * code);

Compound * MakeNameList(Compound * list, const char * name) ;
Compound * MakeNameList(const char * name) ;
Compound * MakeSignedComplexItem(Compound *, Compound *);
Compound * MakeComplexItem(Compound *, Compound *);
Compound * MakeNumParmList(Compound *);
Compound * AppendNumParmList(Compound *,Compound *);
void HeaderOnly() ;

void FoundParameterCheck(int IsFirstDefault, Compound *, TextFragmentList *);
void FoundNetworkRef();

extern class Double * DoubleOne ;

extern const char * DefBaseName ;

extern int PublicFlag;
inline void MarkPublicBaseFunction() {PublicFlag = 1;}

const char * MakeClassName(int Type, int Reference);
const char * MakeClassName(const char * Name, int Reference);
const char * MakeClassName(int Type);
const char * MakeClassName(const char * Name);

extern int BaseSwitch ;
inline void SetBaseSwitch() {BaseSwitch = 1; }
inline void DoNodeInit() {BaseSwitch = 0 ;}
void FoundDefaultHelp(const char * name);
void NewMember(const char * Name);
void NoDefaultInstance() ;
void BaseMembers();
void FoundTargetType(int Type);
void SetUserCopyright();
void FoundArithType(const char *);
void FoundFirstArithType(const char *);
void FoundNoDefault();

#include "fileios.h"
extern MofStream * HeaderOut ;
extern MofStream * CppOut ;
extern const char * NewReserved ;

#ifdef __NT_VC__
#include <malloc.h>
#endif

#endif /* #ifdef MKNODEY_DOT_H */
