/*
 *  ctorinit.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef CTORINIT_DOT_H
#define CTORINIT_DOT_H
/*  ctorinit.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "portable.h"
const char * GetBaseClassName() ;
const MaxNumberDfNodeParams = 32 ;
enum UsrObjParmType {DfInt16,DfInt32,DfInt,DfString,DfDouble,DfEntity};
extern const char * UsrObjParmTypeName[] ;
class MofStream ;

union NodeParameterValue {
	double Double;
	const char * String ;
	int32 Integer ;
	NodeParameterValue() {}
	NodeParameterValue(double Val) {Double = Val; }
	NodeParameterValue(const char * Val) {String = Val; }
	NodeParameterValue(int32 Val) {Integer = Val;}
	void out(UsrObjParmType type,const char * ter=0);
	int equal(UsrObjParmType,NodeParameterValue);
} ;

struct UserObjParameter {
	UsrObjParmType Type ;
	const char * TypeName ;
	const char * UserName ;
	NodeParameterValue DefaultValue ;
	NodeParameterValue Min ;
	NodeParameterValue Max ;
	UserObjParameter() {}
	UserObjParameter(UsrObjParmType type, const char * name,
		NodeParameterValue def, NodeParameterValue min,
		NodeParameterValue max, const char *type_name=0) ;
	void param_out(int right_flag);
	// ~UserObjParameter(){delete UserName;}
	int equal(UserObjParameter&);
};

typedef void (*CtorDefaultsInit) (UserObjParameter **, int& Num,
	const char **, const char **, const char **, int& KernelFlag,
	const char ** base_class, const char ** tex_describe);

struct CtorDefaults {
	UserObjParameter * Parameters ;
	int NumberParameters ;
	const char * BaseFunctionName ;
	const char * IncludeFileName ;
	const char * BaseCheckSafe ;
	const char * parent_class ;
	const char * purpose_tex ;
	int KernelFlag;
	CtorDefaults(CtorDefaultsInit Init);
	void EmitBaseFunctionName(MofStream& HeaderOut);
	void EmitDfNodeParam(MofStream& CppOut) ;
	void EmitParameters(MofStream& CppOut, const char * Name=0,
		const char * Default = 0) ;
	void table_out();
	void param_table_out();
} ;

struct CtorParam {
	const char * Name ;
	const char * Expression ;
};

extern CtorParam CtorParamFound[] ;


int InitFoundBaseFunctionName(const char * Name, const char * NodeName) ;
extern CtorDefaults * CtorBaseClassDefaults ;

void create_prgramming_documentation();

#include "ndconst.h"


#endif /* #ifdef CTORINIT_DOT_H */
