/*
 *  filename.cxx from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include <stdlib.h>
#include <stream.h>
#include "package.h"
#include "filedes.h"

#include "filename.h"
void TestAlloc(const char * Msg=0);

char * MakeFullName(const char * DirName,const char * Name, const char * sub)
{
	char * Tname = 0 ;
	int length = 0 ;
	int Start = 0;
	TestAlloc("MakeFullName enter");
	if (sub) Start=1+strlen(sub);
	length = strlen(Name) + strlen(DirName) + 2 + Start ;
	// cerr << "length = " << length << "\n" ;
	TestAlloc("MakeFullName a");
	Tname = new char[length];
	TestAlloc("MakeFullName aa");
	strcpy(Tname,DirName);
	TestAlloc("MakeFullName b");
	strcat(Tname,"/");
	if (sub) {
		strcat(Tname,sub);
		strcat(Tname,"/");
		TestAlloc("MakeFullName c");
	}
	strcat(Tname,Name);
	TestAlloc("MakeFullName exit");
	return Tname ;
}


#define TEST_ALLOC
#ifdef TEST_ALLOC
extern ostream ** debug_make_out ;
extern PackageDesc * debug_pkg ;
#include <fstream.h>

static void make_out()
{
	if (debug_make_out) if (*debug_make_out) {
		**debug_make_out << "test\n\n" ;
		(*debug_make_out)->flush();
		delete *debug_make_out ;
		*debug_make_out = new ofstream("temp");
		**debug_make_out << "test\n\n" ;
	}
}

void TestAlloc(const char * Msg)
{
	return ;
    // if (Msg) cerr <<  Msg << "\n"  ;
	// make_out();
    // cerr << "Enter TestAlloc\n";
    const Number = 43 ;
	static int not_first = 0 ;
    static char * Tests[Number];
	if (not_first) for (int i = 0 ; i < Number; i++) {
		delete Tests[i] ;
	}
	not_first = 1 ;
    for (int i = 0 ; i < Number; i++) {
        int Limit = 2*i+7 + 3*i;
        char * Temp ;
        Tests[i] = Temp = new char[Limit];
        for (int j = 0 ; j < Limit ; j++) Temp[j] = rand();
        // delete Tests[i] ;
        // Tests[i] = 0 ;
    }
    for (i = 0 ; i < Number>> 1; i++) {
		delete Tests[i] ;
		Tests[i] = 0 ;
	}

	char * tmp = new char[70] ;
	HeaderFile ** hd = 0;
	if (debug_pkg) hd = debug_pkg->GetAllHeaders() ;
	if (hd) for (HeaderFile ** h = hd; *h; h++) {
		const char * inc_dir = (*h)->inc_dir();
		if (inc_dir) for (const char * t = inc_dir; *t ;t++) {
			if (*t >126 || *t < 32)
						exit(1);
		}
	}
	delete tmp ;
	{
		static int already_called = 0 ;
		if (!already_called) {
			already_called = 1 ;
			char * tst = MakeFullName("${C_DIR_1}", "spellfil.C",0);
			delete tst ;
			already_called = 0 ;
		}
	}
	// make_out();
    // cerr << "Exit TestAlloc\n";
}
#endif

