/*
 *  menutab.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef MENUTAB_DOT_H 
#define MENUTAB_DOT_H
#include "dynmen.h"

#include "remdyn.h"

#include "remexe.h"

extern MenuLine MainCgiMenuLine[];
static Menu MainCgi
	("ObjectProDSP menu data base",MainCgiMenuLine,
	0);

extern MenuLine HelpMenuMenuLine[];
static Menu HelpMenu
	("Structured access to on-line documentation",HelpMenuMenuLine,
	0);

extern MenuLine DetailedHelpMenuLine[];
static Menu DetailedHelp
	("Online manual",DetailedHelpMenuLine,
	0);

extern MenuLine HelpDspPPMenuMenuLine[];
static Menu HelpDspPPMenu
	("ObjectProDSP language",HelpDspPPMenuMenuLine,
	0);

extern MenuLine HelpLevelsMenuLine[];
static Menu HelpLevels
	("Control information display",HelpLevelsMenuLine,
	0);

extern MenuLine FilesMenuMenuLine[];
static Menu FilesMenu
	("Read files",FilesMenuMenuLine,
	0);

extern MenuLine DebugOptionsMenuMenuLine[];
static Menu DebugOptionsMenu
	("Control debugging options",DebugOptionsMenuMenuLine,
	0);

extern MenuLine SimpleVariableMenuMenuLine[];
static Menu SimpleVariableMenu
	("Display simple variables",SimpleVariableMenuMenuLine,
	0);

extern MenuLine AllClsMenuLine[];
static Menu AllCls
	("Object classes",AllClsMenuLine,
	0);

extern MenuLine DiskMenuMenuLine[];
static Menu DiskMenu
	("Nodes that access disk files",DiskMenuMenuLine,
	0);

extern MenuLine AsciiDiskNodesMenuMenuLine[];
static Menu AsciiDiskNodesMenu
	("Nodes to read and write ascii files",AsciiDiskNodesMenuMenuLine,
	0);

extern MenuLine BinaryDiskNodesMenuMenuLine[];
static Menu BinaryDiskNodesMenu
	("Nodes to read and write binary files",BinaryDiskNodesMenuMenuLine,
	0);

extern MenuLine DspNodesMenuMenuLine[];
static Menu DspNodesMenu
	("DSP processing objects",DspNodesMenuMenuLine,
	0);

extern MenuLine SignalNodesMenuMenuLine[];
static Menu SignalNodesMenu
	("Signal generator objects",SignalNodesMenuMenuLine,
	0);

extern MenuLine ListNodesMenuMenuLine[];
static Menu ListNodesMenu
	("Listing objects",ListNodesMenuMenuLine,
	0);

extern MenuLine NetworkMenuMenuLine[];
static Menu NetworkMenu
	("Networks",NetworkMenuMenuLine,
	0);

extern MenuLine PlotNodesMenuMenuLine[];
static Menu PlotNodesMenu
	("Plotting objects",PlotNodesMenuMenuLine,
	0);

static DynamicMenu ExampleMenu
	("Example networks", 0,
	1);

extern MenuLine ExampOptMenuMenuLine[];
static Menu ExampOptMenu
	("Describe or execute this example",ExampOptMenuMenuLine,
	0);

extern MenuLine CGIStateMenuMenuLine[];
static Menu CGIStateMenu
	("Program State",CGIStateMenuMenuLine,
	0);

extern MenuLine RecordSessionMenuLine[];
static Menu RecordSession
	("Record or playback a session",RecordSessionMenuLine,
	0);

extern MenuLine AddNodeOptMenuMenuLine[];
static Menu AddNodeOptMenu
	("Options for `Add'",AddNodeOptMenuMenuLine,
	0);

static DynamicMenu AddInstancesMenu
	("Select an Instance of `Add' to describe or delete", 0,
	1);

extern MenuLine AddInstanceAccessMenuMenuLine[];
static Menu AddInstanceAccessMenu
	("Describe or delete an instance of  object `Add'",AddInstanceAccessMenuMenuLine,
	0);

extern MenuLine AddParamMenuMenuLine[];
static Menu AddParamMenu
	("Menu of Parameters for `Add' Object",AddParamMenuMenuLine,
	0);

extern MenuLine AddVariableMenuMenuLine[];
static Menu AddVariableMenu
	("Menu of Variables for Add Object",AddVariableMenuMenuLine,
	0);

extern MenuLine AddInstanceParamMenuMenuLine[];
static Menu AddInstanceParamMenu
	("Menu of Parameters for `Add' Object Instance",AddInstanceParamMenuMenuLine,
	0);

extern MenuLine AddInstanceVariableMenuMenuLine[];
static Menu AddInstanceVariableMenu
	("Menu of Variables for Add Object Instance",AddInstanceVariableMenuMenuLine,
	0);

extern MenuLine AddSetInstanceVariableMenuMenuLine[];
static Menu AddSetInstanceVariableMenu
	("Menu of Variables for Add Object Instance",AddSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine AsciiFileNodeOptMenuMenuLine[];
static Menu AsciiFileNodeOptMenu
	("Options for `AsciiFile'",AsciiFileNodeOptMenuMenuLine,
	0);

static DynamicMenu AsciiFileInstancesMenu
	("Select an Instance of `AsciiFile' to describe or delete", 0,
	1);

extern MenuLine AsciiFileInstanceAccessMenuMenuLine[];
static Menu AsciiFileInstanceAccessMenu
	("Describe or delete an instance of  object `AsciiFile'",AsciiFileInstanceAccessMenuMenuLine,
	0);

extern MenuLine AsciiFileParamMenuMenuLine[];
static Menu AsciiFileParamMenu
	("Menu of Parameters for `AsciiFile' Object",AsciiFileParamMenuMenuLine,
	0);

extern MenuLine AsciiFileVariableMenuMenuLine[];
static Menu AsciiFileVariableMenu
	("Menu of Variables for AsciiFile Object",AsciiFileVariableMenuMenuLine,
	0);

extern MenuLine AsciiFileInstanceParamMenuMenuLine[];
static Menu AsciiFileInstanceParamMenu
	("Menu of Parameters for `AsciiFile' Object Instance",AsciiFileInstanceParamMenuMenuLine,
	0);

extern MenuLine AsciiFileInstanceVariableMenuMenuLine[];
static Menu AsciiFileInstanceVariableMenu
	("Menu of Variables for AsciiFile Object Instance",AsciiFileInstanceVariableMenuMenuLine,
	0);

extern MenuLine AsciiFileSetInstanceVariableMenuMenuLine[];
static Menu AsciiFileSetInstanceVariableMenu
	("Menu of Variables for AsciiFile Object Instance",AsciiFileSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine BlockNodeOptMenuMenuLine[];
static Menu BlockNodeOptMenu
	("Options for `Block'",BlockNodeOptMenuMenuLine,
	0);

static DynamicMenu BlockInstancesMenu
	("Select an Instance of `Block' to describe or delete", 0,
	1);

extern MenuLine BlockInstanceAccessMenuMenuLine[];
static Menu BlockInstanceAccessMenu
	("Describe or delete an instance of  object `Block'",BlockInstanceAccessMenuMenuLine,
	0);

extern MenuLine BlockParamMenuMenuLine[];
static Menu BlockParamMenu
	("Menu of Parameters for `Block' Object",BlockParamMenuMenuLine,
	0);

extern MenuLine BlockInstanceParamMenuMenuLine[];
static Menu BlockInstanceParamMenu
	("Menu of Parameters for `Block' Object Instance",BlockInstanceParamMenuMenuLine,
	0);

extern MenuLine CircBufDesNodeOptMenuMenuLine[];
static Menu CircBufDesNodeOptMenu
	("Options for `CircBufDes'",CircBufDesNodeOptMenuMenuLine,
	0);

extern MenuLine SelectCircBufDesMemberDescribeMenuLine[];
static Menu SelectCircBufDesMemberDescribe
	("Select a member of `CircBufDes' to describe",SelectCircBufDesMemberDescribeMenuLine,
	0);

extern MenuLine AssignToEditCircBufDesNodeMemberMenuMenuLine[];
static Menu AssignToEditCircBufDesNodeMemberMenu
	("Describe member `AssignToEdit' of `CircBufDes'",AssignToEditCircBufDesNodeMemberMenuMenuLine,
	0);

static DynamicMenu CircBufDesInstancesMenu
	("Select an Instance of `CircBufDes'", 0,
	1);

extern MenuLine CircBufDesInstanceAccessMenuMenuLine[];
static Menu CircBufDesInstanceAccessMenu
	("Operations on an instance of  object `CircBufDes'",CircBufDesInstanceAccessMenuMenuLine,
	0);

extern MenuLine SelectCircBufDesMemberExecuteMenuLine[];
static Menu SelectCircBufDesMemberExecute
	("Select a member of this `CircBufDes' to execute",SelectCircBufDesMemberExecuteMenuLine,
	0);

extern MenuLine CircBufDesParamMenuMenuLine[];
static Menu CircBufDesParamMenu
	("Menu of Parameters for `CircBufDes' Object",CircBufDesParamMenuMenuLine,
	0);

extern MenuLine CircBufDesVariableMenuMenuLine[];
static Menu CircBufDesVariableMenu
	("Menu of Variables for CircBufDes Object",CircBufDesVariableMenuMenuLine,
	0);

extern MenuLine CircBufDesInstanceParamMenuMenuLine[];
static Menu CircBufDesInstanceParamMenu
	("Menu of Parameters for `CircBufDes' Object Instance",CircBufDesInstanceParamMenuMenuLine,
	0);

extern MenuLine CircBufDesInstanceVariableMenuMenuLine[];
static Menu CircBufDesInstanceVariableMenu
	("Menu of Variables for CircBufDes Object Instance",CircBufDesInstanceVariableMenuMenuLine,
	0);

extern MenuLine CircBufDesSetInstanceVariableMenuMenuLine[];
static Menu CircBufDesSetInstanceVariableMenu
	("Menu of Variables for CircBufDes Object Instance",CircBufDesSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine CompareDiskNodeOptMenuMenuLine[];
static Menu CompareDiskNodeOptMenu
	("Options for `CompareDisk'",CompareDiskNodeOptMenuMenuLine,
	0);

extern MenuLine SelectCompareDiskMemberDescribeMenuLine[];
static Menu SelectCompareDiskMemberDescribe
	("Select a member of `CompareDisk' to describe",SelectCompareDiskMemberDescribeMenuLine,
	0);

extern MenuLine DisplayHeaderCompareDiskNodeMemberMenuMenuLine[];
static Menu DisplayHeaderCompareDiskNodeMemberMenu
	("Describe member `DisplayHeader' of `CompareDisk'",DisplayHeaderCompareDiskNodeMemberMenuMenuLine,
	0);

extern MenuLine IgnoreHeaderCountCompareDiskNodeMemberMenuMenuLine[];
static Menu IgnoreHeaderCountCompareDiskNodeMemberMenu
	("Describe member `IgnoreHeaderCount' of `CompareDisk'",IgnoreHeaderCountCompareDiskNodeMemberMenuMenuLine,
	0);

static DynamicMenu CompareDiskInstancesMenu
	("Select an Instance of `CompareDisk'", 0,
	1);

extern MenuLine CompareDiskInstanceAccessMenuMenuLine[];
static Menu CompareDiskInstanceAccessMenu
	("Operations on an instance of  object `CompareDisk'",CompareDiskInstanceAccessMenuMenuLine,
	0);

extern MenuLine SelectCompareDiskMemberExecuteMenuLine[];
static Menu SelectCompareDiskMemberExecute
	("Select a member of this `CompareDisk' to execute",SelectCompareDiskMemberExecuteMenuLine,
	0);

extern MenuLine CompareDiskParamMenuMenuLine[];
static Menu CompareDiskParamMenu
	("Menu of Parameters for `CompareDisk' Object",CompareDiskParamMenuMenuLine,
	0);

extern MenuLine CompareDiskInstanceParamMenuMenuLine[];
static Menu CompareDiskInstanceParamMenu
	("Menu of Parameters for `CompareDisk' Object Instance",CompareDiskInstanceParamMenuMenuLine,
	0);

extern MenuLine ConstantDataNodeOptMenuMenuLine[];
static Menu ConstantDataNodeOptMenu
	("Options for `ConstantData'",ConstantDataNodeOptMenuMenuLine,
	0);

static DynamicMenu ConstantDataInstancesMenu
	("Select an Instance of `ConstantData' to describe or delete", 0,
	1);

extern MenuLine ConstantDataInstanceAccessMenuMenuLine[];
static Menu ConstantDataInstanceAccessMenu
	("Describe or delete an instance of  object `ConstantData'",ConstantDataInstanceAccessMenuMenuLine,
	0);

extern MenuLine ConstantDataParamMenuMenuLine[];
static Menu ConstantDataParamMenu
	("Menu of Parameters for `ConstantData' Object",ConstantDataParamMenuMenuLine,
	0);

extern MenuLine ConstantDataVariableMenuMenuLine[];
static Menu ConstantDataVariableMenu
	("Menu of Variables for ConstantData Object",ConstantDataVariableMenuMenuLine,
	0);

extern MenuLine ConstantDataInstanceParamMenuMenuLine[];
static Menu ConstantDataInstanceParamMenu
	("Menu of Parameters for `ConstantData' Object Instance",ConstantDataInstanceParamMenuMenuLine,
	0);

extern MenuLine ConstantDataInstanceVariableMenuMenuLine[];
static Menu ConstantDataInstanceVariableMenu
	("Menu of Variables for ConstantData Object Instance",ConstantDataInstanceVariableMenuMenuLine,
	0);

extern MenuLine ConstantDataSetInstanceVariableMenuMenuLine[];
static Menu ConstantDataSetInstanceVariableMenu
	("Menu of Variables for ConstantData Object Instance",ConstantDataSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine CosNodeOptMenuMenuLine[];
static Menu CosNodeOptMenu
	("Options for `Cos'",CosNodeOptMenuMenuLine,
	0);

static DynamicMenu CosInstancesMenu
	("Select an Instance of `Cos' to describe or delete", 0,
	1);

extern MenuLine CosInstanceAccessMenuMenuLine[];
static Menu CosInstanceAccessMenu
	("Describe or delete an instance of  object `Cos'",CosInstanceAccessMenuMenuLine,
	0);

extern MenuLine CosParamMenuMenuLine[];
static Menu CosParamMenu
	("Menu of Parameters for `Cos' Object",CosParamMenuMenuLine,
	0);

extern MenuLine CosVariableMenuMenuLine[];
static Menu CosVariableMenu
	("Menu of Variables for Cos Object",CosVariableMenuMenuLine,
	0);

extern MenuLine CosInstanceParamMenuMenuLine[];
static Menu CosInstanceParamMenu
	("Menu of Parameters for `Cos' Object Instance",CosInstanceParamMenuMenuLine,
	0);

extern MenuLine CosInstanceVariableMenuMenuLine[];
static Menu CosInstanceVariableMenu
	("Menu of Variables for Cos Object Instance",CosInstanceVariableMenuMenuLine,
	0);

extern MenuLine CosSetInstanceVariableMenuMenuLine[];
static Menu CosSetInstanceVariableMenu
	("Menu of Variables for Cos Object Instance",CosSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine CxCosNodeOptMenuMenuLine[];
static Menu CxCosNodeOptMenu
	("Options for `CxCos'",CxCosNodeOptMenuMenuLine,
	0);

static DynamicMenu CxCosInstancesMenu
	("Select an Instance of `CxCos' to describe or delete", 0,
	1);

extern MenuLine CxCosInstanceAccessMenuMenuLine[];
static Menu CxCosInstanceAccessMenu
	("Describe or delete an instance of  object `CxCos'",CxCosInstanceAccessMenuMenuLine,
	0);

extern MenuLine CxCosParamMenuMenuLine[];
static Menu CxCosParamMenu
	("Menu of Parameters for `CxCos' Object",CxCosParamMenuMenuLine,
	0);

extern MenuLine CxCosVariableMenuMenuLine[];
static Menu CxCosVariableMenu
	("Menu of Variables for CxCos Object",CxCosVariableMenuMenuLine,
	0);

extern MenuLine CxCosInstanceParamMenuMenuLine[];
static Menu CxCosInstanceParamMenu
	("Menu of Parameters for `CxCos' Object Instance",CxCosInstanceParamMenuMenuLine,
	0);

extern MenuLine CxCosInstanceVariableMenuMenuLine[];
static Menu CxCosInstanceVariableMenu
	("Menu of Variables for CxCos Object Instance",CxCosInstanceVariableMenuMenuLine,
	0);

extern MenuLine CxCosSetInstanceVariableMenuMenuLine[];
static Menu CxCosSetInstanceVariableMenu
	("Menu of Variables for CxCos Object Instance",CxCosSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine CxFFTNodeOptMenuMenuLine[];
static Menu CxFFTNodeOptMenu
	("Options for `CxFFT'",CxFFTNodeOptMenuMenuLine,
	0);

static DynamicMenu CxFFTInstancesMenu
	("Select an Instance of `CxFFT' to describe or delete", 0,
	1);

extern MenuLine CxFFTInstanceAccessMenuMenuLine[];
static Menu CxFFTInstanceAccessMenu
	("Describe or delete an instance of  object `CxFFT'",CxFFTInstanceAccessMenuMenuLine,
	0);

extern MenuLine CxFFTParamMenuMenuLine[];
static Menu CxFFTParamMenu
	("Menu of Parameters for `CxFFT' Object",CxFFTParamMenuMenuLine,
	0);

extern MenuLine CxFFTVariableMenuMenuLine[];
static Menu CxFFTVariableMenu
	("Menu of Variables for CxFFT Object",CxFFTVariableMenuMenuLine,
	0);

extern MenuLine CxFFTInstanceParamMenuMenuLine[];
static Menu CxFFTInstanceParamMenu
	("Menu of Parameters for `CxFFT' Object Instance",CxFFTInstanceParamMenuMenuLine,
	0);

extern MenuLine CxFFTInstanceVariableMenuMenuLine[];
static Menu CxFFTInstanceVariableMenu
	("Menu of Variables for CxFFT Object Instance",CxFFTInstanceVariableMenuMenuLine,
	0);

extern MenuLine CxFFTSetInstanceVariableMenuMenuLine[];
static Menu CxFFTSetInstanceVariableMenu
	("Menu of Variables for CxFFT Object Instance",CxFFTSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine CxFirNodeOptMenuMenuLine[];
static Menu CxFirNodeOptMenu
	("Options for `CxFir'",CxFirNodeOptMenuMenuLine,
	0);

static DynamicMenu CxFirInstancesMenu
	("Select an Instance of `CxFir' to describe or delete", 0,
	1);

extern MenuLine CxFirInstanceAccessMenuMenuLine[];
static Menu CxFirInstanceAccessMenu
	("Describe or delete an instance of  object `CxFir'",CxFirInstanceAccessMenuMenuLine,
	0);

extern MenuLine CxFirParamMenuMenuLine[];
static Menu CxFirParamMenu
	("Menu of Parameters for `CxFir' Object",CxFirParamMenuMenuLine,
	0);

extern MenuLine CxFirInstanceParamMenuMenuLine[];
static Menu CxFirInstanceParamMenu
	("Menu of Parameters for `CxFir' Object Instance",CxFirInstanceParamMenuMenuLine,
	0);

extern MenuLine CxImpNodeOptMenuMenuLine[];
static Menu CxImpNodeOptMenu
	("Options for `CxImp'",CxImpNodeOptMenuMenuLine,
	0);

static DynamicMenu CxImpInstancesMenu
	("Select an Instance of `CxImp' to describe or delete", 0,
	1);

extern MenuLine CxImpInstanceAccessMenuMenuLine[];
static Menu CxImpInstanceAccessMenu
	("Describe or delete an instance of  object `CxImp'",CxImpInstanceAccessMenuMenuLine,
	0);

extern MenuLine CxImpParamMenuMenuLine[];
static Menu CxImpParamMenu
	("Menu of Parameters for `CxImp' Object",CxImpParamMenuMenuLine,
	0);

extern MenuLine CxImpInstanceParamMenuMenuLine[];
static Menu CxImpInstanceParamMenu
	("Menu of Parameters for `CxImp' Object Instance",CxImpInstanceParamMenuMenuLine,
	0);

extern MenuLine DataFlowNodeOptMenuMenuLine[];
static Menu DataFlowNodeOptMenu
	("Options for `DataFlow'",DataFlowNodeOptMenuMenuLine,
	0);

extern MenuLine SelectDataFlowMemberDescribeMenuLine[];
static Menu SelectDataFlowMemberDescribe
	("Select a member of `DataFlow' to describe",SelectDataFlowMemberDescribeMenuLine,
	0);

extern MenuLine GraphDisplayDataFlowNodeMemberMenuMenuLine[];
static Menu GraphDisplayDataFlowNodeMemberMenu
	("Describe member `GraphDisplay' of `DataFlow'",GraphDisplayDataFlowNodeMemberMenuMenuLine,
	0);

extern MenuLine DataFlowGraphDisplayMemberParamMenuMenuLine[];
static Menu DataFlowGraphDisplayMemberParamMenu
	("Select parameter of `DataFlow' member `GraphDisplay' to describe",DataFlowGraphDisplayMemberParamMenuMenuLine,
	0);

extern MenuLine ExecuteDataFlowNodeMemberMenuMenuLine[];
static Menu ExecuteDataFlowNodeMemberMenu
	("Describe member `Execute' of `DataFlow'",ExecuteDataFlowNodeMemberMenuMenuLine,
	0);

extern MenuLine DataFlowExecuteMemberParamMenuMenuLine[];
static Menu DataFlowExecuteMemberParamMenu
	("Select parameter of `DataFlow' member `Execute' to describe",DataFlowExecuteMemberParamMenuMenuLine,
	0);

extern MenuLine AssignBuffersDataFlowNodeMemberMenuMenuLine[];
static Menu AssignBuffersDataFlowNodeMemberMenu
	("Describe member `AssignBuffers' of `DataFlow'",AssignBuffersDataFlowNodeMemberMenuMenuLine,
	0);

extern MenuLine DataFlowAssignBuffersMemberParamMenuMenuLine[];
static Menu DataFlowAssignBuffersMemberParamMenu
	("Select parameter of `DataFlow' member `AssignBuffers' to describe",DataFlowAssignBuffersMemberParamMenuMenuLine,
	0);

extern MenuLine ClearBuffersDataFlowNodeMemberMenuMenuLine[];
static Menu ClearBuffersDataFlowNodeMemberMenu
	("Describe member `ClearBuffers' of `DataFlow'",ClearBuffersDataFlowNodeMemberMenuMenuLine,
	0);

extern MenuLine ClearNetworkDataFlowNodeMemberMenuMenuLine[];
static Menu ClearNetworkDataFlowNodeMemberMenu
	("Describe member `ClearNetwork' of `DataFlow'",ClearNetworkDataFlowNodeMemberMenuMenuLine,
	0);

static DynamicMenu DataFlowInstancesMenu
	("Select an Instance of `DataFlow'", 0,
	1);

extern MenuLine DataFlowInstanceAccessMenuMenuLine[];
static Menu DataFlowInstanceAccessMenu
	("Operations on an instance of  object `DataFlow'",DataFlowInstanceAccessMenuMenuLine,
	0);

extern MenuLine SelectDataFlowMemberExecuteMenuLine[];
static Menu SelectDataFlowMemberExecute
	("Select a member of this `DataFlow' to execute",SelectDataFlowMemberExecuteMenuLine,
	0);

extern MenuLine DataFlowParamMenuMenuLine[];
static Menu DataFlowParamMenu
	("Menu of Parameters for `DataFlow' Object",DataFlowParamMenuMenuLine,
	0);

extern MenuLine DataFlowInstanceParamMenuMenuLine[];
static Menu DataFlowInstanceParamMenu
	("Menu of Parameters for `DataFlow' Object Instance",DataFlowInstanceParamMenuMenuLine,
	0);

extern MenuLine DemodNodeOptMenuMenuLine[];
static Menu DemodNodeOptMenu
	("Options for `Demod'",DemodNodeOptMenuMenuLine,
	0);

static DynamicMenu DemodInstancesMenu
	("Select an Instance of `Demod' to describe or delete", 0,
	1);

extern MenuLine DemodInstanceAccessMenuMenuLine[];
static Menu DemodInstanceAccessMenu
	("Describe or delete an instance of  object `Demod'",DemodInstanceAccessMenuMenuLine,
	0);

extern MenuLine DemodParamMenuMenuLine[];
static Menu DemodParamMenu
	("Menu of Parameters for `Demod' Object",DemodParamMenuMenuLine,
	0);

extern MenuLine DemodVariableMenuMenuLine[];
static Menu DemodVariableMenu
	("Menu of Variables for Demod Object",DemodVariableMenuMenuLine,
	0);

extern MenuLine DemodInstanceParamMenuMenuLine[];
static Menu DemodInstanceParamMenu
	("Menu of Parameters for `Demod' Object Instance",DemodInstanceParamMenuMenuLine,
	0);

extern MenuLine DemodInstanceVariableMenuMenuLine[];
static Menu DemodInstanceVariableMenu
	("Menu of Variables for Demod Object Instance",DemodInstanceVariableMenuMenuLine,
	0);

extern MenuLine DemodSetInstanceVariableMenuMenuLine[];
static Menu DemodSetInstanceVariableMenu
	("Menu of Variables for Demod Object Instance",DemodSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine DemuxNodeOptMenuMenuLine[];
static Menu DemuxNodeOptMenu
	("Options for `Demux'",DemuxNodeOptMenuMenuLine,
	0);

static DynamicMenu DemuxInstancesMenu
	("Select an Instance of `Demux' to describe or delete", 0,
	1);

extern MenuLine DemuxInstanceAccessMenuMenuLine[];
static Menu DemuxInstanceAccessMenu
	("Describe or delete an instance of  object `Demux'",DemuxInstanceAccessMenuMenuLine,
	0);

extern MenuLine DemuxParamMenuMenuLine[];
static Menu DemuxParamMenu
	("Menu of Parameters for `Demux' Object",DemuxParamMenuMenuLine,
	0);

extern MenuLine DemuxInstanceParamMenuMenuLine[];
static Menu DemuxInstanceParamMenu
	("Menu of Parameters for `Demux' Object Instance",DemuxInstanceParamMenuMenuLine,
	0);

extern MenuLine SelectDisplayNodeStrMemberDescribeMenuLine[];
static Menu SelectDisplayNodeStrMemberDescribe
	("Select a member of `DisplayNodeStr' to describe",SelectDisplayNodeStrMemberDescribeMenuLine,
	0);

extern MenuLine RaiseDisplayNodeStrNodeMemberMenuMenuLine[];
static Menu RaiseDisplayNodeStrNodeMemberMenu
	("Describe member `Raise' of `DisplayNodeStr'",RaiseDisplayNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine DisplayInputTimingDisplayNodeStrNodeMemberMenuMenuLine[];
static Menu DisplayInputTimingDisplayNodeStrNodeMemberMenu
	("Describe member `DisplayInputTiming' of `DisplayNodeStr'",DisplayInputTimingDisplayNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine DisplayNodeStrDisplayInputTimingMemberParamMenuMenuLine[];
static Menu DisplayNodeStrDisplayInputTimingMemberParamMenu
	("Select parameter of `DisplayNodeStr' member `DisplayInputTiming' to describe",DisplayNodeStrDisplayInputTimingMemberParamMenuMenuLine,
	0);

extern MenuLine EditDisplayNodeStrNodeMemberMenuMenuLine[];
static Menu EditDisplayNodeStrNodeMemberMenu
	("Describe member `Edit' of `DisplayNodeStr'",EditDisplayNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine UnlinkDisplayNodeStrNodeMemberMenuMenuLine[];
static Menu UnlinkDisplayNodeStrNodeMemberMenu
	("Describe member `Unlink' of `DisplayNodeStr'",UnlinkDisplayNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine LinkInDisplayNodeStrNodeMemberMenuMenuLine[];
static Menu LinkInDisplayNodeStrNodeMemberMenu
	("Describe member `LinkIn' of `DisplayNodeStr'",LinkInDisplayNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine DisplayNodeStrLinkInMemberParamMenuMenuLine[];
static Menu DisplayNodeStrLinkInMemberParamMenu
	("Select parameter of `DisplayNodeStr' member `LinkIn' to describe",DisplayNodeStrLinkInMemberParamMenuMenuLine,
	0);

extern MenuLine NextFreeInputDisplayNodeStrNodeMemberMenuMenuLine[];
static Menu NextFreeInputDisplayNodeStrNodeMemberMenu
	("Describe member `NextFreeInput' of `DisplayNodeStr'",NextFreeInputDisplayNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SelectDisplayNodeStrMemberExecuteMenuLine[];
static Menu SelectDisplayNodeStrMemberExecute
	("Select a member of this `DisplayNodeStr' to execute",SelectDisplayNodeStrMemberExecuteMenuLine,
	0);

extern MenuLine EyePlotNodeOptMenuMenuLine[];
static Menu EyePlotNodeOptMenu
	("Options for `EyePlot'",EyePlotNodeOptMenuMenuLine,
	0);

static DynamicMenu EyePlotInstancesMenu
	("Select an Instance of `EyePlot' to describe or delete", 0,
	1);

extern MenuLine EyePlotInstanceAccessMenuMenuLine[];
static Menu EyePlotInstanceAccessMenu
	("Describe or delete an instance of  object `EyePlot'",EyePlotInstanceAccessMenuMenuLine,
	0);

extern MenuLine EyePlotParamMenuMenuLine[];
static Menu EyePlotParamMenu
	("Menu of Parameters for `EyePlot' Object",EyePlotParamMenuMenuLine,
	0);

extern MenuLine EyePlotInstanceParamMenuMenuLine[];
static Menu EyePlotInstanceParamMenu
	("Menu of Parameters for `EyePlot' Object Instance",EyePlotInstanceParamMenuMenuLine,
	0);

extern MenuLine FindStartTailNodeOptMenuMenuLine[];
static Menu FindStartTailNodeOptMenu
	("Options for `FindStartTail'",FindStartTailNodeOptMenuMenuLine,
	0);

static DynamicMenu FindStartTailInstancesMenu
	("Select an Instance of `FindStartTail' to describe or delete", 0,
	1);

extern MenuLine FindStartTailInstanceAccessMenuMenuLine[];
static Menu FindStartTailInstanceAccessMenu
	("Describe or delete an instance of  object `FindStartTail'",FindStartTailInstanceAccessMenuMenuLine,
	0);

extern MenuLine FindStartTailParamMenuMenuLine[];
static Menu FindStartTailParamMenu
	("Menu of Parameters for `FindStartTail' Object",FindStartTailParamMenuMenuLine,
	0);

extern MenuLine FindStartTailInstanceParamMenuMenuLine[];
static Menu FindStartTailInstanceParamMenu
	("Menu of Parameters for `FindStartTail' Object Instance",FindStartTailInstanceParamMenuMenuLine,
	0);

extern MenuLine GainNodeOptMenuMenuLine[];
static Menu GainNodeOptMenu
	("Options for `Gain'",GainNodeOptMenuMenuLine,
	0);

static DynamicMenu GainInstancesMenu
	("Select an Instance of `Gain' to describe or delete", 0,
	1);

extern MenuLine GainInstanceAccessMenuMenuLine[];
static Menu GainInstanceAccessMenu
	("Describe or delete an instance of  object `Gain'",GainInstanceAccessMenuMenuLine,
	0);

extern MenuLine GainParamMenuMenuLine[];
static Menu GainParamMenu
	("Menu of Parameters for `Gain' Object",GainParamMenuMenuLine,
	0);

extern MenuLine GainVariableMenuMenuLine[];
static Menu GainVariableMenu
	("Menu of Variables for Gain Object",GainVariableMenuMenuLine,
	0);

extern MenuLine GainInstanceParamMenuMenuLine[];
static Menu GainInstanceParamMenu
	("Menu of Parameters for `Gain' Object Instance",GainInstanceParamMenuMenuLine,
	0);

extern MenuLine GainInstanceVariableMenuMenuLine[];
static Menu GainInstanceVariableMenu
	("Menu of Variables for Gain Object Instance",GainInstanceVariableMenuMenuLine,
	0);

extern MenuLine GainSetInstanceVariableMenuMenuLine[];
static Menu GainSetInstanceVariableMenu
	("Menu of Variables for Gain Object Instance",GainSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine GainPadNodeOptMenuMenuLine[];
static Menu GainPadNodeOptMenu
	("Options for `GainPad'",GainPadNodeOptMenuMenuLine,
	0);

static DynamicMenu GainPadInstancesMenu
	("Select an Instance of `GainPad' to describe or delete", 0,
	1);

extern MenuLine GainPadInstanceAccessMenuMenuLine[];
static Menu GainPadInstanceAccessMenu
	("Describe or delete an instance of  object `GainPad'",GainPadInstanceAccessMenuMenuLine,
	0);

extern MenuLine GainPadParamMenuMenuLine[];
static Menu GainPadParamMenu
	("Menu of Parameters for `GainPad' Object",GainPadParamMenuMenuLine,
	0);

extern MenuLine GainPadVariableMenuMenuLine[];
static Menu GainPadVariableMenu
	("Menu of Variables for GainPad Object",GainPadVariableMenuMenuLine,
	0);

extern MenuLine GainPadInstanceParamMenuMenuLine[];
static Menu GainPadInstanceParamMenu
	("Menu of Parameters for `GainPad' Object Instance",GainPadInstanceParamMenuMenuLine,
	0);

extern MenuLine GainPadInstanceVariableMenuMenuLine[];
static Menu GainPadInstanceVariableMenu
	("Menu of Variables for GainPad Object Instance",GainPadInstanceVariableMenuMenuLine,
	0);

extern MenuLine GainPadSetInstanceVariableMenuMenuLine[];
static Menu GainPadSetInstanceVariableMenu
	("Menu of Variables for GainPad Object Instance",GainPadSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine HexListNodeOptMenuMenuLine[];
static Menu HexListNodeOptMenu
	("Options for `HexList'",HexListNodeOptMenuMenuLine,
	0);

static DynamicMenu HexListInstancesMenu
	("Select an Instance of `HexList' to describe or delete", 0,
	1);

extern MenuLine HexListInstanceAccessMenuMenuLine[];
static Menu HexListInstanceAccessMenu
	("Describe or delete an instance of  object `HexList'",HexListInstanceAccessMenuMenuLine,
	0);

extern MenuLine HexListParamMenuMenuLine[];
static Menu HexListParamMenu
	("Menu of Parameters for `HexList' Object",HexListParamMenuMenuLine,
	0);

extern MenuLine HexListInstanceParamMenuMenuLine[];
static Menu HexListInstanceParamMenu
	("Menu of Parameters for `HexList' Object Instance",HexListInstanceParamMenuMenuLine,
	0);

extern MenuLine ImportDataNodeOptMenuMenuLine[];
static Menu ImportDataNodeOptMenu
	("Options for `ImportData'",ImportDataNodeOptMenuMenuLine,
	0);

static DynamicMenu ImportDataInstancesMenu
	("Select an Instance of `ImportData' to describe or delete", 0,
	1);

extern MenuLine ImportDataInstanceAccessMenuMenuLine[];
static Menu ImportDataInstanceAccessMenu
	("Describe or delete an instance of  object `ImportData'",ImportDataInstanceAccessMenuMenuLine,
	0);

extern MenuLine ImportDataParamMenuMenuLine[];
static Menu ImportDataParamMenu
	("Menu of Parameters for `ImportData' Object",ImportDataParamMenuMenuLine,
	0);

extern MenuLine ImportDataInstanceParamMenuMenuLine[];
static Menu ImportDataInstanceParamMenu
	("Menu of Parameters for `ImportData' Object Instance",ImportDataInstanceParamMenuMenuLine,
	0);

extern MenuLine InputNodeNodeOptMenuMenuLine[];
static Menu InputNodeNodeOptMenu
	("Options for `InputNode'",InputNodeNodeOptMenuMenuLine,
	0);

extern MenuLine SelectInputNodeMemberDescribeMenuLine[];
static Menu SelectInputNodeMemberDescribe
	("Select a member of `InputNode' to describe",SelectInputNodeMemberDescribeMenuLine,
	0);

extern MenuLine DisplayHeaderInputNodeNodeMemberMenuMenuLine[];
static Menu DisplayHeaderInputNodeNodeMemberMenu
	("Describe member `DisplayHeader' of `InputNode'",DisplayHeaderInputNodeNodeMemberMenuMenuLine,
	0);

extern MenuLine IgnoreHeaderCountInputNodeNodeMemberMenuMenuLine[];
static Menu IgnoreHeaderCountInputNodeNodeMemberMenu
	("Describe member `IgnoreHeaderCount' of `InputNode'",IgnoreHeaderCountInputNodeNodeMemberMenuMenuLine,
	0);

static DynamicMenu InputNodeInstancesMenu
	("Select an Instance of `InputNode'", 0,
	1);

extern MenuLine InputNodeInstanceAccessMenuMenuLine[];
static Menu InputNodeInstanceAccessMenu
	("Operations on an instance of  object `InputNode'",InputNodeInstanceAccessMenuMenuLine,
	0);

extern MenuLine SelectInputNodeMemberExecuteMenuLine[];
static Menu SelectInputNodeMemberExecute
	("Select a member of this `InputNode' to execute",SelectInputNodeMemberExecuteMenuLine,
	0);

extern MenuLine InputNodeParamMenuMenuLine[];
static Menu InputNodeParamMenu
	("Menu of Parameters for `InputNode' Object",InputNodeParamMenuMenuLine,
	0);

extern MenuLine InputNodeInstanceParamMenuMenuLine[];
static Menu InputNodeInstanceParamMenu
	("Menu of Parameters for `InputNode' Object Instance",InputNodeInstanceParamMenuMenuLine,
	0);

extern MenuLine InputWordNodeOptMenuMenuLine[];
static Menu InputWordNodeOptMenu
	("Options for `InputWord'",InputWordNodeOptMenuMenuLine,
	0);

static DynamicMenu InputWordInstancesMenu
	("Select an Instance of `InputWord' to describe or delete", 0,
	1);

extern MenuLine InputWordInstanceAccessMenuMenuLine[];
static Menu InputWordInstanceAccessMenu
	("Describe or delete an instance of  object `InputWord'",InputWordInstanceAccessMenuMenuLine,
	0);

extern MenuLine InputWordParamMenuMenuLine[];
static Menu InputWordParamMenu
	("Menu of Parameters for `InputWord' Object",InputWordParamMenuMenuLine,
	0);

extern MenuLine InputWordInstanceParamMenuMenuLine[];
static Menu InputWordInstanceParamMenu
	("Menu of Parameters for `InputWord' Object Instance",InputWordInstanceParamMenuMenuLine,
	0);

extern MenuLine IntegrateNodeOptMenuMenuLine[];
static Menu IntegrateNodeOptMenu
	("Options for `Integrate'",IntegrateNodeOptMenuMenuLine,
	0);

static DynamicMenu IntegrateInstancesMenu
	("Select an Instance of `Integrate' to describe or delete", 0,
	1);

extern MenuLine IntegrateInstanceAccessMenuMenuLine[];
static Menu IntegrateInstanceAccessMenu
	("Describe or delete an instance of  object `Integrate'",IntegrateInstanceAccessMenuMenuLine,
	0);

extern MenuLine IntegrateParamMenuMenuLine[];
static Menu IntegrateParamMenu
	("Menu of Parameters for `Integrate' Object",IntegrateParamMenuMenuLine,
	0);

extern MenuLine IntegrateVariableMenuMenuLine[];
static Menu IntegrateVariableMenu
	("Menu of Variables for Integrate Object",IntegrateVariableMenuMenuLine,
	0);

extern MenuLine IntegrateInstanceParamMenuMenuLine[];
static Menu IntegrateInstanceParamMenu
	("Menu of Parameters for `Integrate' Object Instance",IntegrateInstanceParamMenuMenuLine,
	0);

extern MenuLine IntegrateInstanceVariableMenuMenuLine[];
static Menu IntegrateInstanceVariableMenu
	("Menu of Variables for Integrate Object Instance",IntegrateInstanceVariableMenuMenuLine,
	0);

extern MenuLine IntegrateSetInstanceVariableMenuMenuLine[];
static Menu IntegrateSetInstanceVariableMenu
	("Menu of Variables for Integrate Object Instance",IntegrateSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine InterpolateNodeOptMenuMenuLine[];
static Menu InterpolateNodeOptMenu
	("Options for `Interpolate'",InterpolateNodeOptMenuMenuLine,
	0);

static DynamicMenu InterpolateInstancesMenu
	("Select an Instance of `Interpolate' to describe or delete", 0,
	1);

extern MenuLine InterpolateInstanceAccessMenuMenuLine[];
static Menu InterpolateInstanceAccessMenu
	("Describe or delete an instance of  object `Interpolate'",InterpolateInstanceAccessMenuMenuLine,
	0);

extern MenuLine InterpolateParamMenuMenuLine[];
static Menu InterpolateParamMenu
	("Menu of Parameters for `Interpolate' Object",InterpolateParamMenuMenuLine,
	0);

extern MenuLine InterpolateInstanceParamMenuMenuLine[];
static Menu InterpolateInstanceParamMenu
	("Menu of Parameters for `Interpolate' Object Instance",InterpolateInstanceParamMenuMenuLine,
	0);

extern MenuLine ListingNodeOptMenuMenuLine[];
static Menu ListingNodeOptMenu
	("Options for `Listing'",ListingNodeOptMenuMenuLine,
	0);

static DynamicMenu ListingInstancesMenu
	("Select an Instance of `Listing' to describe or delete", 0,
	1);

extern MenuLine ListingInstanceAccessMenuMenuLine[];
static Menu ListingInstanceAccessMenu
	("Describe or delete an instance of  object `Listing'",ListingInstanceAccessMenuMenuLine,
	0);

extern MenuLine ListingParamMenuMenuLine[];
static Menu ListingParamMenu
	("Menu of Parameters for `Listing' Object",ListingParamMenuMenuLine,
	0);

extern MenuLine ListingVariableMenuMenuLine[];
static Menu ListingVariableMenu
	("Menu of Variables for Listing Object",ListingVariableMenuMenuLine,
	0);

extern MenuLine ListingInstanceParamMenuMenuLine[];
static Menu ListingInstanceParamMenu
	("Menu of Parameters for `Listing' Object Instance",ListingInstanceParamMenuMenuLine,
	0);

extern MenuLine ListingInstanceVariableMenuMenuLine[];
static Menu ListingInstanceVariableMenu
	("Menu of Variables for Listing Object Instance",ListingInstanceVariableMenuMenuLine,
	0);

extern MenuLine ListingSetInstanceVariableMenuMenuLine[];
static Menu ListingSetInstanceVariableMenu
	("Menu of Variables for Listing Object Instance",ListingSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine MaskWordNodeOptMenuMenuLine[];
static Menu MaskWordNodeOptMenu
	("Options for `MaskWord'",MaskWordNodeOptMenuMenuLine,
	0);

static DynamicMenu MaskWordInstancesMenu
	("Select an Instance of `MaskWord' to describe or delete", 0,
	1);

extern MenuLine MaskWordInstanceAccessMenuMenuLine[];
static Menu MaskWordInstanceAccessMenu
	("Describe or delete an instance of  object `MaskWord'",MaskWordInstanceAccessMenuMenuLine,
	0);

extern MenuLine MaskWordParamMenuMenuLine[];
static Menu MaskWordParamMenu
	("Menu of Parameters for `MaskWord' Object",MaskWordParamMenuMenuLine,
	0);

extern MenuLine MaskWordInstanceParamMenuMenuLine[];
static Menu MaskWordInstanceParamMenu
	("Menu of Parameters for `MaskWord' Object Instance",MaskWordInstanceParamMenuMenuLine,
	0);

extern MenuLine MuxNodeOptMenuMenuLine[];
static Menu MuxNodeOptMenu
	("Options for `Mux'",MuxNodeOptMenuMenuLine,
	0);

static DynamicMenu MuxInstancesMenu
	("Select an Instance of `Mux' to describe or delete", 0,
	1);

extern MenuLine MuxInstanceAccessMenuMenuLine[];
static Menu MuxInstanceAccessMenu
	("Describe or delete an instance of  object `Mux'",MuxInstanceAccessMenuMenuLine,
	0);

extern MenuLine MuxParamMenuMenuLine[];
static Menu MuxParamMenu
	("Menu of Parameters for `Mux' Object",MuxParamMenuMenuLine,
	0);

extern MenuLine MuxInstanceParamMenuMenuLine[];
static Menu MuxInstanceParamMenu
	("Menu of Parameters for `Mux' Object Instance",MuxInstanceParamMenuMenuLine,
	0);

extern MenuLine NetworkNodeOptMenuMenuLine[];
static Menu NetworkNodeOptMenu
	("Options for `Network'",NetworkNodeOptMenuMenuLine,
	0);

extern MenuLine SelectNetworkMemberDescribeMenuLine[];
static Menu SelectNetworkMemberDescribe
	("Select a member of `Network' to describe",SelectNetworkMemberDescribeMenuLine,
	0);

extern MenuLine GraphDisplayNetworkNodeMemberMenuMenuLine[];
static Menu GraphDisplayNetworkNodeMemberMenu
	("Describe member `GraphDisplay' of `Network'",GraphDisplayNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine ExecuteNetworkNodeMemberMenuMenuLine[];
static Menu ExecuteNetworkNodeMemberMenu
	("Describe member `Execute' of `Network'",ExecuteNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkExecuteMemberParamMenuMenuLine[];
static Menu NetworkExecuteMemberParamMenu
	("Select parameter of `Network' member `Execute' to describe",NetworkExecuteMemberParamMenuMenuLine,
	0);

extern MenuLine RaiseNetworkNodeMemberMenuMenuLine[];
static Menu RaiseNetworkNodeMemberMenu
	("Describe member `Raise' of `Network'",RaiseNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine ReplaceNodeNetworkNodeMemberMenuMenuLine[];
static Menu ReplaceNodeNetworkNodeMemberMenu
	("Describe member `ReplaceNode' of `Network'",ReplaceNodeNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkReplaceNodeMemberParamMenuMenuLine[];
static Menu NetworkReplaceNodeMemberParamMenu
	("Select parameter of `Network' member `ReplaceNode' to describe",NetworkReplaceNodeMemberParamMenuMenuLine,
	0);

extern MenuLine MakeTargetNetworkNodeMemberMenuMenuLine[];
static Menu MakeTargetNetworkNodeMemberMenu
	("Describe member `MakeTarget' of `Network'",MakeTargetNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkMakeTargetMemberParamMenuMenuLine[];
static Menu NetworkMakeTargetMemberParamMenu
	("Select parameter of `Network' member `MakeTarget' to describe",NetworkMakeTargetMemberParamMenuMenuLine,
	0);

extern MenuLine MakeValidateNetworkNodeMemberMenuMenuLine[];
static Menu MakeValidateNetworkNodeMemberMenu
	("Describe member `MakeValidate' of `Network'",MakeValidateNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkMakeValidateMemberParamMenuMenuLine[];
static Menu NetworkMakeValidateMemberParamMenu
	("Select parameter of `Network' member `MakeValidate' to describe",NetworkMakeValidateMemberParamMenuMenuLine,
	0);

extern MenuLine TargetValidateNetworkNodeMemberMenuMenuLine[];
static Menu TargetValidateNetworkNodeMemberMenu
	("Describe member `TargetValidate' of `Network'",TargetValidateNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkTargetValidateMemberParamMenuMenuLine[];
static Menu NetworkTargetValidateMemberParamMenu
	("Select parameter of `Network' member `TargetValidate' to describe",NetworkTargetValidateMemberParamMenuMenuLine,
	0);

extern MenuLine SetTimingExactNetworkNodeMemberMenuMenuLine[];
static Menu SetTimingExactNetworkNodeMemberMenu
	("Describe member `SetTimingExact' of `Network'",SetTimingExactNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkSetTimingExactMemberParamMenuMenuLine[];
static Menu NetworkSetTimingExactMemberParamMenu
	("Select parameter of `Network' member `SetTimingExact' to describe",NetworkSetTimingExactMemberParamMenuMenuLine,
	0);

extern MenuLine ReplaceWithOutputNetworkNodeMemberMenuMenuLine[];
static Menu ReplaceWithOutputNetworkNodeMemberMenu
	("Describe member `ReplaceWithOutput' of `Network'",ReplaceWithOutputNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine ReplaceWithCompareNetworkNodeMemberMenuMenuLine[];
static Menu ReplaceWithCompareNetworkNodeMemberMenu
	("Describe member `ReplaceWithCompare' of `Network'",ReplaceWithCompareNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkReplaceWithCompareMemberParamMenuMenuLine[];
static Menu NetworkReplaceWithCompareMemberParamMenu
	("Select parameter of `Network' member `ReplaceWithCompare' to describe",NetworkReplaceWithCompareMemberParamMenuMenuLine,
	0);

extern MenuLine Add_OpNetworkNodeMemberMenuMenuLine[];
static Menu Add_OpNetworkNodeMemberMenu
	("Describe member `operator+' of `Network'",Add_OpNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkAdd_OpMemberParamMenuMenuLine[];
static Menu NetworkAdd_OpMemberParamMenu
	("Select parameter of `Network' member `operator+' to describe",NetworkAdd_OpMemberParamMenuMenuLine,
	0);

extern MenuLine RightShift_OpNetworkNodeMemberMenuMenuLine[];
static Menu RightShift_OpNetworkNodeMemberMenu
	("Describe member `operator>>' of `Network'",RightShift_OpNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkRightShift_OpMemberParamMenuMenuLine[];
static Menu NetworkRightShift_OpMemberParamMenu
	("Select parameter of `Network' member `operator>>' to describe",NetworkRightShift_OpMemberParamMenuMenuLine,
	0);

extern MenuLine GraphDisplayWindowNetworkNodeMemberMenuMenuLine[];
static Menu GraphDisplayWindowNetworkNodeMemberMenu
	("Describe member `GraphDisplayWindow' of `Network'",GraphDisplayWindowNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkGraphDisplayWindowMemberParamMenuMenuLine[];
static Menu NetworkGraphDisplayWindowMemberParamMenu
	("Select parameter of `Network' member `GraphDisplayWindow' to describe",NetworkGraphDisplayWindowMemberParamMenuMenuLine,
	0);

extern MenuLine DisplayNamesNetworkNodeMemberMenuMenuLine[];
static Menu DisplayNamesNetworkNodeMemberMenu
	("Describe member `DisplayNames' of `Network'",DisplayNamesNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine SetBufferDescriptorNetworkNodeMemberMenuMenuLine[];
static Menu SetBufferDescriptorNetworkNodeMemberMenu
	("Describe member `SetBufferDescriptor' of `Network'",SetBufferDescriptorNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkSetBufferDescriptorMemberParamMenuMenuLine[];
static Menu NetworkSetBufferDescriptorMemberParamMenu
	("Select parameter of `Network' member `SetBufferDescriptor' to describe",NetworkSetBufferDescriptorMemberParamMenuMenuLine,
	0);

extern MenuLine AssociateNodeNetworkNodeMemberMenuMenuLine[];
static Menu AssociateNodeNetworkNodeMemberMenu
	("Describe member `AssociateNode' of `Network'",AssociateNodeNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkAssociateNodeMemberParamMenuMenuLine[];
static Menu NetworkAssociateNodeMemberParamMenu
	("Select parameter of `Network' member `AssociateNode' to describe",NetworkAssociateNodeMemberParamMenuMenuLine,
	0);

extern MenuLine LinkNetworkNodeMemberMenuMenuLine[];
static Menu LinkNetworkNodeMemberMenu
	("Describe member `Link' of `Network'",LinkNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkLinkMemberParamMenuMenuLine[];
static Menu NetworkLinkMemberParamMenu
	("Select parameter of `Network' member `Link' to describe",NetworkLinkMemberParamMenuMenuLine,
	0);

extern MenuLine SelfLinkNetworkNodeMemberMenuMenuLine[];
static Menu SelfLinkNetworkNodeMemberMenu
	("Describe member `SelfLink' of `Network'",SelfLinkNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkSelfLinkMemberParamMenuMenuLine[];
static Menu NetworkSelfLinkMemberParamMenu
	("Select parameter of `Network' member `SelfLink' to describe",NetworkSelfLinkMemberParamMenuMenuLine,
	0);

extern MenuLine AssignBuffersNetworkNodeMemberMenuMenuLine[];
static Menu AssignBuffersNetworkNodeMemberMenu
	("Describe member `AssignBuffers' of `Network'",AssignBuffersNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine NetworkAssignBuffersMemberParamMenuMenuLine[];
static Menu NetworkAssignBuffersMemberParamMenu
	("Select parameter of `Network' member `AssignBuffers' to describe",NetworkAssignBuffersMemberParamMenuMenuLine,
	0);

extern MenuLine GetBufferDescriptorNetworkNodeMemberMenuMenuLine[];
static Menu GetBufferDescriptorNetworkNodeMemberMenu
	("Describe member `GetBufferDescriptor' of `Network'",GetBufferDescriptorNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine ClearBuffersNetworkNodeMemberMenuMenuLine[];
static Menu ClearBuffersNetworkNodeMemberMenu
	("Describe member `ClearBuffers' of `Network'",ClearBuffersNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine GetNetControllerNetworkNodeMemberMenuMenuLine[];
static Menu GetNetControllerNetworkNodeMemberMenu
	("Describe member `GetNetController' of `Network'",GetNetControllerNetworkNodeMemberMenuMenuLine,
	0);

extern MenuLine ClearNetworkNetworkNodeMemberMenuMenuLine[];
static Menu ClearNetworkNetworkNodeMemberMenu
	("Describe member `ClearNetwork' of `Network'",ClearNetworkNetworkNodeMemberMenuMenuLine,
	0);

static DynamicMenu NetworkInstancesMenu
	("Select an Instance of `Network'", 0,
	1);

extern MenuLine NetworkInstanceAccessMenuMenuLine[];
static Menu NetworkInstanceAccessMenu
	("Operations on an instance of  object `Network'",NetworkInstanceAccessMenuMenuLine,
	0);

extern MenuLine SelectNetworkMemberExecuteMenuLine[];
static Menu SelectNetworkMemberExecute
	("Select a member of this `Network' to execute",SelectNetworkMemberExecuteMenuLine,
	0);

extern MenuLine NormalNodeOptMenuMenuLine[];
static Menu NormalNodeOptMenu
	("Options for `Normal'",NormalNodeOptMenuMenuLine,
	0);

static DynamicMenu NormalInstancesMenu
	("Select an Instance of `Normal' to describe or delete", 0,
	1);

extern MenuLine NormalInstanceAccessMenuMenuLine[];
static Menu NormalInstanceAccessMenu
	("Describe or delete an instance of  object `Normal'",NormalInstanceAccessMenuMenuLine,
	0);

extern MenuLine NormalParamMenuMenuLine[];
static Menu NormalParamMenu
	("Menu of Parameters for `Normal' Object",NormalParamMenuMenuLine,
	0);

extern MenuLine NormalVariableMenuMenuLine[];
static Menu NormalVariableMenu
	("Menu of Variables for Normal Object",NormalVariableMenuMenuLine,
	0);

extern MenuLine NormalInstanceParamMenuMenuLine[];
static Menu NormalInstanceParamMenu
	("Menu of Parameters for `Normal' Object Instance",NormalInstanceParamMenuMenuLine,
	0);

extern MenuLine NormalInstanceVariableMenuMenuLine[];
static Menu NormalInstanceVariableMenu
	("Menu of Variables for Normal Object Instance",NormalInstanceVariableMenuMenuLine,
	0);

extern MenuLine NormalSetInstanceVariableMenuMenuLine[];
static Menu NormalSetInstanceVariableMenu
	("Menu of Variables for Normal Object Instance",NormalSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine OutputNodeNodeOptMenuMenuLine[];
static Menu OutputNodeNodeOptMenu
	("Options for `OutputNode'",OutputNodeNodeOptMenuMenuLine,
	0);

static DynamicMenu OutputNodeInstancesMenu
	("Select an Instance of `OutputNode' to describe or delete", 0,
	1);

extern MenuLine OutputNodeInstanceAccessMenuMenuLine[];
static Menu OutputNodeInstanceAccessMenu
	("Describe or delete an instance of  object `OutputNode'",OutputNodeInstanceAccessMenuMenuLine,
	0);

extern MenuLine OutputNodeParamMenuMenuLine[];
static Menu OutputNodeParamMenu
	("Menu of Parameters for `OutputNode' Object",OutputNodeParamMenuMenuLine,
	0);

extern MenuLine OutputNodeInstanceParamMenuMenuLine[];
static Menu OutputNodeInstanceParamMenu
	("Menu of Parameters for `OutputNode' Object Instance",OutputNodeInstanceParamMenuMenuLine,
	0);

extern MenuLine OutputWordNodeOptMenuMenuLine[];
static Menu OutputWordNodeOptMenu
	("Options for `OutputWord'",OutputWordNodeOptMenuMenuLine,
	0);

static DynamicMenu OutputWordInstancesMenu
	("Select an Instance of `OutputWord' to describe or delete", 0,
	1);

extern MenuLine OutputWordInstanceAccessMenuMenuLine[];
static Menu OutputWordInstanceAccessMenu
	("Describe or delete an instance of  object `OutputWord'",OutputWordInstanceAccessMenuMenuLine,
	0);

extern MenuLine OutputWordParamMenuMenuLine[];
static Menu OutputWordParamMenu
	("Menu of Parameters for `OutputWord' Object",OutputWordParamMenuMenuLine,
	0);

extern MenuLine OutputWordInstanceParamMenuMenuLine[];
static Menu OutputWordInstanceParamMenu
	("Menu of Parameters for `OutputWord' Object Instance",OutputWordInstanceParamMenuMenuLine,
	0);

extern MenuLine PackWordNodeOptMenuMenuLine[];
static Menu PackWordNodeOptMenu
	("Options for `PackWord'",PackWordNodeOptMenuMenuLine,
	0);

static DynamicMenu PackWordInstancesMenu
	("Select an Instance of `PackWord' to describe or delete", 0,
	1);

extern MenuLine PackWordInstanceAccessMenuMenuLine[];
static Menu PackWordInstanceAccessMenu
	("Describe or delete an instance of  object `PackWord'",PackWordInstanceAccessMenuMenuLine,
	0);

extern MenuLine PackWordParamMenuMenuLine[];
static Menu PackWordParamMenu
	("Menu of Parameters for `PackWord' Object",PackWordParamMenuMenuLine,
	0);

extern MenuLine PackWordInstanceParamMenuMenuLine[];
static Menu PackWordInstanceParamMenu
	("Menu of Parameters for `PackWord' Object Instance",PackWordInstanceParamMenuMenuLine,
	0);

extern MenuLine PlotNodeOptMenuMenuLine[];
static Menu PlotNodeOptMenu
	("Options for `Plot'",PlotNodeOptMenuMenuLine,
	0);

static DynamicMenu PlotInstancesMenu
	("Select an Instance of `Plot' to describe or delete", 0,
	1);

extern MenuLine PlotInstanceAccessMenuMenuLine[];
static Menu PlotInstanceAccessMenu
	("Describe or delete an instance of  object `Plot'",PlotInstanceAccessMenuMenuLine,
	0);

extern MenuLine PlotParamMenuMenuLine[];
static Menu PlotParamMenu
	("Menu of Parameters for `Plot' Object",PlotParamMenuMenuLine,
	0);

extern MenuLine PlotInstanceParamMenuMenuLine[];
static Menu PlotInstanceParamMenu
	("Menu of Parameters for `Plot' Object Instance",PlotInstanceParamMenuMenuLine,
	0);

extern MenuLine PowerNodeOptMenuMenuLine[];
static Menu PowerNodeOptMenu
	("Options for `Power'",PowerNodeOptMenuMenuLine,
	0);

static DynamicMenu PowerInstancesMenu
	("Select an Instance of `Power' to describe or delete", 0,
	1);

extern MenuLine PowerInstanceAccessMenuMenuLine[];
static Menu PowerInstanceAccessMenu
	("Describe or delete an instance of  object `Power'",PowerInstanceAccessMenuMenuLine,
	0);

extern MenuLine PowerParamMenuMenuLine[];
static Menu PowerParamMenu
	("Menu of Parameters for `Power' Object",PowerParamMenuMenuLine,
	0);

extern MenuLine PowerVariableMenuMenuLine[];
static Menu PowerVariableMenu
	("Menu of Variables for Power Object",PowerVariableMenuMenuLine,
	0);

extern MenuLine PowerInstanceParamMenuMenuLine[];
static Menu PowerInstanceParamMenu
	("Menu of Parameters for `Power' Object Instance",PowerInstanceParamMenuMenuLine,
	0);

extern MenuLine PowerInstanceVariableMenuMenuLine[];
static Menu PowerInstanceVariableMenu
	("Menu of Variables for Power Object Instance",PowerInstanceVariableMenuMenuLine,
	0);

extern MenuLine PowerSetInstanceVariableMenuMenuLine[];
static Menu PowerSetInstanceVariableMenu
	("Menu of Variables for Power Object Instance",PowerSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine SelectProcessNodeStrMemberDescribeMenuLine[];
static Menu SelectProcessNodeStrMemberDescribe
	("Select a member of `ProcessNodeStr' to describe",SelectProcessNodeStrMemberDescribeMenuLine,
	0);

extern MenuLine RaiseProcessNodeStrNodeMemberMenuMenuLine[];
static Menu RaiseProcessNodeStrNodeMemberMenu
	("Describe member `Raise' of `ProcessNodeStr'",RaiseProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SetSampleRateProcessNodeStrNodeMemberMenuMenuLine[];
static Menu SetSampleRateProcessNodeStrNodeMemberMenu
	("Describe member `SetSampleRate' of `ProcessNodeStr'",SetSampleRateProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine ProcessNodeStrSetSampleRateMemberParamMenuMenuLine[];
static Menu ProcessNodeStrSetSampleRateMemberParamMenu
	("Select parameter of `ProcessNodeStr' member `SetSampleRate' to describe",ProcessNodeStrSetSampleRateMemberParamMenuMenuLine,
	0);

extern MenuLine DisplayInputTimingProcessNodeStrNodeMemberMenuMenuLine[];
static Menu DisplayInputTimingProcessNodeStrNodeMemberMenu
	("Describe member `DisplayInputTiming' of `ProcessNodeStr'",DisplayInputTimingProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine ProcessNodeStrDisplayInputTimingMemberParamMenuMenuLine[];
static Menu ProcessNodeStrDisplayInputTimingMemberParamMenu
	("Select parameter of `ProcessNodeStr' member `DisplayInputTiming' to describe",ProcessNodeStrDisplayInputTimingMemberParamMenuMenuLine,
	0);

extern MenuLine DisplayOutputTimingProcessNodeStrNodeMemberMenuMenuLine[];
static Menu DisplayOutputTimingProcessNodeStrNodeMemberMenu
	("Describe member `DisplayOutputTiming' of `ProcessNodeStr'",DisplayOutputTimingProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine ProcessNodeStrDisplayOutputTimingMemberParamMenuMenuLine[];
static Menu ProcessNodeStrDisplayOutputTimingMemberParamMenu
	("Select parameter of `ProcessNodeStr' member `DisplayOutputTiming' to describe",ProcessNodeStrDisplayOutputTimingMemberParamMenuMenuLine,
	0);

extern MenuLine EditProcessNodeStrNodeMemberMenuMenuLine[];
static Menu EditProcessNodeStrNodeMemberMenu
	("Describe member `Edit' of `ProcessNodeStr'",EditProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine UnlinkProcessNodeStrNodeMemberMenuMenuLine[];
static Menu UnlinkProcessNodeStrNodeMemberMenu
	("Describe member `Unlink' of `ProcessNodeStr'",UnlinkProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine LinkInProcessNodeStrNodeMemberMenuMenuLine[];
static Menu LinkInProcessNodeStrNodeMemberMenu
	("Describe member `LinkIn' of `ProcessNodeStr'",LinkInProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine ProcessNodeStrLinkInMemberParamMenuMenuLine[];
static Menu ProcessNodeStrLinkInMemberParamMenu
	("Select parameter of `ProcessNodeStr' member `LinkIn' to describe",ProcessNodeStrLinkInMemberParamMenuMenuLine,
	0);

extern MenuLine NextFreeInputProcessNodeStrNodeMemberMenuMenuLine[];
static Menu NextFreeInputProcessNodeStrNodeMemberMenu
	("Describe member `NextFreeInput' of `ProcessNodeStr'",NextFreeInputProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine NextFreeOutputProcessNodeStrNodeMemberMenuMenuLine[];
static Menu NextFreeOutputProcessNodeStrNodeMemberMenu
	("Describe member `NextFreeOutput' of `ProcessNodeStr'",NextFreeOutputProcessNodeStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SelectProcessNodeStrMemberExecuteMenuLine[];
static Menu SelectProcessNodeStrMemberExecute
	("Select a member of this `ProcessNodeStr' to execute",SelectProcessNodeStrMemberExecuteMenuLine,
	0);

extern MenuLine RampNodeOptMenuMenuLine[];
static Menu RampNodeOptMenu
	("Options for `Ramp'",RampNodeOptMenuMenuLine,
	0);

static DynamicMenu RampInstancesMenu
	("Select an Instance of `Ramp' to describe or delete", 0,
	1);

extern MenuLine RampInstanceAccessMenuMenuLine[];
static Menu RampInstanceAccessMenu
	("Describe or delete an instance of  object `Ramp'",RampInstanceAccessMenuMenuLine,
	0);

extern MenuLine RampParamMenuMenuLine[];
static Menu RampParamMenu
	("Menu of Parameters for `Ramp' Object",RampParamMenuMenuLine,
	0);

extern MenuLine RampVariableMenuMenuLine[];
static Menu RampVariableMenu
	("Menu of Variables for Ramp Object",RampVariableMenuMenuLine,
	0);

extern MenuLine RampInstanceParamMenuMenuLine[];
static Menu RampInstanceParamMenu
	("Menu of Parameters for `Ramp' Object Instance",RampInstanceParamMenuMenuLine,
	0);

extern MenuLine RampInstanceVariableMenuMenuLine[];
static Menu RampInstanceVariableMenu
	("Menu of Variables for Ramp Object Instance",RampInstanceVariableMenuMenuLine,
	0);

extern MenuLine RampSetInstanceVariableMenuMenuLine[];
static Menu RampSetInstanceVariableMenu
	("Menu of Variables for Ramp Object Instance",RampSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine ReadFloatNodeOptMenuMenuLine[];
static Menu ReadFloatNodeOptMenu
	("Options for `ReadFloat'",ReadFloatNodeOptMenuMenuLine,
	0);

static DynamicMenu ReadFloatInstancesMenu
	("Select an Instance of `ReadFloat' to describe or delete", 0,
	1);

extern MenuLine ReadFloatInstanceAccessMenuMenuLine[];
static Menu ReadFloatInstanceAccessMenu
	("Describe or delete an instance of  object `ReadFloat'",ReadFloatInstanceAccessMenuMenuLine,
	0);

extern MenuLine ReadFloatParamMenuMenuLine[];
static Menu ReadFloatParamMenu
	("Menu of Parameters for `ReadFloat' Object",ReadFloatParamMenuMenuLine,
	0);

extern MenuLine ReadFloatInstanceParamMenuMenuLine[];
static Menu ReadFloatInstanceParamMenu
	("Menu of Parameters for `ReadFloat' Object Instance",ReadFloatInstanceParamMenuMenuLine,
	0);

extern MenuLine ReadIntNodeOptMenuMenuLine[];
static Menu ReadIntNodeOptMenu
	("Options for `ReadInt'",ReadIntNodeOptMenuMenuLine,
	0);

static DynamicMenu ReadIntInstancesMenu
	("Select an Instance of `ReadInt' to describe or delete", 0,
	1);

extern MenuLine ReadIntInstanceAccessMenuMenuLine[];
static Menu ReadIntInstanceAccessMenu
	("Describe or delete an instance of  object `ReadInt'",ReadIntInstanceAccessMenuMenuLine,
	0);

extern MenuLine ReadIntParamMenuMenuLine[];
static Menu ReadIntParamMenu
	("Menu of Parameters for `ReadInt' Object",ReadIntParamMenuMenuLine,
	0);

extern MenuLine ReadIntInstanceParamMenuMenuLine[];
static Menu ReadIntInstanceParamMenu
	("Menu of Parameters for `ReadInt' Object Instance",ReadIntInstanceParamMenuMenuLine,
	0);

extern MenuLine RealFirNodeOptMenuMenuLine[];
static Menu RealFirNodeOptMenu
	("Options for `RealFir'",RealFirNodeOptMenuMenuLine,
	0);

static DynamicMenu RealFirInstancesMenu
	("Select an Instance of `RealFir' to describe or delete", 0,
	1);

extern MenuLine RealFirInstanceAccessMenuMenuLine[];
static Menu RealFirInstanceAccessMenu
	("Describe or delete an instance of  object `RealFir'",RealFirInstanceAccessMenuMenuLine,
	0);

extern MenuLine RealFirParamMenuMenuLine[];
static Menu RealFirParamMenu
	("Menu of Parameters for `RealFir' Object",RealFirParamMenuMenuLine,
	0);

extern MenuLine RealFirInstanceParamMenuMenuLine[];
static Menu RealFirInstanceParamMenu
	("Menu of Parameters for `RealFir' Object Instance",RealFirInstanceParamMenuMenuLine,
	0);

extern MenuLine RepackStreamNodeOptMenuMenuLine[];
static Menu RepackStreamNodeOptMenu
	("Options for `RepackStream'",RepackStreamNodeOptMenuMenuLine,
	0);

static DynamicMenu RepackStreamInstancesMenu
	("Select an Instance of `RepackStream' to describe or delete", 0,
	1);

extern MenuLine RepackStreamInstanceAccessMenuMenuLine[];
static Menu RepackStreamInstanceAccessMenu
	("Describe or delete an instance of  object `RepackStream'",RepackStreamInstanceAccessMenuMenuLine,
	0);

extern MenuLine RepackStreamParamMenuMenuLine[];
static Menu RepackStreamParamMenu
	("Menu of Parameters for `RepackStream' Object",RepackStreamParamMenuMenuLine,
	0);

extern MenuLine RepackStreamInstanceParamMenuMenuLine[];
static Menu RepackStreamInstanceParamMenu
	("Menu of Parameters for `RepackStream' Object Instance",RepackStreamInstanceParamMenuMenuLine,
	0);

extern MenuLine SampleDelayNodeOptMenuMenuLine[];
static Menu SampleDelayNodeOptMenu
	("Options for `SampleDelay'",SampleDelayNodeOptMenuMenuLine,
	0);

static DynamicMenu SampleDelayInstancesMenu
	("Select an Instance of `SampleDelay' to describe or delete", 0,
	1);

extern MenuLine SampleDelayInstanceAccessMenuMenuLine[];
static Menu SampleDelayInstanceAccessMenu
	("Describe or delete an instance of  object `SampleDelay'",SampleDelayInstanceAccessMenuMenuLine,
	0);

extern MenuLine SampleDelayParamMenuMenuLine[];
static Menu SampleDelayParamMenu
	("Menu of Parameters for `SampleDelay' Object",SampleDelayParamMenuMenuLine,
	0);

extern MenuLine SampleDelayInstanceParamMenuMenuLine[];
static Menu SampleDelayInstanceParamMenu
	("Menu of Parameters for `SampleDelay' Object Instance",SampleDelayInstanceParamMenuMenuLine,
	0);

extern MenuLine SelectSignalStrMemberDescribeMenuLine[];
static Menu SelectSignalStrMemberDescribe
	("Select a member of `SignalStr' to describe",SelectSignalStrMemberDescribeMenuLine,
	0);

extern MenuLine RaiseSignalStrNodeMemberMenuMenuLine[];
static Menu RaiseSignalStrNodeMemberMenu
	("Describe member `Raise' of `SignalStr'",RaiseSignalStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SetSampleRateSignalStrNodeMemberMenuMenuLine[];
static Menu SetSampleRateSignalStrNodeMemberMenu
	("Describe member `SetSampleRate' of `SignalStr'",SetSampleRateSignalStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SignalStrSetSampleRateMemberParamMenuMenuLine[];
static Menu SignalStrSetSampleRateMemberParamMenu
	("Select parameter of `SignalStr' member `SetSampleRate' to describe",SignalStrSetSampleRateMemberParamMenuMenuLine,
	0);

extern MenuLine DisplayOutputTimingSignalStrNodeMemberMenuMenuLine[];
static Menu DisplayOutputTimingSignalStrNodeMemberMenu
	("Describe member `DisplayOutputTiming' of `SignalStr'",DisplayOutputTimingSignalStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SignalStrDisplayOutputTimingMemberParamMenuMenuLine[];
static Menu SignalStrDisplayOutputTimingMemberParamMenu
	("Select parameter of `SignalStr' member `DisplayOutputTiming' to describe",SignalStrDisplayOutputTimingMemberParamMenuMenuLine,
	0);

extern MenuLine EditSignalStrNodeMemberMenuMenuLine[];
static Menu EditSignalStrNodeMemberMenu
	("Describe member `Edit' of `SignalStr'",EditSignalStrNodeMemberMenuMenuLine,
	0);

extern MenuLine UnlinkSignalStrNodeMemberMenuMenuLine[];
static Menu UnlinkSignalStrNodeMemberMenu
	("Describe member `Unlink' of `SignalStr'",UnlinkSignalStrNodeMemberMenuMenuLine,
	0);

extern MenuLine NextFreeOutputSignalStrNodeMemberMenuMenuLine[];
static Menu NextFreeOutputSignalStrNodeMemberMenu
	("Describe member `NextFreeOutput' of `SignalStr'",NextFreeOutputSignalStrNodeMemberMenuMenuLine,
	0);

extern MenuLine SelectSignalStrMemberExecuteMenuLine[];
static Menu SelectSignalStrMemberExecute
	("Select a member of this `SignalStr' to execute",SelectSignalStrMemberExecuteMenuLine,
	0);

extern MenuLine ToIntegerNodeOptMenuMenuLine[];
static Menu ToIntegerNodeOptMenu
	("Options for `ToInteger'",ToIntegerNodeOptMenuMenuLine,
	0);

static DynamicMenu ToIntegerInstancesMenu
	("Select an Instance of `ToInteger' to describe or delete", 0,
	1);

extern MenuLine ToIntegerInstanceAccessMenuMenuLine[];
static Menu ToIntegerInstanceAccessMenu
	("Describe or delete an instance of  object `ToInteger'",ToIntegerInstanceAccessMenuMenuLine,
	0);

extern MenuLine ToMachNodeOptMenuMenuLine[];
static Menu ToMachNodeOptMenu
	("Options for `ToMach'",ToMachNodeOptMenuMenuLine,
	0);

static DynamicMenu ToMachInstancesMenu
	("Select an Instance of `ToMach' to describe or delete", 0,
	1);

extern MenuLine ToMachInstanceAccessMenuMenuLine[];
static Menu ToMachInstanceAccessMenu
	("Describe or delete an instance of  object `ToMach'",ToMachInstanceAccessMenuMenuLine,
	0);

extern MenuLine ToMachParamMenuMenuLine[];
static Menu ToMachParamMenu
	("Menu of Parameters for `ToMach' Object",ToMachParamMenuMenuLine,
	0);

extern MenuLine ToMachInstanceParamMenuMenuLine[];
static Menu ToMachInstanceParamMenu
	("Menu of Parameters for `ToMach' Object Instance",ToMachInstanceParamMenuMenuLine,
	0);

extern MenuLine TruncateNodeOptMenuMenuLine[];
static Menu TruncateNodeOptMenu
	("Options for `Truncate'",TruncateNodeOptMenuMenuLine,
	0);

static DynamicMenu TruncateInstancesMenu
	("Select an Instance of `Truncate' to describe or delete", 0,
	1);

extern MenuLine TruncateInstanceAccessMenuMenuLine[];
static Menu TruncateInstanceAccessMenu
	("Describe or delete an instance of  object `Truncate'",TruncateInstanceAccessMenuMenuLine,
	0);

extern MenuLine TruncateParamMenuMenuLine[];
static Menu TruncateParamMenu
	("Menu of Parameters for `Truncate' Object",TruncateParamMenuMenuLine,
	0);

extern MenuLine TruncateVariableMenuMenuLine[];
static Menu TruncateVariableMenu
	("Menu of Variables for Truncate Object",TruncateVariableMenuMenuLine,
	0);

extern MenuLine TruncateInstanceParamMenuMenuLine[];
static Menu TruncateInstanceParamMenu
	("Menu of Parameters for `Truncate' Object Instance",TruncateInstanceParamMenuMenuLine,
	0);

extern MenuLine TruncateInstanceVariableMenuMenuLine[];
static Menu TruncateInstanceVariableMenu
	("Menu of Variables for Truncate Object Instance",TruncateInstanceVariableMenuMenuLine,
	0);

extern MenuLine TruncateSetInstanceVariableMenuMenuLine[];
static Menu TruncateSetInstanceVariableMenu
	("Menu of Variables for Truncate Object Instance",TruncateSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine UniformNoiseNodeOptMenuMenuLine[];
static Menu UniformNoiseNodeOptMenu
	("Options for `UniformNoise'",UniformNoiseNodeOptMenuMenuLine,
	0);

static DynamicMenu UniformNoiseInstancesMenu
	("Select an Instance of `UniformNoise' to describe or delete", 0,
	1);

extern MenuLine UniformNoiseInstanceAccessMenuMenuLine[];
static Menu UniformNoiseInstanceAccessMenu
	("Describe or delete an instance of  object `UniformNoise'",UniformNoiseInstanceAccessMenuMenuLine,
	0);

extern MenuLine UniformNoiseParamMenuMenuLine[];
static Menu UniformNoiseParamMenu
	("Menu of Parameters for `UniformNoise' Object",UniformNoiseParamMenuMenuLine,
	0);

extern MenuLine UniformNoiseVariableMenuMenuLine[];
static Menu UniformNoiseVariableMenu
	("Menu of Variables for UniformNoise Object",UniformNoiseVariableMenuMenuLine,
	0);

extern MenuLine UniformNoiseInstanceParamMenuMenuLine[];
static Menu UniformNoiseInstanceParamMenu
	("Menu of Parameters for `UniformNoise' Object Instance",UniformNoiseInstanceParamMenuMenuLine,
	0);

extern MenuLine UniformNoiseInstanceVariableMenuMenuLine[];
static Menu UniformNoiseInstanceVariableMenu
	("Menu of Variables for UniformNoise Object Instance",UniformNoiseInstanceVariableMenuMenuLine,
	0);

extern MenuLine UniformNoiseSetInstanceVariableMenuMenuLine[];
static Menu UniformNoiseSetInstanceVariableMenu
	("Menu of Variables for UniformNoise Object Instance",UniformNoiseSetInstanceVariableMenuMenuLine,
	0);

extern MenuLine UnpackWordNodeOptMenuMenuLine[];
static Menu UnpackWordNodeOptMenu
	("Options for `UnpackWord'",UnpackWordNodeOptMenuMenuLine,
	0);

static DynamicMenu UnpackWordInstancesMenu
	("Select an Instance of `UnpackWord' to describe or delete", 0,
	1);

extern MenuLine UnpackWordInstanceAccessMenuMenuLine[];
static Menu UnpackWordInstanceAccessMenu
	("Describe or delete an instance of  object `UnpackWord'",UnpackWordInstanceAccessMenuMenuLine,
	0);

extern MenuLine UnpackWordParamMenuMenuLine[];
static Menu UnpackWordParamMenu
	("Menu of Parameters for `UnpackWord' Object",UnpackWordParamMenuMenuLine,
	0);

extern MenuLine UnpackWordInstanceParamMenuMenuLine[];
static Menu UnpackWordInstanceParamMenu
	("Menu of Parameters for `UnpackWord' Object Instance",UnpackWordInstanceParamMenuMenuLine,
	0);

extern MenuLine VoiceNodeNodeOptMenuMenuLine[];
static Menu VoiceNodeNodeOptMenu
	("Options for `VoiceNode'",VoiceNodeNodeOptMenuMenuLine,
	0);

extern MenuLine SelectVoiceNodeMemberDescribeMenuLine[];
static Menu SelectVoiceNodeMemberDescribe
	("Select a member of `VoiceNode' to describe",SelectVoiceNodeMemberDescribeMenuLine,
	0);

extern MenuLine DisplayHeaderVoiceNodeNodeMemberMenuMenuLine[];
static Menu DisplayHeaderVoiceNodeNodeMemberMenu
	("Describe member `DisplayHeader' of `VoiceNode'",DisplayHeaderVoiceNodeNodeMemberMenuMenuLine,
	0);

static DynamicMenu VoiceNodeInstancesMenu
	("Select an Instance of `VoiceNode'", 0,
	1);

extern MenuLine VoiceNodeInstanceAccessMenuMenuLine[];
static Menu VoiceNodeInstanceAccessMenu
	("Operations on an instance of  object `VoiceNode'",VoiceNodeInstanceAccessMenuMenuLine,
	0);

extern MenuLine SelectVoiceNodeMemberExecuteMenuLine[];
static Menu SelectVoiceNodeMemberExecute
	("Select a member of this `VoiceNode' to execute",SelectVoiceNodeMemberExecuteMenuLine,
	0);

extern MenuLine VoiceNodeParamMenuMenuLine[];
static Menu VoiceNodeParamMenu
	("Menu of Parameters for `VoiceNode' Object",VoiceNodeParamMenuMenuLine,
	0);

extern MenuLine VoiceNodeInstanceParamMenuMenuLine[];
static Menu VoiceNodeInstanceParamMenu
	("Menu of Parameters for `VoiceNode' Object Instance",VoiceNodeInstanceParamMenuMenuLine,
	0);

extern MenuLine VoiceStripOutNodeOptMenuMenuLine[];
static Menu VoiceStripOutNodeOptMenu
	("Options for `VoiceStripOut'",VoiceStripOutNodeOptMenuMenuLine,
	0);

static DynamicMenu VoiceStripOutInstancesMenu
	("Select an Instance of `VoiceStripOut' to describe or delete", 0,
	1);

extern MenuLine VoiceStripOutInstanceAccessMenuMenuLine[];
static Menu VoiceStripOutInstanceAccessMenu
	("Describe or delete an instance of  object `VoiceStripOut'",VoiceStripOutInstanceAccessMenuMenuLine,
	0);

extern MenuLine VoiceStripOutParamMenuMenuLine[];
static Menu VoiceStripOutParamMenu
	("Menu of Parameters for `VoiceStripOut' Object",VoiceStripOutParamMenuMenuLine,
	0);

extern MenuLine VoiceStripOutInstanceParamMenuMenuLine[];
static Menu VoiceStripOutInstanceParamMenu
	("Menu of Parameters for `VoiceStripOut' Object Instance",VoiceStripOutInstanceParamMenuMenuLine,
	0);

extern MenuLine ZFde0NodeOptMenuMenuLine[];
static Menu ZFde0NodeOptMenu
	("Options for `ZFde0'",ZFde0NodeOptMenuMenuLine,
	0);

static DynamicMenu ZFde0InstancesMenu
	("Select an Instance of `ZFde0' to describe or delete", 0,
	1);

extern MenuLine ZFde0InstanceAccessMenuMenuLine[];
static Menu ZFde0InstanceAccessMenu
	("Describe or delete an instance of  object `ZFde0'",ZFde0InstanceAccessMenuMenuLine,
	0);

extern MenuLine ZFde0ParamMenuMenuLine[];
static Menu ZFde0ParamMenu
	("Menu of Parameters for `ZFde0' Object",ZFde0ParamMenuMenuLine,
	0);

extern MenuLine ZFde0InstanceParamMenuMenuLine[];
static Menu ZFde0InstanceParamMenu
	("Menu of Parameters for `ZFde0' Object Instance",ZFde0InstanceParamMenuMenuLine,
	0);

extern MenuLine ZFde1NodeOptMenuMenuLine[];
static Menu ZFde1NodeOptMenu
	("Options for `ZFde1'",ZFde1NodeOptMenuMenuLine,
	0);

static DynamicMenu ZFde1InstancesMenu
	("Select an Instance of `ZFde1' to describe or delete", 0,
	1);

extern MenuLine ZFde1InstanceAccessMenuMenuLine[];
static Menu ZFde1InstanceAccessMenu
	("Describe or delete an instance of  object `ZFde1'",ZFde1InstanceAccessMenuMenuLine,
	0);

extern MenuLine ZFde1ParamMenuMenuLine[];
static Menu ZFde1ParamMenu
	("Menu of Parameters for `ZFde1' Object",ZFde1ParamMenuMenuLine,
	0);

extern MenuLine ZFde1VariableMenuMenuLine[];
static Menu ZFde1VariableMenu
	("Menu of Variables for ZFde1 Object",ZFde1VariableMenuMenuLine,
	0);

extern MenuLine ZFde1InstanceParamMenuMenuLine[];
static Menu ZFde1InstanceParamMenu
	("Menu of Parameters for `ZFde1' Object Instance",ZFde1InstanceParamMenuMenuLine,
	0);

extern MenuLine ZFde1InstanceVariableMenuMenuLine[];
static Menu ZFde1InstanceVariableMenu
	("Menu of Variables for ZFde1 Object Instance",ZFde1InstanceVariableMenuMenuLine,
	0);

extern MenuLine ZFde1SetInstanceVariableMenuMenuLine[];
static Menu ZFde1SetInstanceVariableMenu
	("Menu of Variables for ZFde1 Object Instance",ZFde1SetInstanceVariableMenuMenuLine,
	0);

OrphanedMenus TheOrphanedMenus[] = {
	{"SelectDisplayNodeStrMemberDescribe", &SelectDisplayNodeStrMemberDescribe},
	{"SelectDisplayNodeStrMemberExecute", &SelectDisplayNodeStrMemberExecute},
	{"SelectProcessNodeStrMemberDescribe", &SelectProcessNodeStrMemberDescribe},
	{"SelectProcessNodeStrMemberExecute", &SelectProcessNodeStrMemberExecute},
	{"SelectSignalStrMemberDescribe", &SelectSignalStrMemberDescribe},
	{"SelectSignalStrMemberExecute", &SelectSignalStrMemberExecute},
	{0,0}
};

DynamicMenuInfo TheRemoteDynamicMenuTable[] = {
	{&ExampleMenu,
		{ 0,
	"Select this network",
	MenuTypeMenu, (void *) &ExampOptMenu},
	"ExampleMenu"	},
	{&AddInstancesMenu,
		{ 0,
	"Select this instance of `Add'",
	MenuTypeMenu, (void *) &AddInstanceAccessMenu},
	"AddInstancesMenu"	},
	{&AsciiFileInstancesMenu,
		{ 0,
	"Select this instance of `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileInstanceAccessMenu},
	"AsciiFileInstancesMenu"	},
	{&BlockInstancesMenu,
		{ 0,
	"Select this instance of `Block'",
	MenuTypeMenu, (void *) &BlockInstanceAccessMenu},
	"BlockInstancesMenu"	},
	{&CircBufDesInstancesMenu,
		{ 0,
	"Select this instance of `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesInstanceAccessMenu},
	"CircBufDesInstancesMenu"	},
	{&CompareDiskInstancesMenu,
		{ 0,
	"Select this instance of `CompareDisk'",
	MenuTypeMenu, (void *) &CompareDiskInstanceAccessMenu},
	"CompareDiskInstancesMenu"	},
	{&ConstantDataInstancesMenu,
		{ 0,
	"Select this instance of `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataInstanceAccessMenu},
	"ConstantDataInstancesMenu"	},
	{&CosInstancesMenu,
		{ 0,
	"Select this instance of `Cos'",
	MenuTypeMenu, (void *) &CosInstanceAccessMenu},
	"CosInstancesMenu"	},
	{&CxCosInstancesMenu,
		{ 0,
	"Select this instance of `CxCos'",
	MenuTypeMenu, (void *) &CxCosInstanceAccessMenu},
	"CxCosInstancesMenu"	},
	{&CxFFTInstancesMenu,
		{ 0,
	"Select this instance of `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTInstanceAccessMenu},
	"CxFFTInstancesMenu"	},
	{&CxFirInstancesMenu,
		{ 0,
	"Select this instance of `CxFir'",
	MenuTypeMenu, (void *) &CxFirInstanceAccessMenu},
	"CxFirInstancesMenu"	},
	{&CxImpInstancesMenu,
		{ 0,
	"Select this instance of `CxImp'",
	MenuTypeMenu, (void *) &CxImpInstanceAccessMenu},
	"CxImpInstancesMenu"	},
	{&DataFlowInstancesMenu,
		{ 0,
	"Select this instance of `DataFlow'",
	MenuTypeMenu, (void *) &DataFlowInstanceAccessMenu},
	"DataFlowInstancesMenu"	},
	{&DemodInstancesMenu,
		{ 0,
	"Select this instance of `Demod'",
	MenuTypeMenu, (void *) &DemodInstanceAccessMenu},
	"DemodInstancesMenu"	},
	{&DemuxInstancesMenu,
		{ 0,
	"Select this instance of `Demux'",
	MenuTypeMenu, (void *) &DemuxInstanceAccessMenu},
	"DemuxInstancesMenu"	},
	{&EyePlotInstancesMenu,
		{ 0,
	"Select this instance of `EyePlot'",
	MenuTypeMenu, (void *) &EyePlotInstanceAccessMenu},
	"EyePlotInstancesMenu"	},
	{&FindStartTailInstancesMenu,
		{ 0,
	"Select this instance of `FindStartTail'",
	MenuTypeMenu, (void *) &FindStartTailInstanceAccessMenu},
	"FindStartTailInstancesMenu"	},
	{&GainInstancesMenu,
		{ 0,
	"Select this instance of `Gain'",
	MenuTypeMenu, (void *) &GainInstanceAccessMenu},
	"GainInstancesMenu"	},
	{&GainPadInstancesMenu,
		{ 0,
	"Select this instance of `GainPad'",
	MenuTypeMenu, (void *) &GainPadInstanceAccessMenu},
	"GainPadInstancesMenu"	},
	{&HexListInstancesMenu,
		{ 0,
	"Select this instance of `HexList'",
	MenuTypeMenu, (void *) &HexListInstanceAccessMenu},
	"HexListInstancesMenu"	},
	{&ImportDataInstancesMenu,
		{ 0,
	"Select this instance of `ImportData'",
	MenuTypeMenu, (void *) &ImportDataInstanceAccessMenu},
	"ImportDataInstancesMenu"	},
	{&InputNodeInstancesMenu,
		{ 0,
	"Select this instance of `InputNode'",
	MenuTypeMenu, (void *) &InputNodeInstanceAccessMenu},
	"InputNodeInstancesMenu"	},
	{&InputWordInstancesMenu,
		{ 0,
	"Select this instance of `InputWord'",
	MenuTypeMenu, (void *) &InputWordInstanceAccessMenu},
	"InputWordInstancesMenu"	},
	{&IntegrateInstancesMenu,
		{ 0,
	"Select this instance of `Integrate'",
	MenuTypeMenu, (void *) &IntegrateInstanceAccessMenu},
	"IntegrateInstancesMenu"	},
	{&InterpolateInstancesMenu,
		{ 0,
	"Select this instance of `Interpolate'",
	MenuTypeMenu, (void *) &InterpolateInstanceAccessMenu},
	"InterpolateInstancesMenu"	},
	{&ListingInstancesMenu,
		{ 0,
	"Select this instance of `Listing'",
	MenuTypeMenu, (void *) &ListingInstanceAccessMenu},
	"ListingInstancesMenu"	},
	{&MaskWordInstancesMenu,
		{ 0,
	"Select this instance of `MaskWord'",
	MenuTypeMenu, (void *) &MaskWordInstanceAccessMenu},
	"MaskWordInstancesMenu"	},
	{&MuxInstancesMenu,
		{ 0,
	"Select this instance of `Mux'",
	MenuTypeMenu, (void *) &MuxInstanceAccessMenu},
	"MuxInstancesMenu"	},
	{&NetworkInstancesMenu,
		{ 0,
	"Select this instance of `Network'",
	MenuTypeMenu, (void *) &NetworkInstanceAccessMenu},
	"NetworkInstancesMenu"	},
	{&NormalInstancesMenu,
		{ 0,
	"Select this instance of `Normal'",
	MenuTypeMenu, (void *) &NormalInstanceAccessMenu},
	"NormalInstancesMenu"	},
	{&OutputNodeInstancesMenu,
		{ 0,
	"Select this instance of `OutputNode'",
	MenuTypeMenu, (void *) &OutputNodeInstanceAccessMenu},
	"OutputNodeInstancesMenu"	},
	{&OutputWordInstancesMenu,
		{ 0,
	"Select this instance of `OutputWord'",
	MenuTypeMenu, (void *) &OutputWordInstanceAccessMenu},
	"OutputWordInstancesMenu"	},
	{&PackWordInstancesMenu,
		{ 0,
	"Select this instance of `PackWord'",
	MenuTypeMenu, (void *) &PackWordInstanceAccessMenu},
	"PackWordInstancesMenu"	},
	{&PlotInstancesMenu,
		{ 0,
	"Select this instance of `Plot'",
	MenuTypeMenu, (void *) &PlotInstanceAccessMenu},
	"PlotInstancesMenu"	},
	{&PowerInstancesMenu,
		{ 0,
	"Select this instance of `Power'",
	MenuTypeMenu, (void *) &PowerInstanceAccessMenu},
	"PowerInstancesMenu"	},
	{&RampInstancesMenu,
		{ 0,
	"Select this instance of `Ramp'",
	MenuTypeMenu, (void *) &RampInstanceAccessMenu},
	"RampInstancesMenu"	},
	{&ReadFloatInstancesMenu,
		{ 0,
	"Select this instance of `ReadFloat'",
	MenuTypeMenu, (void *) &ReadFloatInstanceAccessMenu},
	"ReadFloatInstancesMenu"	},
	{&ReadIntInstancesMenu,
		{ 0,
	"Select this instance of `ReadInt'",
	MenuTypeMenu, (void *) &ReadIntInstanceAccessMenu},
	"ReadIntInstancesMenu"	},
	{&RealFirInstancesMenu,
		{ 0,
	"Select this instance of `RealFir'",
	MenuTypeMenu, (void *) &RealFirInstanceAccessMenu},
	"RealFirInstancesMenu"	},
	{&RepackStreamInstancesMenu,
		{ 0,
	"Select this instance of `RepackStream'",
	MenuTypeMenu, (void *) &RepackStreamInstanceAccessMenu},
	"RepackStreamInstancesMenu"	},
	{&SampleDelayInstancesMenu,
		{ 0,
	"Select this instance of `SampleDelay'",
	MenuTypeMenu, (void *) &SampleDelayInstanceAccessMenu},
	"SampleDelayInstancesMenu"	},
	{&ToIntegerInstancesMenu,
		{ 0,
	"Select this instance of `ToInteger'",
	MenuTypeMenu, (void *) &ToIntegerInstanceAccessMenu},
	"ToIntegerInstancesMenu"	},
	{&ToMachInstancesMenu,
		{ 0,
	"Select this instance of `ToMach'",
	MenuTypeMenu, (void *) &ToMachInstanceAccessMenu},
	"ToMachInstancesMenu"	},
	{&TruncateInstancesMenu,
		{ 0,
	"Select this instance of `Truncate'",
	MenuTypeMenu, (void *) &TruncateInstanceAccessMenu},
	"TruncateInstancesMenu"	},
	{&UniformNoiseInstancesMenu,
		{ 0,
	"Select this instance of `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseInstanceAccessMenu},
	"UniformNoiseInstancesMenu"	},
	{&UnpackWordInstancesMenu,
		{ 0,
	"Select this instance of `UnpackWord'",
	MenuTypeMenu, (void *) &UnpackWordInstanceAccessMenu},
	"UnpackWordInstancesMenu"	},
	{&VoiceNodeInstancesMenu,
		{ 0,
	"Select this instance of `VoiceNode'",
	MenuTypeMenu, (void *) &VoiceNodeInstanceAccessMenu},
	"VoiceNodeInstancesMenu"	},
	{&VoiceStripOutInstancesMenu,
		{ 0,
	"Select this instance of `VoiceStripOut'",
	MenuTypeMenu, (void *) &VoiceStripOutInstanceAccessMenu},
	"VoiceStripOutInstancesMenu"	},
	{&ZFde0InstancesMenu,
		{ 0,
	"Select this instance of `ZFde0'",
	MenuTypeMenu, (void *) &ZFde0InstanceAccessMenu},
	"ZFde0InstancesMenu"	},
	{&ZFde1InstancesMenu,
		{ 0,
	"Select this instance of `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1InstanceAccessMenu},
	"ZFde1InstancesMenu"	},
	0
};

#endif /* #ifndef MENUTAB_DOT_H*/
