/*
 *  intfccom.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  intfccom.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef INTFCCOM_DOT_H
#define INTFCCOM_DOT_H
#include "ObjProComGui/callback.h"
#include "ObjProGen/slist.h"
#include "ObjProShare/shared.h"

struct PacketHeader ;
class CallBackList ;

class InterfaceController {
	int CallBackId ;
	CallBackList * TheCallBacks ;
public:
	InterfaceController() ;

	// Remote servers
	void Server(PacketHeader& Head, const char * Data);
		// Gets a message from remote sender
	void ReturnServer(int Id, ReturnCallBackAction, int, const char *);
		// Server for CallBacks
	void ActionServer(int Id, DoCallBackAction,     int, const char *);
		// Server for messages that require a return
	void ActionNoReturnServer(DoActionNoCallBack Action,
		int RemSize, const char * Data) ;
		// Server for messages that do not require a return

	// Execute a call back routine
	void DoReturn(int Id, int Size, const char * Data);

	// Send a packet to remote server
	void SendPacket(ReturnCallBack DoCall, DoCallBackAction Action,
		int Flag, const char * Name);
	void SendPacket(ReturnCallBack DoCall, DoCallBackAction Action);
	void SendPacket(DoActionNoCallBack Action, const char * String) ;
		
	// Send a return packet to remote server
	void SendReturnPacket(int Id, ReturnCallBackAction, int Val);
	void SendReturnPacketSaveId(int Id, ReturnCallBackAction, int Val);

	// Manage call back list
	int IncrementCallBackId() {return CallBackId++;}
	CallBackList * GetTheCallBacks() {return TheCallBacks;}
};

class CallBackEntry {
	int CallBackId;
	ReturnCallBack TheCall ;
public:
	CallBackEntry(int id, ReturnCallBack call)
		{CallBackId = id; TheCall = call; }
	int GetId() {return CallBackId;}
	ReturnCallBack GetCall() {return TheCall;}
};

class CallBackList: public SingleList {
public:
	ErrCode Insert(CallBackEntry *nt) {return SingleList::Insert(nt);}
	ErrCode Append(CallBackEntry *nt) {return SingleList::Append(nt);}
	CallBackEntry * Get()   {return (CallBackEntry *) SingleList::Get();}
	CallBackEntry * Pop() {return (CallBackEntry *) SingleList::Pop();}
	CallBackList(){}
	int Size(){return SingleList::Size();}
	ReturnCallBack GetCallBack(int id);
} ;

class CallBackListIterator: public SingleListIterator {
public:
	CallBackListIterator(CallBackList& df):
		SingleListIterator((SingleList&) df){}
	CallBackEntry * operator()()
		{return (CallBackEntry *) Next();}
};


#endif /* #ifdef INTFCCOM_DOT_H */
