/*
 *  bits.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  bits.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

#include "ObjProDSP/portable.h"

class GetBits {
	uint32 * Words ;
	int LastRead ;
	int MaxBits ;
	int WordIndex () {return LastRead >> 5 ;}
	int BitIndex () { return LastRead - (WordIndex() << 5) ; }
	uint32 BitMask () { return 1 << (31 - BitIndex()) ;}
public:
	GetBits& Reset() {LastRead = -1 ; return *this;}
	GetBits(int m, uint32 * w) {MaxBits = m;
		Words = w ; Reset() ;}
	GetBits(const GetBits& bits) ;
	int NextBit() ;
	void SetBit(int bit);
	void Display() ;
	uint32 GetWord(int i) const ;
	int GetMaxBits() const {return MaxBits;}
	GetBits& operator|=(const GetBits& bit);
} ;

