/*
 *  rlfir.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef RLFIR_DOT_H
#define RLFIR_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class RealFir: public TargetNode {
#line 103 "../rlfir.usr"
 
	class RealFilter * TheFilter ;
#line 23 "/dist/opd_2/opd-0.2/src/include/ObjProDSPtar/ObjProUsr/rlfir.h"
	int16  Resample_1;
	int16  ZeroPad_2;
	int16  Odd_3;
	MachWord *  Coeff_4;
	int32 Coeff_Length_5;
public:
	RealFir (const char * Name, int16 Resample, int16 ZeroPad, int16 Odd, 
		MachWord * Coeff, int32 Coeff_Length,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~RealFir();
	int16 GetResample() const {return Resample_1;}
	int16 GetZeroPad() const {return ZeroPad_2;}
	int16 GetOdd() const {return Odd_3;}
	MachWord * GetCoeff() const {return Coeff_4;}
	int32 GetCoeff_Length() const {return Coeff_Length_5;}
	virtual ErrCode DoNode(int32);
};

extern RealFir * RealFirDef;

	extern MachWordType TheDataForRealFirCoeffDefaultArray[];


#endif /* #ifdef RLFIR_DOT_H */
