/*
 *  block.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef BLOCK_DOT_H
#define BLOCK_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class Block: public TargetNode {
#line 71 "../block.usr"
 
	enum convert_type {undefined,no_conversion, float_to_int,
		int_to_float} ;
#ifdef INTERACTIVE 
	int InitAfterLinked(); 
	void input_linked(int in_channel);
	void static_ctor();
#endif
	void ctor();
	ErrCode kernel(int32 k);
#line 31 "/dist/opd_2/opd-0.2/src/include/ObjProDSPtar/ObjProUsr/block.h"
	int the_convert_type ;
	int16  ElementSize_1;
	int16  BlockSize_2;
	int16  OutputArithmetic_3;
public:
	Block (const char * Name, int16 ElementSize, int16 BlockSize, 
		int16 OutputArithmetic,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay,
		int BlockStaticInitthe_convert_type);
	virtual ~Block();
	int16 GetElementSize() const {return ElementSize_1;}
	int16 GetBlockSize() const {return BlockSize_2;}
	int16 GetOutputArithmetic() const {return OutputArithmetic_3;}
	virtual ErrCode DoNode(int32);
};

extern Block * BlockDef;


#endif /* #ifdef BLOCK_DOT_H */
