/*
 *  gpltstr.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef GPLTSTR_DOT_H
#define GPLTSTR_DOT_H
#include "ObjProDSPcom/genpltdef.h"
#include "ObjProComGui/plotdat.h"
#include "ObjProDSP/pltenm.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/plotnd.h"

class GenericPlotStr: public PlotNode {
#line 36 "../gpltstr.usr"
 
	AxisScalingX XScale ;
	AxisScalingY YScale ;
	int PlotId ;
	int16 ElementSize ;
	int16 Channels ;
	const char * PlotCaption ;
	virtual void SendChannelHeader(int Channel,DataPlotHeader * Head) ;
#line 32 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/gpltstr.h"
	int16  In_1;
	StreamStr* StreamIn_2;
	const char *  Caption_3;
	double  Min_4;
	double  Max_5;
	double  MinimumX_6;
	double  MaximumX_7;
	int16  NumberBlocks_8;
	int16  ScaleFlag_9;
	TimingType  TheTimingType_10;
	PlotDynType  DynamicType_11;
	double  XYSamplesPerPlot_12;
	PlottingStreamType  StreamType_13;
public:
	GenericPlotStr (const char * Name, int16 In, StreamStr*StreamIn, 
		const char * Caption, double Min, double Max, 
		double MinimumX, double MaximumX, int16 NumberBlocks, 
		int16 ScaleFlag, TimingType TheTimingType, 
		PlotDynType DynamicType, double XYSamplesPerPlot, 
		PlottingStreamType StreamType);
	virtual ~GenericPlotStr();
	int16 GetIn() const {return In_1;}
	StreamStr*GetStreamIn() const {return StreamIn_2;}
	const char * GetCaption() const {return Caption_3;}
	double GetMin() const {return Min_4;}
	double GetMax() const {return Max_5;}
	double GetMinimumX() const {return MinimumX_6;}
	double GetMaximumX() const {return MaximumX_7;}
	int16 GetNumberBlocks() const {return NumberBlocks_8;}
	int16 GetScaleFlag() const {return ScaleFlag_9;}
	TimingType GetTheTimingType() const {return TheTimingType_10;}
	PlotDynType GetDynamicType() const {return DynamicType_11;}
	double GetXYSamplesPerPlot() const {return XYSamplesPerPlot_12;}
	PlottingStreamType GetStreamType() const {return StreamType_13;}
	virtual int CheckSafeDelete() ;
#line 45 "../gpltstr.usr"
	void DynamicInit();
	GenericPlotStr(int32 BlockSize, int16 NumberBlocks,
		double XMin , double XMax, const char * Name,
		int32 ElementSize = 1, const char * capt = 0,
		double minY = 0.0, double maxY = 0.0,
		int scale_flag=0);
	virtual void SendHeader();
#line 76 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/gpltstr.h"
};


#endif /* #ifdef GPLTSTR_DOT_H */
