/*
 *  bitsin.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef BITSIN_DOT_H
#define BITSIN_DOT_H
#include "ObjProArith/hrdarth.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class BitsInNode: public Signal {
#line 30 "../bitsin.usr"
 
	class BinaryInputFile * TheInputFile ;
#line 24 "/home/paul/opd_root/src/include/ObjProDSPint/ObjProUsr/bitsin.h"
	const char *  FileName_1;
	int16  WordSize_2;
public:
	BitsInNode (const char * Name, const char * FileName, int16 WordSize);
	virtual ~BitsInNode();
	const char * GetFileName() const {return FileName_1;}
	int16 GetWordSize() const {return WordSize_2;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
};

extern BitsInNode * BitsInNodeDef;


#endif /* #ifdef BITSIN_DOT_H */
