/*
 *  drvintfc.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DRVINTFC_DOT_H
#define DRVINTFC_DOT_H
#include "ObjProGen/errcode.h"
#include "ObjProArith/hrdarth.h"

// This is an interface to a generic driver to simulate the following:
//	1. Generation of internally created data at various check points.
//	2. End of Data condition
//      Access to disk file data is indirectly through this function.
// 	The default version reads the data from disk and gets and
//	EndOfData from end of file.


typedef int32 (*DriverInputInterface)(class InputNode *, int Chan, int32 Size,
	MachWord * Data);

int32 DefaultDriverInputInterface(InputNode *, int chan, int32 Size,
	MachWord * Data ) ; 

const ResetReaderSystemInterface = -1 ;

#endif /* #ifdef DRVINTFC_DOT_H */
