/*
 *  rd_scr.l from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%{
#undef yywrap
#include "playback.h"
#include <stream.h>
#include <fstream.h>
extern "C" {
#include <stdio.h>
}
#include <string.h>
#include "cgidbg.h"
#include "portable.h"
#include "y.tab.h"
#include "lexnum.h"
#ifdef SCO_NO_ALLOCA
#include <malloc.h>
#define alloca malloc
#endif


#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) yy_input_opd(buf,result)
const buf_size=2048 ;
static char line_buf[buf_size+1];
static int buf_ix =0 ;

	static char * remove_quote(const char * x)
	{
		int length = strlen(x);
		char * ret = new char[length -1];
		for (int i = 0 ; i < length -2; i++) ret[i] = x[i+1];
		ret[i] = '\0' ;
		return ret ;
	}



	static int yywrap()
	{
		return ManagedKeyboards::manager()->yywrap();
	}

	static void yyerror(const char* s1, const char* s2 = 0,const char* s3 = 0,
		const char* s4 = 0, const char* s5=0)
	{
		ManagedKeyboards::manager()->yyerror(s1,s2,s3,s4,s5);
	}

	static void yy_input_opd(char * buf, int& result)
	{
		int c = ManagedKeyboards::manager()->mygetc();
		if (buf_ix < buf_size) if (c) line_buf[buf_ix++]= c;
		if (c == '\n') {
			line_buf[buf_ix++] = '\0';
			// LogOut << "V-read: " << line_buf ;
			buf_ix= 0 ;
		}
		result = (c == EOF) ? YY_NULL : (buf[0] = c, 1);
	}
%}
%%
\#.*\n		|
\n			{
				ManagedKeyboards::manager()->new_line(); /* Skip newline */
				return NEWLINE ;
			}
[ \t]+				; /* Skip white space */
0[0-7]*				{
					// Found("Oct",yytext);
					yylval.integer = OctConvert(yytext);
					return INTEGER ;
				}
[1-9][0-9]*			{
					// Found("integer",yytext);
					yylval.integer = IntConvert(yytext);
					return INTEGER ;
				}
0[xX][0-9a-fA-F]* 		{	
					// Found("Hex",yytext);
					yylval.integer = HexConvert(yytext+2);
					return INTEGER ;
				}
\"([^\"\n\\]|\\\.)*\"		{
					yylval.string =remove_quote(yytext) ;
					return STRING ;
				}
Mouse			{
					yylval.reserved = MOUSE ;
					return MOUSE ;
				}
Action			{
					yylval.reserved = ACTION ;
					return ACTION ;
				}
Key				{
					yylval.reserved = KEY ;
					return KEY ;
				}
Prompt			{
					yylval.reserved = PROMPT ;
					return PROMPT ;
				}
MenuText		{
					yylval.reserved = MENU ;
					return MENU ;
				}
DppText			{
					yylval.reserved = DPP ;
					return DPP ;
				}
MenuState		{
					yylval.reserved = MENU_STATE ;
					return MENU_STATE ;
				}
"-"				|
","				|
"("				|
")"				|
"{"				|
"}"				|
":"				{
					// Found("Char",yytext);
					return yytext[0] ;
				}
<<EOF>>			return -1 ;
.				{
					ManagedKeyboards::manager()->illegal(yytext[0]);
					return yytext[0] ;
				}
