/*
 *  xk_tab.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "portable.h"
class X_CharacterTable ;
class X_AliasTable ;
class ivEvent ;


class ShiftTable {
	const shift_table_size = 128 ;
    char table[shift_table_size] ;
	char un_table[shift_table_size];
public:
    ShiftTable();
    char shift(char x) {return table[x& 0x7f];}
	char un_shift(char x) {return un_table[x& 0x7f];}
} ;



class X_Character {
	X_CharacterTable * character_table;
	X_AliasTable * alias_table ;
public:
	X_Character(X_CharacterTable * char_tab, X_AliasTable * alias_tab);
	const char * name(uint32 c);
	uint32 alias_of(uint32 c);
	static X_Character& table();
	enum MouseCode {left=1, middle=2, right=4, any = 512, shift = 1024,
		ctrl = 2048, down = 4096};
	static const char * name_of_mouse_code(uint32 code);
	static const int * mouse_code_to_index_array(uint32 code);
	static int32 mouse_code(const ivEvent& e, int down_flag = 0);
	static int mouse_table_size() ;
	static ShiftTable shift_table ;
};
//  XK_built_in_ is used in print_win.C
#define XK_built_in_ 0x40000
#define XK_c_	((uint32) 0x0010000L)
#define XK_s_	((uint32) 0x20000)
#define XK_mask ((uint32) 0xffff0000)


