/*
 *  iv_axis.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef IV_AXIS_DOT_H
#define IV_AXIS_DOT_H
/*
 * Axis - position tick marks as on axis
 */


#include <InterViews/monoglyph.h>
#include <InterViews/background.h>
#include "iv_graph.h"

class Page;
class Graph ;
class Color ;
class Font ;

class TickMarks {
public:
	int num ;
	double first ;
	double increment ;
	char ** strings ;
	TickMarks();
	virtual ~TickMarks();
	void clear() ;
	void set(int n, double f, double i, int is_y);
	void dump() const ;
	int max_length() const ;
};

class Axis : public Background {
public:
    virtual void allocate(Canvas*, const Allocation&, Extension&);
	virtual void draw(Canvas*, const Allocation&) const ;
	const TickMarks& tick_marks() const ;
	virtual int check_redraw() = 0 ;
	virtual void redraw() = 0 ;
	virtual void write_ticks() const = 0 ;
	virtual void check_change();
protected:
    Axis(Graph * gr, int y_flag=0);
    virtual ~Axis();
	void write(const char * str, Coord x, Coord y) const ;
	void do_damage();

    Allocation _a;
	Canvas * canvas;

    double * _first;
    double * _last;
	Graph * graph ;
	int is_y ;
	Coord char_inc ;
	Coord char_width ;
	Coord char_height ;
	const Font * char_font ;
	const Color * char_color ;
	TickMarks * ticks ;
};

class YAxis : public Axis {
public:
    YAxis(Graph *gr );
    virtual void request (Requisition& r) const;
	virtual Coord length() const ;
	virtual void do_redraw() const ;
	virtual int check_redraw();
	virtual void redraw() ;
	int tick_positioning(Coord& base,Coord& inc) const ;
	virtual void write_ticks() const  ;
protected:
    virtual ~YAxis();
};

class XAxis : public Axis {
public:
    XAxis(Graph *gr);
    virtual void request (Requisition& r) const;
	virtual Coord length() const ;
	virtual void do_redraw() const ;
	virtual void redraw() ;
	virtual int check_redraw();
	int tick_positioning(Coord& base,Coord& inc) const ;
	virtual void write_ticks() const  ;
protected:
    virtual ~XAxis();
};

#endif /* #ifdef IV_AXIS_DOT_H */
