/*  examp.C   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <stdlib.h>
#include "examp.h"
#include "cgidbg.h"
#include "mkstr.h"
#include "dynmen.h"
#include "help.h"
#include "helpdir.h"
#include "dirfil.h"
#include "dsp_app.h"
#include "xdrv.h"
// #include "diskmgr.h"
// #include "winmgr.h"
#include "dynmnu.h"
#include "environ.h"
// #include "winpres.h"
// #include "textwin.h"

ExamplesDspPP * TheExamples = 0 ;
DirectoriesDspPP * TheDirectories = 0 ;
// char * HelpFileDirectory = 0 ;

static const char * GetRootDirectory()
{
	const char * RootName = "OPD_ROOT" ;
	const char * Root =  Environment::get(RootName);
	if (!Root) DbgError(
		"GetRootDirectory enviornment variable not set", RootName);
	return Root ;
}

static const char * GetExamplesDirectory(const char * Dir)
{
	const char * Return = AddSubDirectory(Dir,"examp");
	if (!Return) DbgError("GetExamplesDirectory","bad strings");
	return Return ;
}

static const char * GetHelpDirectory(const char * Dir)
{
	const char * Return = AddSubDirectory(Dir,"help");
	if (!Return) DbgError("GetHelpDirectory","bad strings");
	return Return ;
}

static const char * ExampleSuffix = ".xml" ;
static const char * HelpSuffix = ".hlp" ;

DirectoriesDspPP::DirectoriesDspPP():
	Root(GetRootDirectory()),
	Examples(GetExamplesDirectory(Root)),
	HelpFiles(GetHelpDirectory(Root)),
	Home( Environment::get("HOME"))
{
	HelpFileDirectory = Concatenate(HelpFiles,"/++++|++++|+++",HelpSuffix);
}

ExamplesDspPP::ExamplesDspPP()
{
	if (!TheDirectories) DbgError("ExamplesDspPP::ctor", "no dirs");
	// open examples directory
	ExamineDirectory& TheExamples =
		* new ExamineDirectory(TheDirectories->Examples, ExampleSuffix);
	// make examples menu
	const char * OneFile ;
	while (OneFile = TheExamples.NextFile()) {
		// LogOut << "Adding example " << OneFile << "\n" ;
		char * FileName = OpdRemoveDirectory(OneFile);
		char * ItemName = RemoveSuffix(OneFile,ExampleSuffix);
		delete FileName ;
		TheDynamicMenuServer.DoCommand(MenuServerNewMenuItem,
			"ExampleMenu", ItemName);
		delete ItemName ;
	}
}

void ExamplesDspPP::DescribeExample(const char * Examp) const 
{
	// LogOut << "ExamplesDspPP::DescribeExample(" << Examp << ")\n" ;
	// HelpDo.DisplayHelpFile(Examp);
	DspApplication::root_window()->display_help_file(Examp);
}

void ExamplesDspPP::ExecuteExample(const char * Examp, const char * Over) const 
{
	char * FileName = Concatenate(TheDirectories->Examples,
		"/",Examp,ExampleSuffix);
	// TheWindowsManager->ReadState(FileName,!strcmp(Over,"over"));
	DspApplication::root_window()->read_state(!strcmp(Over,"over"),FileName);
	delete FileName ;
}

void ExamplesDspPP::ReadExample(const char * Examp) const 
{
	const char * FileName = Concatenate(TheDirectories->Examples,
		"/",Examp,ExampleSuffix);
	int Lines ;
/*
 *	TextWindow * Cpp = TheWindowsManager->GetCppWindow() ;
 *	TextWindowPreserve * Pres = Cpp->GetPreserve();
 *	int32 Curr = Pres->GetCurrentAddress();
 *	Pres->GoToAddress(Curr - Lines + 1);
 *	if (Cpp->IsVisible()) Cpp->Home();
 *	TheDiskManager.DoAppendFile(FileName, Cpp, Lines);
 *	if (HelpDo.All()) *Output + OutputHelp << "Appended " << Lines <<
 *		" lines of example `" <<  Examp <<
 *		"' to the DSP++ statement window.\n";
 */
}

