/* $Header: /europe/fams/glenl/src/iv/ivdemo/RCS/blinker.c,v 1.1 92/06/30 10:42:01 glenl Exp Locker: glenl $ */
/*
 * Blinker --- a blinking label
 *
 * $Log:		blinker.c,v $
 * Revision 1.1  92/06/30  10:42:01  glenl
 * Initial revision
 * 
 */
#include <IV-look/kit.h>
#include <InterViews/action.h>
#include <InterViews/color.h>
#include <InterViews/deck.h>
#include <InterViews/label.h>
#include <InterViews/layout.h>
#include <InterViews/patch.h>
#include <InterViews/style.h>

#include "blinker.h"
// #include "stimer.h"

implementActionCallback(Blinker)

Blinker::Blinker(Glyph * normal, Glyph * blink_to, Style* s):
	MonoGlyph()
{
	WidgetKit& kit = *WidgetKit::instance();
	const LayoutKit& layout = *LayoutKit::instance();

	// make an arbitrary assumption about what will be blinking...
	const Color* main_color = kit.foreground();
	deck_ = layout.deck(
		normal,
		blink_to
	);
	deck_->flip_to(0);
	Resource::ref(deck_);

	patch_ = new Patch(deck_);
	Resource::ref(patch_);

	timer_ = 0 ;
//	long blink_interval = 1000; // 1-second default
//	s->find_attribute("blink_interval", blink_interval);
/*
 *	timer_ = new ShortTimer(blink_interval,
 *							new ActionCallback(Blinker)(
 *								this,
 *								&Blinker::blink)
 *	);
 */
	
	body(patch_);
}

void Blinker::blink()
{
/*
 *	GlyphIndex i = deck_->card() + 1;
 *	if (i == deck_->count())
 *		i = 0;
 *
 */
	deck_->flip_to(1);
	patch_->redraw();
}

void Blinker::start() {
	// timer_->start();
	blink();
}

void Blinker::stop() {
	// timer_->stop();
	deck_->flip_to(0);
	patch_->redraw();
}

Blinker::~Blinker() {
	// stop();
	// delete timer_;
	Resource::unref(deck_);
	Resource::unref(patch_);
}

