#include <InterViews/display.h>
#include <InterViews/window.h>
#include <InterViews/telltale.h>
#include <InterViews/event.h>

#include "hot_button.h"
#include "xdrv.h"
#include "cgidbg.h"
#include "dsp_app.h"
#include "menu.h"


DummyPushButtonAction dummy_push_action ;

void DummyPushButtonAction::execute()
{
	DbgError("DummyPushButtonAction::Execute","should not be called");
}

HotButton::HotButton(HotButton * but):
	ivButton(but->body(),but->style(),but->state(),&dummy_push_action),
	menu_line(but->line()),
	index(but->get_index()),
	is_menu_selection(but->menu_selection()),
	the_allocation(0),
	the_blinker(but->blinker()),
	the_glyph_index(but->glyph_index())
{
	Button::enter();
}

HotButton::HotButton(Blinker * bl, ivGlyph* g, ivStyle* s, ivTelltaleState* t,
	MenuViewLine& line, int ix):
	ivButton(g,s,t,&dummy_push_action),
	menu_line(line),
	index(ix),
	is_menu_selection(0),
	the_allocation(0),
	the_glyph_index(0),
	the_blinker(bl)
{
	Button::enter();
}

HotButton::~HotButton()
{
}

void HotButton::unselect()
{
	ivButton::enter();
	the_blinker->stop();
	redraw();
}

void HotButton::select()
{
	ivButton::enter();
	the_blinker->start();
	redraw();
}

void HotButton::allocate(ivCanvas *c, const ivAllocation& alloc, ivExtension&e)
{
	ivInputHandler::allocate(c,alloc,e);
}

const char * HotButton::name()
{
	return menu_line.get_unique_name(index);
}

void HotButton::enter()
{
	menu_line.set_mouse_selection(this);
	// LogOut << "HotButton::enter\n" ;
	// ivButton::enter();
	ivTelltaleState* s = state();
	if (s->test(ivTelltaleState::is_enabled)) {
 	   s->set(ivTelltaleState::is_visible, true);
    }
	menu_line.execute_enter(index);
}

void HotButton::down_state()
{
	// ivButton::enter();
	press();
}

void HotButton::local_leave(int call_base)
{
	// LogOut << "HotButton::local_leave(" << call_base << ")\n" ;
	if (!call_base) {
		ivTelltaleState* s = state();
		if (s->test(ivTelltaleState::is_enabled))
			s->set(ivTelltaleState::is_visible, false);
	}
	menu_line.execute_leave(index);
}

void HotButton::leave()
{
	if (!is_menu_selection) release();
	menu_line.clear_mouse_selection();
	local_leave(1);
}

void HotButton::press(const ivEvent&event)
{
	press();
	// LogOut << "HotButton::press\n" ;
	if (!DspApplication::user_input_allowed()) return ;
	menu_line.press(index, event, this);
}

void HotButton::press()
{
		state()->set(ivTelltaleState::is_active, true);
}

void HotButton::release()
{
	if (is_menu_selection) return ;
	state()->set(ivTelltaleState::is_active, false);
}

void HotButton::release(const ivEvent& event)
{
/*
 *	LogOut << "HotButton::release, L = " << event.left_is_down() <<
 *		", M = " << event.middle_is_down() << ", R = " << event.right_is_down()
 *		<< ", Shift = " << event.shift_is_down() << ", Control = " <<
 *		event.control_is_down() << "\n" ;
 */

/*** BEGIN modified Button::release ***/
	ivTelltaleState* s = state();
	// LogOut << "state = 0x" << hex << s << dec << "\n" ;
	if (s->test(ivTelltaleState::is_enabled)) {
		if (inside(event)) {
			menu_line.release(event);
		}
	}

/*** END modified Button::release ***/
	// LogOut << "state = 0x" << hex << s << dec << "\n" ;
}


void HotButton::peel_off_menu()
{
	menu_line.peel_off_menu(index);
}

void HotButton::raise_windows()
{
	menu_line.raise_windows(index);
}

void HotButton::create_default()
{
	menu_line.create_default(index);
}

void HotButton::create_instance()
{
	menu_line.create_instance(index);
}

void HotButton::do_command()
{
	menu_line.do_command(index);
}

void HotButton::help_paragraph()
{
	menu_line.help_paragraph(index);
}

void HotButton::cond_help_paragraph()
{
	menu_line.cond_help_paragraph(index);
}

void HotButton::help_file()
{
	menu_line.help_file(index);
}



